/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.showcase.ShowcaseMod;
import com.showcase.command.ShareCommandUtils;
import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfig;
import com.showcase.config.ModConfigManager;
import com.showcase.data.ShareEntry;
import com.showcase.listener.ChatMessageListener;
import com.showcase.utils.ChatPaginator;
import com.showcase.utils.ModMetadataHolder;
import com.showcase.utils.TextEventFactory;
import com.showcase.utils.TextUtils;
import com.showcase.utils.permissions.PermissionChecker;
import com.showcase.utils.permissions.Permissions;
import com.showcase.utils.ui.TextBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ShowcaseManageCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, String command) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)command).requires(src -> PermissionChecker.hasPermission((class_2172)src, "manage", 4))).then(ShowcaseManageCommand.createReloadCommand())).then(ShowcaseManageCommand.createListCommand())).then(ShowcaseManageCommand.createCancelCommand())).then(ShowcaseManageCommand.createAboutCommand())).then(ShowcaseManageCommand.createConfigCommands()));
    }

    private static LiteralArgumentBuilder<class_2168> createAboutCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"about").requires(src -> PermissionChecker.hasPermission((class_2172)src, Permissions.Manage.ABOUT, 0))).executes(ctx -> {
            class_3222 player = ShareCommandUtils.getSenderPlayer((CommandContext<class_2168>)ctx);
            BiConsumer<String, String> sendInfoLine = ShowcaseManageCommand.getStringStringBiConsumer(player);
            player.method_7353((class_2561)class_2561.method_43470((String)"=== Showcase Mod About ===").method_27692(class_124.field_1065), false);
            sendInfoLine.accept("Mod ID", ModMetadataHolder.MOD_ID);
            sendInfoLine.accept("Name", ModMetadataHolder.MOD_NAME);
            sendInfoLine.accept("Author", ModMetadataHolder.AUTHORS.stream().map(Person::getName).collect(Collectors.joining(", ")));
            sendInfoLine.accept("Version", ModMetadataHolder.VERSION);
            sendInfoLine.accept("Source Code", ModMetadataHolder.SOURCE);
            sendInfoLine.accept("Issues", ModMetadataHolder.ISSUES);
            sendInfoLine.accept("Homepage (CN)", ModMetadataHolder.HOMEPAGE);
            sendInfoLine.accept("License", ModMetadataHolder.LICENSE);
            player.method_7353((class_2561)class_2561.method_43470((String)"===========================").method_27692(class_124.field_1065), false);
            return 1;
        });
    }

    @NotNull
    private static BiConsumer<String, String> getStringStringBiConsumer(class_3222 player) {
        return (name, value) -> {
            class_5250 line = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080));
            if (value.startsWith("https://")) {
                line.method_10852((class_2561)TextBuilder.clickableWithConfig((class_2561)class_2561.method_43470((String)value.replaceAll("https://", "")), TextEventFactory.openUrl(value)).method_27694(style -> style.method_10977(class_124.field_1075)));
            } else {
                line.method_10852((class_2561)class_2561.method_43470((String)value).method_27692(class_124.field_1068));
            }
            player.method_7353((class_2561)line, false);
        };
    }

    private static LiteralArgumentBuilder<class_2168> createReloadCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(src -> PermissionChecker.hasPermission((class_2172)src, Permissions.Manage.RELOAD, 4))).executes(ctx -> {
            try {
                ModConfigManager.reloadConfig();
                ChatMessageListener.loadConfig();
                ((class_2168)ctx.getSource()).method_45068(TextUtils.success((class_2561)class_2561.method_43471((String)"showcase.message.reload.success")));
                return 1;
            }
            catch (Exception e) {
                ShowcaseMod.LOGGER.error("Failed to reload config", (Throwable)e);
                ((class_2168)ctx.getSource()).method_9213(TextUtils.error((class_2561)class_2561.method_43471((String)"showcase.message.reload.fail")));
                return 0;
            }
        });
    }

    private static LiteralArgumentBuilder<class_2168> createListCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(src -> PermissionChecker.hasPermission((class_2172)src, Permissions.Manage.LIST, 4))).executes(ctx -> ShowcaseManageCommand.executeListCommand(((class_2168)ctx.getSource()).method_9207(), 1))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int page = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page");
            return ShowcaseManageCommand.executeListCommand(((class_2168)ctx.getSource()).method_9207(), page);
        }));
    }

    private static int executeListCommand(class_3222 player, int page) {
        if (player == null) {
            return 0;
        }
        Map<String, ShareEntry> shares = ShowcaseManager.getUnmodifiableActiveShares();
        if (shares.isEmpty()) {
            player.method_43496(TextUtils.info((class_2561)class_2561.method_43471((String)"showcase.message.manage.empty")));
            return 0;
        }
        ArrayList<Map.Entry<String, ShareEntry>> shareList = new ArrayList<Map.Entry<String, ShareEntry>>(shares.entrySet());
        ChatPaginator<Map.Entry<String, ShareEntry>> paginator = new ChatPaginator<Map.Entry<String, ShareEntry>>(shareList, 3, "/showcase-manage list");
        class_5250 result = paginator.renderPage(page, entry -> ShareCommandUtils.buildShareLine(player, (String)entry.getKey(), (ShareEntry)entry.getValue()), "Active Shares");
        player.method_43496((class_2561)result);
        return 1;
    }

    private static LiteralArgumentBuilder<class_2168> createCancelCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cancel").requires(src -> PermissionChecker.hasPermission((class_2172)src, Permissions.Manage.CANCEL, 4))).then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            ShowcaseManager.getShareIdCompletions().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            ShareCommandUtils.getPlayerNameCompletions((CommandContext<class_2168>)ctx).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> {
            class_3222 admin = ((class_2168)ctx.getSource()).method_9207();
            String target = StringArgumentType.getString((CommandContext)ctx, (String)"target");
            if (ShowcaseManager.expireShareById(target)) {
                admin.method_43496(TextUtils.success((class_2561)class_2561.method_43469((String)"showcase.message.manage.cancel.success_id", (Object[])new Object[]{target})));
                return 1;
            }
            class_3222 player = ((class_2168)ctx.getSource()).method_9211().method_3760().method_14566(target);
            if (player != null) {
                int count = ShowcaseManager.expireSharesByPlayer(player.method_5667());
                if (count > 0) {
                    admin.method_43496(TextUtils.success((class_2561)class_2561.method_43469((String)"showcase.message.manage.cancel.success_player", (Object[])new Object[]{count, player.method_5476()})));
                } else {
                    admin.method_43496(TextUtils.error((class_2561)class_2561.method_43469((String)"showcase.message.manage.cancel.empty", (Object[])new Object[]{player.method_5476()})));
                }
                return count > 0 ? 1 : 0;
            }
            admin.method_43496(TextUtils.error((class_2561)class_2561.method_43471((String)"showcase.message.manage.cancel.not_found")));
            return 0;
        }));
    }

    private static LiteralArgumentBuilder<class_2168> createConfigCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(src -> PermissionChecker.hasPermission((class_2172)src, "manage", 4))).then(class_2170.method_9247((String)"validate").executes(ctx -> {
            class_3222 admin = ((class_2168)ctx.getSource()).method_9207();
            boolean isValid = ModConfigManager.isCurrentConfigValid();
            if (isValid) {
                admin.method_43496(TextUtils.success((class_2561)class_2561.method_43470((String)"Configuration is valid")));
            } else {
                admin.method_43496(TextUtils.error((class_2561)class_2561.method_43470((String)"Configuration validation failed")));
            }
            return isValid ? 1 : 0;
        }))).then(class_2170.method_9247((String)"backup").executes(ctx -> {
            class_3222 admin = ((class_2168)ctx.getSource()).method_9207();
            boolean success = ModConfigManager.createConfigBackup("manual");
            if (success) {
                admin.method_43496(TextUtils.success((class_2561)class_2561.method_43470((String)"Configuration backed up successfully")));
                return 1;
            }
            admin.method_43496(TextUtils.error((class_2561)class_2561.method_43470((String)"Failed to create configuration backup")));
            return 0;
        }))).then(class_2170.method_9247((String)"reset").executes(ctx -> {
            class_3222 admin = ((class_2168)ctx.getSource()).method_9207();
            boolean success = ModConfigManager.resetConfigToDefaults();
            if (success) {
                admin.method_43496(TextUtils.success((class_2561)class_2561.method_43470((String)"Configuration reset to defaults. Previous config backed up.")));
                return 1;
            }
            admin.method_43496(TextUtils.error((class_2561)class_2561.method_43470((String)"Failed to reset configuration")));
            return 0;
        }))).then(class_2170.method_9247((String)"status").executes(ctx -> {
            class_3222 admin = ((class_2168)ctx.getSource()).method_9207();
            boolean isValid = ModConfigManager.isCurrentConfigValid();
            admin.method_43496((class_2561)class_2561.method_43470((String)"=== Configuration Status ===").method_27692(class_124.field_1065));
            class_5250 validationStatus = isValid ? class_2561.method_43470((String)"\u2713 Valid").method_27692(class_124.field_1060) : class_2561.method_43470((String)"\u2717 Invalid").method_27692(class_124.field_1061);
            admin.method_43496((class_2561)class_2561.method_43470((String)"Validation: ").method_10852((class_2561)validationStatus));
            String configPath = ModConfigManager.getConfigPath().toString();
            admin.method_43496((class_2561)class_2561.method_43470((String)"Config File: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)configPath).method_27692(class_124.field_1068)));
            String backupPath = ModConfigManager.getBackupDirectory().toString();
            admin.method_43496((class_2561)class_2561.method_43470((String)"Backup Directory: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)backupPath).method_27692(class_124.field_1068)));
            ModConfig config = ModConfigManager.getConfig();
            admin.method_43496((class_2561)class_2561.method_43470((String)"Share Types: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(config.shareSettings.size())).method_27692(class_124.field_1068)));
            admin.method_43496((class_2561)class_2561.method_43470((String)"Max Shares/Player: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(config.placeholders.maxSharesPerPlayer)).method_27692(class_124.field_1068)));
            admin.method_43496((class_2561)class_2561.method_43470((String)"==============================").method_27692(class_124.field_1065));
            return 1;
        }))).then(class_2170.method_9247((String)"info").executes(ctx -> {
            class_3222 admin = ((class_2168)ctx.getSource()).method_9207();
            admin.method_43496((class_2561)class_2561.method_43470((String)"=== Configuration Management ===").method_27692(class_124.field_1065));
            admin.method_43496((class_2561)class_2561.method_43470((String)"Available Commands:").method_27692(class_124.field_1054));
            admin.method_43496((class_2561)class_2561.method_43470((String)"\u2022 /showcase-manage config validate").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" - Check configuration validity").method_27692(class_124.field_1080)));
            admin.method_43496((class_2561)class_2561.method_43470((String)"\u2022 /showcase-manage config backup").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" - Create manual backup").method_27692(class_124.field_1080)));
            admin.method_43496((class_2561)class_2561.method_43470((String)"\u2022 /showcase-manage config reset").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" - Reset to defaults (creates backup)").method_27692(class_124.field_1080)));
            admin.method_43496((class_2561)class_2561.method_43470((String)"\u2022 /showcase-manage config status").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" - Show configuration status").method_27692(class_124.field_1080)));
            admin.method_43496((class_2561)class_2561.method_43470((String)"\u2022 /showcase-manage reload").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" - Reload configuration").method_27692(class_124.field_1080)));
            admin.method_43496((class_2561)class_2561.method_43470((String)"=================================").method_27692(class_124.field_1065));
            return 1;
        }));
    }
}

