/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.data;

import com.showcase.data.ShareEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShareRepository {
    private static final Map<String, ShareEntry> SHARES = new ConcurrentHashMap<String, ShareEntry>();

    private ShareRepository() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void store(@NotNull String shareId, @NotNull ShareEntry entry) {
        SHARES.put(shareId, entry);
    }

    @Nullable
    public static ShareEntry get(@NotNull String shareId) {
        return SHARES.get(shareId);
    }

    public static boolean remove(@NotNull String shareId) {
        return SHARES.remove(shareId) != null;
    }

    @NotNull
    public static Map<String, ShareEntry> getAllShares() {
        return Collections.unmodifiableMap(SHARES);
    }

    @NotNull
    public static List<ShareEntry> getPlayerShares(@NotNull String playerUuid) {
        return SHARES.values().stream().filter(entry -> entry.getOwnerUuid().toString().equals(playerUuid)).collect(Collectors.toList());
    }

    @NotNull
    public static List<ShareEntry> getPlayerShares(@NotNull class_3222 player) {
        return ShareRepository.getPlayerShares(player.method_5667().toString());
    }

    public static int removePlayerShares(@NotNull String playerUuid) {
        List<String> toRemove = SHARES.entrySet().stream().filter(entry -> ((ShareEntry)entry.getValue()).getOwnerUuid().toString().equals(playerUuid)).map(Map.Entry::getKey).collect(Collectors.toList());
        toRemove.forEach(SHARES::remove);
        return toRemove.size();
    }

    public static int getShareCount() {
        return SHARES.size();
    }

    @NotNull
    public static List<String> getAllShareIds() {
        return new ArrayList<String>(SHARES.keySet());
    }

    public static boolean exists(@NotNull String shareId) {
        return SHARES.containsKey(shareId);
    }

    public static void clear() {
        SHARES.clear();
    }

    public static void loadShares(@Nullable Map<String, ShareEntry> shares) {
        SHARES.clear();
        if (shares != null) {
            SHARES.putAll(shares);
        }
    }

    @NotNull
    public static Map<String, ShareEntry> getUnmodifiableShares() {
        return Collections.unmodifiableMap(SHARES);
    }
}

