/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.gui;

import com.showcase.utils.countdown.CountdownBossBar;
import com.showcase.utils.countdown.CountdownBossBarManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public abstract class BaseViewerContext {
    public final class_3222 player;
    public final List<SwitchEntry> interfaceList = new ArrayList<SwitchEntry>();
    protected boolean closed = false;
    protected CountdownBossBar countdownBossBar;
    protected final int durationSeconds;
    protected ViewerCloseCallback closeCallback;

    public BaseViewerContext(class_3222 player) {
        this.player = player;
        this.durationSeconds = 0;
    }

    public BaseViewerContext(class_3222 player, int durationSeconds) {
        this.player = player;
        this.durationSeconds = durationSeconds;
        if (this.hasTimeLimit()) {
            this.initializeCountdown();
        }
    }

    public void setCloseCallback(ViewerCloseCallback callback) {
        this.closeCallback = callback;
    }

    protected void initializeCountdown() {
        if (this.durationSeconds <= 0) {
            return;
        }
        this.countdownBossBar = new CountdownBossBar(this.player, (class_2561)class_2561.method_43471((String)"showcase.viewer.countdown_title"), this.durationSeconds).setCallback(new CountdownBossBar.CountdownCallback(){

            @Override
            public void onComplete() {
                BaseViewerContext.this.close();
            }

            @Override
            public void onStop() {
            }

            @Override
            public void onSecondTick(int secondsRemaining) {
            }
        });
        CountdownBossBarManager.add(this.countdownBossBar);
        this.countdownBossBar.start();
    }

    public void sendInstructionMessage() {
        class_5250 instructionMessage = class_2561.method_43471((String)"showcase.viewer.instructions").method_27692(class_124.field_1080);
        this.player.method_7353((class_2561)instructionMessage, true);
    }

    public void extendTime(int additionalSeconds) {
        if (this.countdownBossBar != null && this.countdownBossBar.isRunning()) {
            this.countdownBossBar.addTime(additionalSeconds);
        }
    }

    public void pauseCountdown() {
        if (this.countdownBossBar != null && this.countdownBossBar.isRunning()) {
            this.countdownBossBar.pause();
        }
    }

    public void resumeCountdown() {
        if (this.countdownBossBar != null) {
            this.countdownBossBar.resume();
        }
    }

    protected void closeCountdown() {
        if (this.countdownBossBar != null) {
            CountdownBossBarManager.remove(this.countdownBossBar);
            this.countdownBossBar = null;
        }
    }

    public void close() {
        this.closeCountdown();
        this.closed = true;
        if (this.closeCallback != null) {
            this.closeCallback.onViewerClose();
        }
    }

    public boolean checkClosed() {
        return this.closed;
    }

    public boolean hasTimeLimit() {
        return this.durationSeconds > 0;
    }

    public int getRemainingTime() {
        if (this.countdownBossBar == null) {
            return -1;
        }
        return this.countdownBossBar.getSecondsLeft();
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public static interface ViewerCloseCallback {
        public void onViewerClose();
    }

    public record SwitchEntry(SwitchableUi ui, int currentSlot) {
        public void open(BaseViewerContext context) {
            this.ui.openUi(context, this.currentSlot);
        }
    }

    @FunctionalInterface
    public static interface SwitchableUi {
        public void openUi(BaseViewerContext var1, int var2);
    }
}

