/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.placeholders;

import com.showcase.ShowcaseMod;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PlaceholderTest {
    public static void testEssentialPlaceholders(class_3222 player) {
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a77Testing essential placeholders..."));
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a76Core Sharing Placeholders:"));
        PlaceholderTest.testPlaceholder(player, "item");
        PlaceholderTest.testPlaceholder(player, "inventory");
        PlaceholderTest.testPlaceholder(player, "hotbar");
        PlaceholderTest.testPlaceholder(player, "ender_chest");
        PlaceholderTest.testPlaceholder(player, "stats");
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a76Statistics Placeholders:"));
        PlaceholderTest.testPlaceholder(player, "shares_count");
        PlaceholderTest.testPlaceholder(player, "total_views");
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a76Permission Placeholders:"));
        PlaceholderTest.testPlaceholder(player, "can_share_item");
        PlaceholderTest.testPlaceholder(player, "has_admin_perms");
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a77Placeholder testing complete."));
    }

    private static void testPlaceholder(class_3222 player, String placeholderName) {
        try {
            class_2960 id = class_2960.method_60655((String)"showcase", (String)placeholderName);
            PlaceholderContext context = PlaceholderContext.of((class_3222)player);
            class_2561 result = Placeholders.parseText((class_2561)class_2561.method_43470((String)("%showcase:" + placeholderName + "%")), (PlaceholderContext)context);
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a\u2713 %showcase:" + placeholderName + "% = " + result.getString())));
        }
        catch (Exception e) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7c\u2717 %showcase:" + placeholderName + "% error: " + e.getMessage())));
            ShowcaseMod.LOGGER.error("Placeholder test failed for {}: {}", (Object)placeholderName, (Object)e.getMessage());
        }
    }

    public static void testPlaceholderPerformance(class_3222 player, int iterations) {
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a77Testing placeholder performance with " + iterations + " iterations...")));
        String[] testPlaceholders = new String[]{"shares_count", "total_views", "can_share_item"};
        PlaceholderContext context = PlaceholderContext.of((class_3222)player);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            for (String placeholderName : testPlaceholders) {
                try {
                    Placeholders.parseText((class_2561)class_2561.method_43470((String)("%showcase:" + placeholderName + "%")), (PlaceholderContext)context);
                }
                catch (Exception e) {
                    ShowcaseMod.LOGGER.warn("Performance test failed for {}: {}", (Object)placeholderName, (Object)e.getMessage());
                }
            }
        }
        long totalTime = System.currentTimeMillis() - startTime;
        double avgTimePerPlaceholder = (double)totalTime / (double)(iterations * testPlaceholders.length);
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a77Performance test complete:"));
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7f- Total time: " + totalTime + "ms")));
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7f- Average per placeholder: " + String.format("%.2f", avgTimePerPlaceholder) + "ms")));
    }

    public static boolean validatePlaceholderRegistration() {
        String[] essentialPlaceholders = new String[]{"item", "inventory", "hotbar", "ender_chest", "stats", "shares_count", "total_views", "can_share_item", "has_admin_perms"};
        ShowcaseMod.LOGGER.info("Validating {} essential placeholders...", (Object)essentialPlaceholders.length);
        for (String placeholderName : essentialPlaceholders) {
            ShowcaseMod.LOGGER.info("Expected placeholder: %showcase:{}", (Object)placeholderName);
        }
        ShowcaseMod.LOGGER.info("Placeholder validation logged. Check runtime usage for actual validation.");
        return true;
    }
}

