/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.placeholders;

import com.showcase.ShowcaseMod;
import com.showcase.command.ShowcaseManager;
import com.showcase.data.GlobalDataManager;
import com.showcase.data.JsonCodecDataStorage;
import com.showcase.data.PlayerStatisticsData;
import com.showcase.data.ServerStatisticsData;
import com.showcase.utils.CooldownManager;
import com.showcase.utils.StatisticsCache;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ShowcaseStatistics {
    public static final class_2960 STATISTICS_STORAGE_ID = class_2960.method_60655((String)"showcase", (String)"statistics");
    public static final JsonCodecDataStorage<ServerStatisticsData> STATISTICS_STORAGE = new JsonCodecDataStorage<ServerStatisticsData>("showcase_statistics", ServerStatisticsData.CODEC);
    private static MinecraftServer currentServer;
    private static final StatisticsCache cache;
    private static final Map<String, PlayerStats> playerStatistics;
    private static final AtomicInteger totalActiveShares;
    private static final AtomicLong totalViewsEver;
    private static final Map<String, AtomicInteger> shareTypeGlobalStats;
    private static final Map<String, Long> lastShareTime;
    private static final Map<String, ShowcaseManager.ShareType> lastShareType;
    private static final Map<String, Instant> nextShareExpiry;
    private static volatile long lastSaveRequest;
    private static final long SAVE_DEBOUNCE_MS = 5000L;
    private static ScheduledFuture<?> pendingSaveTask;

    public static int getActiveShareCount(class_3222 player) {
        if (player == null) {
            return 0;
        }
        return (int)ShowcaseManager.getUnmodifiableActiveShares().values().stream().filter(entry -> entry.getOwnerUuid().equals(player.method_5667())).count();
    }

    public static ShowcaseManager.ShareType getLastShareType(class_3222 player) {
        if (player == null) {
            return null;
        }
        return lastShareType.get(player.method_5845());
    }

    public static Instant getLastShareTime(class_3222 player) {
        if (player == null) {
            return null;
        }
        Long timeMs = lastShareTime.get(player.method_5845());
        return timeMs != null ? Instant.ofEpochMilli(timeMs) : null;
    }

    public static Instant getNextShareExpiry(class_3222 player) {
        if (player == null) {
            return null;
        }
        return nextShareExpiry.get(player.method_5845());
    }

    public static long getTotalViewsForPlayer(class_3222 player) {
        if (player == null) {
            return 0L;
        }
        String cacheKey = StatisticsCache.playerKey(player.method_5845(), "total_views");
        Long cached = cache.get(cacheKey, Long.class);
        if (cached != null) {
            return cached;
        }
        PlayerStats stats = ShowcaseStatistics.getPlayerStats(player);
        long result = stats.totalViews.get();
        cache.put(cacheKey, result);
        return result;
    }

    public static ShowcaseManager.ShareType getMostSharedType(class_3222 player) {
        if (player == null) {
            return null;
        }
        String cacheKey = StatisticsCache.playerKey(player.method_5845(), "most_shared_type");
        ShowcaseManager.ShareType cached = cache.get(cacheKey, ShowcaseManager.ShareType.class);
        if (cached != null) {
            return cached;
        }
        PlayerStats stats = ShowcaseStatistics.getPlayerStats(player);
        ShowcaseManager.ShareType result = stats.mostSharedType;
        cache.put(cacheKey, (Object)result);
        return result;
    }

    public static int getSharesCreatedToday(class_3222 player) {
        if (player == null) {
            return 0;
        }
        String cacheKey = StatisticsCache.playerKey(player.method_5845(), "shares_today");
        Integer cached = cache.get(cacheKey, Integer.class);
        if (cached != null) {
            return cached;
        }
        PlayerStats stats = ShowcaseStatistics.getPlayerStats(player);
        String today = LocalDate.now().toString();
        int result = stats.sharesPerDay.getOrDefault(today, 0);
        cache.put(cacheKey, result);
        return result;
    }

    public static int getSharesCreatedThisWeek(class_3222 player) {
        if (player == null) {
            return 0;
        }
        String cacheKey = StatisticsCache.playerKey(player.method_5845(), "shares_week");
        Integer cached = cache.get(cacheKey, Integer.class);
        if (cached != null) {
            return cached;
        }
        PlayerStats stats = ShowcaseStatistics.getPlayerStats(player);
        LocalDate now = LocalDate.now();
        LocalDate weekStart = now.minusDays(now.getDayOfWeek().getValue() - 1);
        int result = stats.sharesPerDay.entrySet().stream().filter(entry -> {
            LocalDate date = LocalDate.parse((CharSequence)entry.getKey());
            return !date.isBefore(weekStart) && !date.isAfter(now);
        }).mapToInt(Map.Entry::getValue).sum();
        cache.put(cacheKey, result);
        return result;
    }

    public static Duration getAverageShareDuration(class_3222 player) {
        if (player == null) {
            return Duration.ZERO;
        }
        String cacheKey = StatisticsCache.playerKey(player.method_5845(), "avg_duration");
        Duration cached = cache.get(cacheKey, Duration.class);
        if (cached != null) {
            return cached;
        }
        PlayerStats stats = ShowcaseStatistics.getPlayerStats(player);
        if (stats.shareDurations.isEmpty()) {
            cache.put(cacheKey, Duration.ZERO);
            return Duration.ZERO;
        }
        long averageSeconds = stats.shareDurations.stream().mapToLong(Duration::getSeconds).sum() / (long)stats.shareDurations.size();
        Duration result = Duration.ofSeconds(averageSeconds);
        cache.put(cacheKey, result);
        return result;
    }

    public static long getCooldownRemaining(class_3222 player, ShowcaseManager.ShareType type) {
        if (player == null) {
            return 0L;
        }
        return CooldownManager.getRemainingCooldown(player, type);
    }

    public static long getChatKeywordCooldown(class_3222 player) {
        if (player == null) {
            return 0L;
        }
        return CooldownManager.getRemainingCooldown(player, ShowcaseManager.ShareType.ITEM);
    }

    public static boolean isOnAnyCooldown(class_3222 player) {
        if (player == null) {
            return false;
        }
        for (ShowcaseManager.ShareType type : ShowcaseManager.ShareType.values()) {
            if (!ShowcaseManager.isOnCooldown(player, type)) continue;
            return true;
        }
        return false;
    }

    public static int getTotalActiveShares() {
        String cacheKey = StatisticsCache.serverKey("total_active_shares");
        Integer cached = cache.get(cacheKey, Integer.class);
        if (cached != null) {
            return cached;
        }
        int result = ShowcaseManager.getUnmodifiableActiveShares().size();
        cache.put(cacheKey, result);
        return result;
    }

    public static double getCacheHitRate() {
        return cache.getHitRate();
    }

    public static int getCacheSize() {
        return cache.getSize();
    }

    public static long getCacheHits() {
        return cache.getHits();
    }

    public static long getCacheMisses() {
        return cache.getMisses();
    }

    public static void clearAllCache() {
        cache.clear();
    }

    public static void forceCacheCleanup() {
        cache.forceCleanup();
    }

    public static Map<String, Object> getCacheStatistics() {
        return cache.getStatistics();
    }

    private static PlayerStats getPlayerStats(class_3222 player) {
        String uuid = player.method_5845();
        return playerStatistics.computeIfAbsent(uuid, k -> new PlayerStats());
    }

    public static void recordShareCreation(class_3222 player, ShowcaseManager.ShareType type, Duration duration) {
        if (player == null) {
            return;
        }
        String uuid = player.method_5845();
        PlayerStats stats = ShowcaseStatistics.getPlayerStats(player);
        stats.totalShares.incrementAndGet();
        stats.sharesByType.get((Object)type).incrementAndGet();
        stats.addDuration(duration);
        stats.lastShareTime = Instant.now();
        String today = LocalDate.now().toString();
        stats.sharesPerDay.merge(today, 1, Integer::sum);
        ShowcaseStatistics.updateMostSharedType(stats);
        lastShareTime.put(uuid, System.currentTimeMillis());
        lastShareType.put(uuid, type);
        Instant expiry = Instant.now().plus(duration);
        nextShareExpiry.merge(uuid, expiry, (existing, newExpiry) -> existing.isBefore((Instant)newExpiry) ? existing : newExpiry);
        totalActiveShares.incrementAndGet();
        shareTypeGlobalStats.computeIfAbsent(type.name(), k -> new AtomicInteger(0)).incrementAndGet();
        ShowcaseStatistics.clearCacheForPlayer(uuid);
        ShowcaseStatistics.scheduleAsyncSave();
    }

    public static void recordShareView(class_3222 creator, class_3222 viewer) {
        if (creator == null) {
            return;
        }
        PlayerStats stats = ShowcaseStatistics.getPlayerStats(creator);
        stats.totalViews.incrementAndGet();
        totalViewsEver.incrementAndGet();
        ShowcaseStatistics.clearCacheForPlayer(creator.method_5845());
        ShowcaseStatistics.scheduleAsyncSave();
    }

    public static void recordShareExpiry(class_3222 player, ShowcaseManager.ShareType type) {
        if (player == null) {
            return;
        }
        totalActiveShares.decrementAndGet();
        String uuid = player.method_5845();
        ShowcaseStatistics.updateNextExpiryTime(uuid);
        ShowcaseStatistics.clearCacheForPlayer(uuid);
        ShowcaseStatistics.scheduleAsyncSave();
    }

    private static void updateMostSharedType(PlayerStats stats) {
        stats.mostSharedType = stats.sharesByType.entrySet().stream().max(Map.Entry.comparingByValue((a, b) -> a.get() - b.get())).map(Map.Entry::getKey).orElse(null);
    }

    private static void updateNextExpiryTime(String playerUuid) {
        nextShareExpiry.remove(playerUuid);
    }

    private static void clearCacheForPlayer(String playerUuid) {
        cache.removePattern(playerUuid);
    }

    public static void initialize() {
        GlobalDataManager.register(STATISTICS_STORAGE_ID, STATISTICS_STORAGE);
        ShowcaseMod.LOGGER.info("Registered statistics storage system");
        ShowcaseStatistics.loadStatisticsFromStorage();
        ShowcaseStatistics.schedulePeriodicTasks();
    }

    public static void setServer(MinecraftServer server) {
        currentServer = server;
        if (server != null) {
            ShowcaseStatistics.loadStatisticsFromStorage();
        }
    }

    private static void loadStatisticsFromStorage() {
        if (currentServer == null) {
            ShowcaseMod.LOGGER.debug("Server not set, skipping statistics load");
            return;
        }
        try {
            ServerStatisticsData data = (ServerStatisticsData)GlobalDataManager.getData(currentServer, STATISTICS_STORAGE_ID);
            if (data != null) {
                totalViewsEver.set(data.totalViewsEver());
                shareTypeGlobalStats.clear();
                data.shareTypeGlobalStats().forEach((key, value) -> shareTypeGlobalStats.put((String)key, new AtomicInteger((int)value)));
                playerStatistics.clear();
                data.playerStatistics().forEach((uuid, playerData) -> {
                    PlayerStats stats = new PlayerStats();
                    stats.totalShares.set(playerData.totalShares());
                    stats.totalViews.set(playerData.totalViews());
                    playerData.sharesByType().forEach((type, count) -> stats.sharesByType.get(type).set((int)count));
                    stats.sharesPerDay.putAll(playerData.sharesPerDay());
                    stats.shareDurations.addAll(playerData.getShareDurations());
                    stats.mostSharedType = playerData.mostSharedType();
                    stats.lastShareTime = playerData.getLastShareTimeInstant();
                    playerStatistics.put((String)uuid, stats);
                });
                ShowcaseMod.LOGGER.info("Loaded statistics for {} players from storage", (Object)data.playerStatistics().size());
            } else {
                ShowcaseMod.LOGGER.debug("No statistics found in storage, starting fresh");
            }
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("Failed to load statistics from storage", (Throwable)e);
        }
    }

    private static void schedulePeriodicTasks() {
    }

    public static void saveStatistics() {
        if (currentServer == null) {
            ShowcaseMod.LOGGER.debug("Server not set, skipping statistics save");
            return;
        }
        try {
            HashMap<String, Integer> globalStats = new HashMap<String, Integer>();
            shareTypeGlobalStats.forEach((key, value) -> globalStats.put((String)key, value.get()));
            HashMap<String, PlayerStatisticsData> playerData = new HashMap<String, PlayerStatisticsData>();
            playerStatistics.forEach((uuid, stats) -> {
                HashMap<ShowcaseManager.ShareType, Integer> sharesByType = new HashMap<ShowcaseManager.ShareType, Integer>();
                stats.sharesByType.forEach((type, count) -> sharesByType.put((ShowcaseManager.ShareType)((Object)((Object)type)), count.get()));
                List<Long> durationSeconds = stats.shareDurations.stream().map(Duration::getSeconds).toList();
                PlayerStatisticsData data = new PlayerStatisticsData(stats.totalShares.get(), stats.totalViews.get(), sharesByType, new HashMap<String, Integer>(stats.sharesPerDay), durationSeconds, stats.mostSharedType, stats.lastShareTime != null ? Long.valueOf(stats.lastShareTime.toEpochMilli()) : null);
                playerData.put((String)uuid, data);
            });
            ServerStatisticsData data = new ServerStatisticsData(totalViewsEver.get(), globalStats, cache.getHits(), cache.getMisses(), playerData);
            GlobalDataManager.setData(currentServer, STATISTICS_STORAGE_ID, data);
            ShowcaseMod.LOGGER.debug("Statistics saved to persistent storage");
        }
        catch (Exception e) {
            ShowcaseMod.LOGGER.error("Failed to save statistics to storage", (Throwable)e);
        }
    }

    public static void schedulePeriodicSave() {
        ShowcaseMod.LOGGER.debug("Periodic save scheduled (placeholder)");
    }

    public static void scheduleAsyncSave() {
        long now;
        lastSaveRequest = now = System.currentTimeMillis();
        if (pendingSaveTask != null && !pendingSaveTask.isDone()) {
            pendingSaveTask.cancel(false);
        }
        pendingSaveTask = ShowcaseManager.getScheduler().schedule(() -> {
            try {
                if (System.currentTimeMillis() - lastSaveRequest >= 5000L) {
                    ShowcaseStatistics.saveStatistics();
                }
            }
            catch (Exception e) {
                ShowcaseMod.LOGGER.error("Error during scheduled statistics save", (Throwable)e);
            }
        }, 5000L, TimeUnit.MILLISECONDS);
    }

    public static Map<String, Object> getServerStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("totalActiveShares", ShowcaseStatistics.getTotalActiveShares());
        stats.put("totalViewsEver", totalViewsEver.get());
        stats.put("shareTypeStats", new HashMap<String, AtomicInteger>(shareTypeGlobalStats));
        stats.put("totalPlayers", playerStatistics.size());
        return stats;
    }

    public static Map<String, Object> getPlayerStatisticsSummary(class_3222 player) {
        if (player == null) {
            return new HashMap<String, Object>();
        }
        PlayerStats stats = ShowcaseStatistics.getPlayerStats(player);
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("totalShares", stats.totalShares.get());
        summary.put("totalViews", stats.totalViews.get());
        summary.put("mostSharedType", (Object)stats.mostSharedType);
        summary.put("lastShareTime", stats.lastShareTime);
        summary.put("sharesByType", new HashMap<ShowcaseManager.ShareType, AtomicInteger>(stats.sharesByType));
        return summary;
    }

    static {
        cache = new StatisticsCache();
        playerStatistics = new ConcurrentHashMap<String, PlayerStats>();
        totalActiveShares = new AtomicInteger(0);
        totalViewsEver = new AtomicLong(0L);
        shareTypeGlobalStats = new ConcurrentHashMap<String, AtomicInteger>();
        lastShareTime = new ConcurrentHashMap<String, Long>();
        lastShareType = new ConcurrentHashMap<String, ShowcaseManager.ShareType>();
        nextShareExpiry = new ConcurrentHashMap<String, Instant>();
        lastSaveRequest = 0L;
        pendingSaveTask = null;
    }

    public static class PlayerStats {
        private static final int MAX_DURATION_RECORDS = 1000;
        public final AtomicInteger totalShares = new AtomicInteger(0);
        public final AtomicLong totalViews = new AtomicLong(0L);
        public final Map<ShowcaseManager.ShareType, AtomicInteger> sharesByType = new ConcurrentHashMap<ShowcaseManager.ShareType, AtomicInteger>();
        public final Map<String, Integer> sharesPerDay = new ConcurrentHashMap<String, Integer>();
        public final List<Duration> shareDurations = new ArrayList<Duration>();
        public ShowcaseManager.ShareType mostSharedType = null;
        public Instant lastShareTime = null;

        public PlayerStats() {
            for (ShowcaseManager.ShareType type : ShowcaseManager.ShareType.values()) {
                this.sharesByType.put(type, new AtomicInteger(0));
            }
        }

        public void addDuration(Duration duration) {
            if (this.shareDurations.size() >= 1000) {
                this.shareDurations.remove(0);
            }
            this.shareDurations.add(duration);
        }
    }
}

