/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils;

import com.showcase.command.ShowcaseManager;
import com.showcase.config.ModConfigManager;
import com.showcase.utils.DevUtils;
import com.showcase.utils.permissions.PermissionChecker;
import com.showcase.utils.permissions.Permissions;
import java.time.Instant;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public final class CooldownManager {
    private static final Map<UUID, EnumMap<ShowcaseManager.ShareType, Long>> COOLDOWNS = new ConcurrentHashMap<UUID, EnumMap<ShowcaseManager.ShareType, Long>>();

    private CooldownManager() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean isOnCooldown(@NotNull class_3222 player, @NotNull ShowcaseManager.ShareType type) {
        if (DevUtils.isDevelopment()) {
            return false;
        }
        if (PermissionChecker.isOp(player) || PermissionChecker.hasPermission(player, Permissions.getCommandTypeFromShareType(type).getCooldown(), 4)) {
            return false;
        }
        EnumMap<ShowcaseManager.ShareType, Long> map = COOLDOWNS.get(player.method_5667());
        if (map == null) {
            return false;
        }
        Long cooldownEnd = map.get((Object)type);
        if (cooldownEnd == null) {
            return false;
        }
        return Instant.now().toEpochMilli() < cooldownEnd;
    }

    public static void setCooldown(@NotNull class_3222 player, @NotNull ShowcaseManager.ShareType type) {
        if (DevUtils.isDevelopment()) {
            return;
        }
        int cooldownSeconds = ModConfigManager.getShareSettings((ShowcaseManager.ShareType)type).cooldown;
        long cooldownEnd = Instant.now().toEpochMilli() + (long)cooldownSeconds * 1000L;
        COOLDOWNS.computeIfAbsent(player.method_5667(), k -> new EnumMap(ShowcaseManager.ShareType.class)).put(type, cooldownEnd);
    }

    public static long getRemainingCooldown(@NotNull class_3222 player, @NotNull ShowcaseManager.ShareType type) {
        if (DevUtils.isDevelopment()) {
            return 0L;
        }
        EnumMap<ShowcaseManager.ShareType, Long> map = COOLDOWNS.get(player.method_5667());
        if (map == null) {
            return 0L;
        }
        Long cooldownEnd = map.get((Object)type);
        if (cooldownEnd == null) {
            return 0L;
        }
        long remaining = cooldownEnd - Instant.now().toEpochMilli();
        return Math.max(0L, remaining / 1000L);
    }

    public static void clearPlayerCooldowns(@NotNull class_3222 player) {
        COOLDOWNS.remove(player.method_5667());
    }

    public static void clearAllCooldowns() {
        COOLDOWNS.clear();
    }

    public static void cleanupExpiredCooldowns() {
        long now = Instant.now().toEpochMilli();
        COOLDOWNS.entrySet().removeIf(playerEntry -> {
            EnumMap playerCooldowns = (EnumMap)playerEntry.getValue();
            playerCooldowns.entrySet().removeIf(cooldownEntry -> (Long)cooldownEntry.getValue() <= now);
            return playerCooldowns.isEmpty();
        });
    }

    public static int getActiveCooldownCount() {
        return COOLDOWNS.values().stream().mapToInt(Map::size).sum();
    }
}

