/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.showcase.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import net.minecraft.class_8824;

public class ReadOnlyInventory
extends class_1277 {
    public class_2561 name;
    public class_3917<?> type;
    public static final Codec<SlotEntry> SLOT_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("slot").forGetter(SlotEntry::slot), (App)class_1799.field_24671.fieldOf("stack").forGetter(SlotEntry::stack)).apply((Applicative)instance, SlotEntry::new));
    public static final Codec<ReadOnlyInventory> READ_ONLY_INVENTORY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_8824.field_46597.optionalFieldOf("name").forGetter(inv -> Optional.ofNullable(inv.name)), (App)class_7923.field_41187.method_39673().fieldOf("type").forGetter(inv -> inv.type), (App)Codec.INT.fieldOf("size").forGetter(class_1277::method_5439), (App)Codec.list(SLOT_ENTRY_CODEC).fieldOf("items").forGetter(ReadOnlyInventory::encodeNonEmptyStacks)).apply((Applicative)instance, (name, type, size, slotEntries) -> {
        ReadOnlyInventory inventory = new ReadOnlyInventory((int)size, name.orElse(null), (class_3917<?>)type);
        for (SlotEntry entry : slotEntries) {
            if (entry.slot < 0 || entry.slot >= size) continue;
            inventory.method_5447(entry.slot, entry.stack());
        }
        return inventory;
    }));

    public ReadOnlyInventory(int size, class_2561 name, class_3917<?> type) {
        super(size);
        this.name = name != null ? name : TextUtils.UNKNOWN_ENTRY;
        this.type = type;
    }

    public class_2561 getName() {
        return this.name;
    }

    public class_3917<?> getType() {
        return this.type;
    }

    public static List<SlotEntry> encodeNonEmptyStacks(class_1277 inv) {
        ArrayList<SlotEntry> result = new ArrayList<SlotEntry>();
        if (inv == null) {
            return result;
        }
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack == null || stack.method_7960()) continue;
            result.add(new SlotEntry(i, stack.method_7972()));
        }
        return result;
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1799.field_8037;
    }

    public class_1799 method_5441(int slot) {
        return class_1799.field_8037;
    }

    public void method_5448() {
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return false;
    }

    public record SlotEntry(int slot, class_1799 stack) {
    }
}

