/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils;

import com.showcase.ShowcaseMod;
import com.showcase.utils.ReadOnlyInventory;
import com.showcase.utils.ScreenHandlerUtils;
import com.showcase.utils.TextUtils;
import com.showcase.utils.compat.ItemTagsCompat;
import com.showcase.utils.compat.ProfileCompat;
import com.showcase.utils.ui.ItemIconProvider;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public class StackUtils {
    public static final class_1799 DIVIDER_ITEM;
    private static final Set<class_3917<?>> WHITELISTED_TYPES;

    public static Boolean isMap(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8895) || itemStack.method_31574(class_1802.field_8204);
    }

    public static Boolean isBook(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8360) || itemStack.method_31574(class_1802.field_8674);
    }

    public static boolean isShulkerBox(class_1799 itemStack) {
        return ItemTagsCompat.isShulkerBox(itemStack);
    }

    public static boolean isBundle(class_1799 itemStack) {
        return false;
    }

    public static boolean isDivider(class_1799 s) {
        return !s.method_7960() && s.method_31574(class_1802.field_8871) && s.method_57826(class_9334.field_49631) && Objects.requireNonNull((class_2561)s.method_57824(class_9334.field_49631)).getString().equals("\u2b1b");
    }

    public static boolean isWhitelistedContainer(class_1703 handler) {
        return WHITELISTED_TYPES.contains(handler.method_17358());
    }

    public static class_2561 getDisplayName(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return TextUtils.UNKNOWN_ENTRY;
        }
        boolean isBook = StackUtils.isBook(stack);
        class_5250 iconPrefix = ItemIconProvider.getIconForItem(stack);
        class_5250 base = class_2561.method_43473();
        if (!iconPrefix.getString().isEmpty()) {
            base.method_10852((class_2561)iconPrefix).method_27693(" ");
        }
        base.method_10852((class_2561)class_2561.method_43470((String)(isBook ? "\u300a" : "[")));
        class_2561 displayName = stack.method_7964();
        class_5250 translatedName = class_2561.method_43471((String)stack.method_7909().method_7876());
        boolean hasCustomName = !displayName.equals((Object)translatedName);
        base.method_10852((class_2561)displayName.method_27661());
        if (hasCustomName) {
            base.method_10852((class_2561)class_2561.method_43470((String)" (")).method_10852((class_2561)translatedName.method_27661()).method_10852((class_2561)class_2561.method_43470((String)")"));
        }
        if (stack.method_7914() > 1 && stack.method_7947() > 1) {
            base.method_27693("\u00d7").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(stack.method_7947()))).method_27692(class_124.field_1075);
        }
        return base.method_27693(isBook ? "\u300b" : "]");
    }

    public static ReadOnlyInventory unpackFromItemStack(class_1799 stack) {
        ArrayList tmp = new ArrayList();
        class_2561 itemName = StackUtils.getDisplayName(stack);
        if (StackUtils.isBundle(stack)) {
            int rows = Math.min(6, Math.max(1, (tmp.size() + 8) / 9));
            int size = rows * 9;
            ReadOnlyInventory inv = new ReadOnlyInventory(size, itemName, ScreenHandlerUtils.handlerTypeForRows(rows));
            for (int i = 0; i < tmp.size() && i < size; ++i) {
                inv.method_5447(i, (class_1799)tmp.get(i));
            }
            return inv;
        }
        if (StackUtils.isShulkerBox(stack)) {
            try {
                class_9288 container = (class_9288)stack.method_57824(class_9334.field_49622);
                if (container != null) {
                    tmp.addAll(container.method_57489().toList());
                }
                int size = 27;
                ReadOnlyInventory inv = new ReadOnlyInventory(size, itemName, class_3917.field_17341);
                for (int i = 0; i < tmp.size() && i < size; ++i) {
                    inv.method_5447(i, (class_1799)tmp.get(i));
                }
                return inv;
            }
            catch (RuntimeException e) {
                ShowcaseMod.LOGGER.error(e.toString());
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static ReadOnlyInventory snapshotFullInventory(class_3222 player) {
        int i;
        ReadOnlyInventory inv = new ReadOnlyInventory(54, TextUtils.INVENTORY, class_3917.field_17327);
        class_1799 playerHead = StackUtils.getPlayerHead(player);
        inv.method_5447(0, playerHead.method_7972());
        class_1799 experienceBottle = new class_1799((class_1935)class_1802.field_8287);
        experienceBottle.method_57379(class_9334.field_49631, (Object)class_2561.method_43469((String)"showcase.screen.player_level", (Object[])new Object[]{player.field_7520}));
        inv.method_5447(1, experienceBottle);
        inv.method_5447(2, DIVIDER_ITEM.method_7972());
        inv.method_5447(3, player.method_6118(class_1304.field_6169).method_7972());
        inv.method_5447(4, player.method_6118(class_1304.field_6174).method_7972());
        inv.method_5447(5, player.method_6118(class_1304.field_6172).method_7972());
        inv.method_5447(6, player.method_6118(class_1304.field_6166).method_7972());
        inv.method_5447(7, DIVIDER_ITEM.method_7972());
        inv.method_5447(8, player.method_6118(class_1304.field_6171).method_7972());
        for (i = 0; i < 9; ++i) {
            inv.method_5447(i + 9, player.method_31548().method_5438(i).method_7972());
        }
        for (i = 18; i < 27; ++i) {
            inv.method_5447(i, DIVIDER_ITEM.method_7972());
        }
        for (i = 9; i < 36; ++i) {
            inv.method_5447(i + 18, player.method_31548().method_5438(i).method_7972());
        }
        return inv;
    }

    public static class_1799 getPlayerHead(class_3222 player) {
        class_1799 head = new class_1799((class_1935)class_1802.field_8575);
        head.method_57379(class_9334.field_49617, (Object)ProfileCompat.createProfileComponent(player.method_7334()));
        return head;
    }

    public static boolean isValid(class_1799 stack) {
        return stack != null && !stack.method_7960() && stack.method_7947() > 0;
    }

    static {
        class_1799 temp = new class_1799((class_1935)class_1802.field_8871);
        temp.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"\u2b1b").method_27692(class_124.field_1063));
        DIVIDER_ITEM = temp;
        WHITELISTED_TYPES = Set.of(class_3917.field_17326, class_3917.field_17327, class_3917.field_17328, class_3917.field_46790, class_3917.field_17335, class_3917.field_17342, class_3917.field_17331, class_3917.field_17332, class_3917.field_17341);
    }
}

