/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils;

import com.showcase.ShowcaseMod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class StatisticsCache {
    private final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private final AtomicLong cacheHits = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    private final long cacheDurationMs;
    private final long cleanupIntervalMs;
    private volatile long lastCleanup = 0L;

    public StatisticsCache() {
        this(30000L, 60000L);
    }

    public StatisticsCache(long cacheDurationMs, long cleanupIntervalMs) {
        this.cacheDurationMs = cacheDurationMs;
        this.cleanupIntervalMs = cleanupIntervalMs;
        ShowcaseMod.LOGGER.debug("StatisticsCache initialized with {}ms duration, {}ms cleanup interval", (Object)cacheDurationMs, (Object)cleanupIntervalMs);
    }

    public <T> T get(String key, Class<T> type) {
        this.performCleanupIfNeeded();
        CacheEntry entry = this.cache.get(key);
        if (entry != null && !entry.isExpired() && type.isInstance(entry.value)) {
            this.cacheHits.incrementAndGet();
            return (T)entry.value;
        }
        if (entry != null && entry.isExpired()) {
            this.cache.remove(key);
        }
        this.cacheMisses.incrementAndGet();
        return null;
    }

    public void put(String key, Object value) {
        if (value != null) {
            this.cache.put(key, new CacheEntry(value, this.cacheDurationMs));
        }
    }

    public void remove(String key) {
        this.cache.remove(key);
    }

    public void removePattern(String pattern) {
        this.cache.entrySet().removeIf(entry -> ((String)entry.getKey()).contains(pattern));
    }

    public void clear() {
        this.cache.clear();
    }

    public void forceCleanup() {
        this.cache.entrySet().removeIf(entry -> ((CacheEntry)entry.getValue()).isExpired());
        this.lastCleanup = System.currentTimeMillis();
        ShowcaseMod.LOGGER.debug("Cache cleanup performed, {} entries remain", (Object)this.cache.size());
    }

    private void performCleanupIfNeeded() {
        long now = System.currentTimeMillis();
        if (now - this.lastCleanup >= this.cleanupIntervalMs) {
            this.forceCleanup();
        }
    }

    public double getHitRate() {
        long misses;
        long hits = this.cacheHits.get();
        long total = hits + (misses = this.cacheMisses.get());
        if (total == 0L) {
            return 0.0;
        }
        return (double)hits / (double)total * 100.0;
    }

    public int getSize() {
        return this.cache.size();
    }

    public long getHits() {
        return this.cacheHits.get();
    }

    public long getMisses() {
        return this.cacheMisses.get();
    }

    public Map<String, Object> getStatistics() {
        ConcurrentHashMap<String, Object> stats = new ConcurrentHashMap<String, Object>();
        stats.put("size", this.getSize());
        stats.put("hitRate", this.getHitRate());
        stats.put("hits", this.getHits());
        stats.put("misses", this.getMisses());
        stats.put("cacheDurationMs", this.cacheDurationMs);
        return stats;
    }

    public static String playerKey(String playerUuid, String operation) {
        return "player:" + playerUuid + ":" + operation;
    }

    public static String serverKey(String operation) {
        return "server:" + operation;
    }

    public static String typeKey(String type, String operation) {
        return "type:" + type + ":" + operation;
    }

    private static class CacheEntry {
        public final Object value;
        public final long timestamp;
        public final long expirationTime;

        public CacheEntry(Object value, long cacheDurationMs) {
            this.value = value;
            this.timestamp = System.currentTimeMillis();
            this.expirationTime = this.timestamp + cacheDurationMs;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expirationTime;
        }
    }
}

