/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils.stats;

import com.showcase.config.ModConfig;
import com.showcase.config.ModConfigManager;

public class StatFormatter {
    public static String formatStatValue(String statKey, int value) {
        if (StatFormatter.isTimeRelated(statKey)) {
            return StatFormatter.formatTime(value);
        }
        if (StatFormatter.isDistanceRelated(statKey)) {
            return StatFormatter.formatDistance(value);
        }
        if (StatFormatter.isDamageRelated(statKey)) {
            return StatFormatter.formatDamage(value);
        }
        return String.valueOf(value);
    }

    public static String formatStatDisplayName(String statKey) {
        if (statKey.startsWith("stat.minecraft.use_item.")) {
            return StatFormatter.getItemDisplayName(StatFormatter.extractId(statKey, "stat.minecraft.use_item."));
        }
        if (statKey.startsWith("stat.minecraft.craft_item.")) {
            return StatFormatter.getItemDisplayName(StatFormatter.extractId(statKey, "stat.minecraft.craft_item."));
        }
        if (statKey.startsWith("stat.minecraft.break_item.")) {
            return StatFormatter.getItemDisplayName(StatFormatter.extractId(statKey, "stat.minecraft.break_item."));
        }
        if (statKey.startsWith("stat.minecraft.pickup.")) {
            return StatFormatter.getItemDisplayName(StatFormatter.extractId(statKey, "stat.minecraft.pickup."));
        }
        if (statKey.startsWith("stat.minecraft.drop.")) {
            return StatFormatter.getItemDisplayName(StatFormatter.extractId(statKey, "stat.minecraft.drop."));
        }
        if (statKey.startsWith("stat.minecraft.mine_block.")) {
            return StatFormatter.getBlockDisplayName(StatFormatter.extractId(statKey, "stat.minecraft.mine_block."));
        }
        if (statKey.startsWith("stat.minecraft.kill_entity.")) {
            return StatFormatter.getEntityDisplayName(StatFormatter.extractId(statKey, "stat.minecraft.kill_entity."));
        }
        if (statKey.startsWith("stat.minecraft.entity_killed_by.")) {
            return StatFormatter.getEntityDisplayName(StatFormatter.extractId(statKey, "stat.minecraft.entity_killed_by."));
        }
        return statKey;
    }

    private static boolean isTimeRelated(String statKey) {
        return statKey.contains("time") || statKey.equals("stat.minecraft.sneak_time");
    }

    private static boolean isDistanceRelated(String statKey) {
        return statKey.contains("_cm");
    }

    private static boolean isDamageRelated(String statKey) {
        return statKey.contains("damage");
    }

    private static String formatTime(int ticks) {
        int seconds = ticks / 20;
        ModConfig.TimeFormatSettings config = ModConfigManager.getConfig().statsDisplay.timeFormat;
        if (seconds < 60) {
            return "< 1m";
        }
        if (seconds < 3600) {
            int minutes = seconds / 60;
            if (config.useCompactFormat) {
                return minutes + "m";
            }
            return String.format("%d minutes", minutes);
        }
        int hours = seconds / 3600;
        int remainingMinutes = seconds % 3600 / 60;
        if (config.useCompactFormat) {
            if (config.hideZeroComponents && remainingMinutes == 0) {
                return hours + "h";
            }
            return String.format("%dh %dm", hours, remainingMinutes);
        }
        return remainingMinutes > 0 ? String.format("%d hours %d minutes", hours, remainingMinutes) : String.format("%d hours", hours);
    }

    private static String formatDistance(int cm) {
        ModConfig.DistanceFormatSettings config = ModConfigManager.getConfig().statsDisplay.distanceFormat;
        if (!config.autoConvert) {
            return cm + "cm";
        }
        if (cm < config.meterThreshold) {
            return cm + "cm";
        }
        if (cm < config.kilometerThreshold) {
            double meters = (double)cm / 100.0;
            return StatFormatter.formatWithPrecision(config.meterDecimalPlaces, meters) + "m";
        }
        double kilometers = (double)cm / 100000.0;
        return StatFormatter.formatWithPrecision(config.kilometerDecimalPlaces, kilometers) + "km";
    }

    private static String formatDamage(int damage) {
        ModConfig.DamageFormatSettings config = ModConfigManager.getConfig().statsDisplay.damageFormat;
        if (config.showAsHearts) {
            double hearts = (double)damage / 10.0;
            String heartStr = String.format("%." + config.heartDecimalPlaces + "f\u2665", hearts);
            if (config.showBothFormats) {
                return String.format("%s (%d)", heartStr, damage);
            }
            return heartStr;
        }
        return String.valueOf(damage);
    }

    private static String formatWithPrecision(int precision, double value) {
        int safePrecision = Math.max(0, Math.min(precision, 10));
        return String.format("%." + safePrecision + "f", value);
    }

    private static String extractId(String statKey, String prefix) {
        return statKey.substring(prefix.length());
    }

    private static String getItemDisplayName(String itemId) {
        String cleanId = itemId.replace("minecraft:", "");
        return "item.minecraft." + cleanId;
    }

    private static String getBlockDisplayName(String blockId) {
        String cleanId = blockId.replace("minecraft:", "");
        return "block.minecraft." + cleanId;
    }

    private static String getEntityDisplayName(String entityId) {
        String cleanId = entityId.replace("minecraft:", "");
        return "entity.minecraft." + cleanId;
    }
}

