/*
 * Decompiled with CFR 0.152.
 */
package com.showcase.utils.stats;

import com.showcase.config.ModConfig;
import com.showcase.config.ModConfigManager;
import com.showcase.utils.PlayerUtils;
import com.showcase.utils.TextEventFactory;
import com.showcase.utils.TextUtils;
import com.showcase.utils.stats.StatCategories;
import com.showcase.utils.stats.StatCollector;
import com.showcase.utils.stats.StatFormatter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class StatUtils {
    private static final StatCollector statCollector = new StatCollector();

    public static Map<String, Integer> getPlayerStats(class_3222 player) {
        return statCollector.getPlayerStats(player);
    }

    public static Map<String, Map<String, Integer>> categorizeStats(Map<String, Integer> stats) {
        return StatCategories.categorizeStats(stats);
    }

    public static class_1799 createStatsBook(class_3222 player) {
        Map<String, Integer> playerStats = StatUtils.getPlayerStats(player);
        Map<String, Map<String, Integer>> categorizedStats = StatUtils.categorizeStats(playerStats);
        ArrayList<class_2561> pages = new ArrayList<class_2561>();
        pages.add(StatUtils.createTitlePage(player));
        categorizedStats.forEach((categoryKey, categoryStats) -> pages.addAll(StatUtils.createCategoryPages(categoryKey, categoryStats)));
        if (categorizedStats.isEmpty()) {
            pages.add(StatUtils.createEmptyPage());
        }
        return StatUtils.createBookItemStack(player, pages);
    }

    private static class_2561 createTitlePage(class_3222 player) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM-dd HH:mm");
        String currentTime = now.format(formatter);
        class_5250 coverPage = class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"gui.stats").method_27692(class_124.field_1067)).method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac").method_27692(class_124.field_1063)).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"gui.abuseReport.type.name")).method_27693(": ").method_10852(player.method_5477()).method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"UUID: ")).method_10852((class_2561)class_2561.method_43470((String)player.method_5845()).method_27692(class_124.field_1080)).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"showcase.stats.message.create_date")).method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)currentTime)).method_27693("\n\n");
        return coverPage;
    }

    private static List<class_2561> createCategoryPages(String categoryKey, Map<String, Integer> categoryStats) {
        ArrayList<class_2561> pages = new ArrayList<class_2561>();
        ModConfig.StatsDisplaySettings config = ModConfigManager.getConfig().statsDisplay;
        List<Map.Entry> sortedStats = categoryStats.entrySet().stream().filter(entry -> entry.getValue() != null && (!config.hideZeroStats || (Integer)entry.getValue() > 0)).sorted(config.sortStatsByValue ? (a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()) : (a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).limit(config.showOnlyTopStats ? (long)config.topStatsCount : (long)config.maxStatsPerCategory).toList();
        if (sortedStats.isEmpty()) {
            class_5250 emptyPage = StatUtils.createCategoryHeader(categoryKey, false, 1);
            emptyPage.method_10852((class_2561)class_2561.method_43471((String)"item.minecraft.bundle.empty").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            pages.add((class_2561)emptyPage);
            return pages;
        }
        int maxLinesPerPage = 13;
        int lineCount = 0;
        int pageNumber = 1;
        class_5250 currentPage = StatUtils.createCategoryHeader(categoryKey, false, pageNumber);
        for (Map.Entry stat : sortedStats) {
            if (lineCount >= 13) {
                pages.add((class_2561)currentPage);
                currentPage = StatUtils.createCategoryHeader(categoryKey, true, ++pageNumber);
                lineCount = 0;
            }
            String formattedValue = StatFormatter.formatStatValue((String)stat.getKey(), (Integer)stat.getValue());
            String displayName = StatFormatter.formatStatDisplayName((String)stat.getKey());
            class_2561 statNameText = StatUtils.createStatNameText(displayName);
            currentPage.method_10852((class_2561)statNameText.method_27661()).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43470((String)formattedValue)).method_27693("\n");
            ++lineCount;
        }
        pages.add((class_2561)currentPage);
        return pages;
    }

    private static class_5250 createCategoryHeader(String categoryKey, boolean isContinuation, int pageNumber) {
        class_5250 header = class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)categoryKey));
        if (isContinuation) {
            header.method_10852((class_2561)class_2561.method_43470((String)("(" + pageNumber + ")")).method_27692(class_124.field_1080));
        }
        header.method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"\u2501".repeat(20)).method_27692(class_124.field_1063)).method_27693("\n\n");
        return header;
    }

    private static class_2561 createEmptyPage() {
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"item.minecraft.bundle.empty").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
    }

    @NotNull
    private static class_2561 createStatNameText(String displayName) {
        return class_2561.method_43471((String)displayName);
    }

    private static class_1799 createBookItemStack(class_3222 player, List<class_2561> pages) {
        class_1799 bookStack = new class_1799((class_1935)class_1802.field_8360);
        class_9302 bookContent = new class_9302(class_9262.method_57137((Object)"title"), player.method_5477().getString(), 0, pages.stream().map(class_9262::method_57137).collect(Collectors.toList()), true);
        String fileName = player.method_5477().getString();
        String createdAt = DateTimeFormatter.ofPattern("MM-dd HH:mm").format(LocalDateTime.now());
        int totalPages = pages.size();
        class_5250 hoverText = class_2561.method_43470((String)"").method_27693(fileName).method_27692(class_124.field_1075).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"showcase.stats.message.create_date").method_27693(": ").method_27692(class_124.field_1080).method_27693(createdAt).method_27693("\n")).method_10852((class_2561)class_2561.method_43471((String)"showcase.stats.message.total_pages").method_27693(": ").method_27692(class_124.field_1080).method_27693(String.valueOf(totalPages))).method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"showcase.message.click_to_view").method_27693("\n\n").method_10852(TextUtils.BADGE).method_27693("\n"));
        bookStack.method_57379(class_9334.field_49606, (Object)bookContent);
        bookStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"gui.stats").method_10852((class_2561)class_2561.method_43470((String)" - ")).method_10852((class_2561)PlayerUtils.getSafeDisplayName(player)).method_10862(class_2583.field_24360.method_10949(TextEventFactory.showText((class_2561)hoverText))));
        return bookStack;
    }
}

