/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import de.maxhenkel.car.ModCreativeTabs;
import de.maxhenkel.car.blocks.BlockGasStation;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBackmixReactor;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.blocks.tileentity.TileEntityBlastFurnace;
import de.maxhenkel.car.blocks.tileentity.TileEntityCable;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.blocks.tileentity.TileEntityDynamo;
import de.maxhenkel.car.blocks.tileentity.TileEntityFluidExtractor;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.blocks.tileentity.TileEntityGenerator;
import de.maxhenkel.car.blocks.tileentity.TileEntityOilMill;
import de.maxhenkel.car.blocks.tileentity.TileEntitySign;
import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.car.commands.CommandCarDemo;
import de.maxhenkel.car.config.ClientConfig;
import de.maxhenkel.car.config.FuelConfig;
import de.maxhenkel.car.config.ServerConfig;
import de.maxhenkel.car.corelib.CommonRegistry;
import de.maxhenkel.car.corelib.config.DynamicConfig;
import de.maxhenkel.car.corelib.dataserializers.DataSerializerItemList;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import de.maxhenkel.car.events.BlockEvents;
import de.maxhenkel.car.fluids.FluidTypeCar;
import de.maxhenkel.car.fluids.ModFluids;
import de.maxhenkel.car.gui.ContainerBackmixReactor;
import de.maxhenkel.car.gui.ContainerBlastFurnace;
import de.maxhenkel.car.gui.ContainerCar;
import de.maxhenkel.car.gui.ContainerCarInventory;
import de.maxhenkel.car.gui.ContainerCarWorkshopCrafting;
import de.maxhenkel.car.gui.ContainerCarWorkshopRepair;
import de.maxhenkel.car.gui.ContainerFactoryTileEntity;
import de.maxhenkel.car.gui.ContainerFluidExtractor;
import de.maxhenkel.car.gui.ContainerGasStation;
import de.maxhenkel.car.gui.ContainerGasStationAdmin;
import de.maxhenkel.car.gui.ContainerGenerator;
import de.maxhenkel.car.gui.ContainerLicensePlate;
import de.maxhenkel.car.gui.ContainerOilMill;
import de.maxhenkel.car.gui.ContainerPainter;
import de.maxhenkel.car.gui.ContainerSign;
import de.maxhenkel.car.gui.ContainerSplitTank;
import de.maxhenkel.car.items.ItemBattery;
import de.maxhenkel.car.items.ItemLicensePlate;
import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.loottable.CopyFluid;
import de.maxhenkel.car.net.MessageCarGui;
import de.maxhenkel.car.net.MessageCarHorn;
import de.maxhenkel.car.net.MessageCenterCar;
import de.maxhenkel.car.net.MessageCenterCarClient;
import de.maxhenkel.car.net.MessageControlCar;
import de.maxhenkel.car.net.MessageCrash;
import de.maxhenkel.car.net.MessageEditLicensePlate;
import de.maxhenkel.car.net.MessageEditSign;
import de.maxhenkel.car.net.MessageGasStationAdminAmount;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessageRepairCar;
import de.maxhenkel.car.net.MessageSpawnCar;
import de.maxhenkel.car.net.MessageStartFuel;
import de.maxhenkel.car.net.MessageStarting;
import de.maxhenkel.car.net.MessageSyncTileEntity;
import de.maxhenkel.car.recipes.BlastFurnaceRecipe;
import de.maxhenkel.car.recipes.OilMillRecipe;
import de.maxhenkel.car.recipes.RecipeSerializerBlastFurnace;
import de.maxhenkel.car.recipes.RecipeSerializerKey;
import de.maxhenkel.car.recipes.RecipeSerializerOilMill;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.villagers.VillagerEvents;
import de.maxhenkel.tools.EntityTools;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.transfer.fluid.BucketResourceHandler;
import net.neoforged.neoforge.transfer.fluid.ItemAccessFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="car")
@EventBusSubscriber(modid="car")
public class CarMod {
    public static final String MODID = "car";
    public static final Logger LOGGER = LogManager.getLogger((String)"car");
    private static final DeferredRegister<EntityType<?>> ENTITY_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"car");
    public static final DeferredHolder<EntityType<?>, EntityType<EntityGenericCar>> CAR_ENTITY_TYPE = ENTITY_REGISTER.register("car", () -> CommonRegistry.registerEntity(MODID, MODID, MobCategory.MISC, EntityGenericCar.class, builder -> builder.setTrackingRange(128).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).sized(1.0f, 1.0f)));
    private static final DeferredRegister<LootItemFunctionType<?>> LOOT_FUNCTION_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.LOOT_FUNCTION_TYPE, (String)"car");
    public static DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<CopyFluid>> COPY_FLUID = LOOT_FUNCTION_TYPE_REGISTER.register("copy_fluid", () -> new LootItemFunctionType(CopyFluid.CODEC));
    private static final DeferredRegister<PoiType> POI_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)"car");
    public static final DeferredHolder<PoiType, PoiType> POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT = POI_TYPE_REGISTER.register("gas_station_attendant", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((BlockGasStation)((Object)((Object)ModBlocks.GAS_STATION.get()))).getStateDefinition().getPossibleStates()), 1, 1));
    private static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSION_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (String)"car");
    public static final DeferredHolder<VillagerProfession, VillagerProfession> VILLAGER_PROFESSION_GAS_STATION_ATTENDANT = VILLAGER_PROFESSION_REGISTER.register("gas_station_attendant", () -> new VillagerProfession((Component)Component.translatable((String)"entity.minecraft.villager.car.gas_station_attendant"), poi -> poi.is(POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT.getKey()), poi -> poi.is(POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT.getKey()), ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)ModSounds.GAS_STATION_ATTENDANT.get()));
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"car");
    public static final DeferredHolder<RecipeType<?>, RecipeType<BlastFurnaceRecipe>> RECIPE_TYPE_BLAST_FURNACE = RECIPE_TYPE_REGISTER.register("blast_furnace", () -> RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"blast_furnace")));
    public static final DeferredHolder<RecipeType<?>, RecipeType<OilMillRecipe>> RECIPE_TYPE_OIL_MILL = RECIPE_TYPE_REGISTER.register("oil_mill", () -> RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"oil_mill")));
    private static final DeferredRegister<EntityDataSerializer<?>> ENTITY_DATA_SERIALIZER_REGISTER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"car");
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<NonNullList<ItemStack>>> ITEM_LIST = ENTITY_DATA_SERIALIZER_REGISTER.register("serializer_item_list", () -> DataSerializerItemList.create());
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"car");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SimpleFluidContent>> FUEL_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("fuel", () -> DataComponentType.builder().persistent(SimpleFluidContent.CODEC).networkSynchronized(SimpleFluidContent.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SimpleFluidContent>> FLUID_STACK_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("fluid", () -> DataComponentType.builder().persistent(SimpleFluidContent.CODEC).networkSynchronized(SimpleFluidContent.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Unit>> TRADING_ITEM_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("trading_item", () -> DataComponentType.builder().persistent(Codec.unit((Object)Unit.INSTANCE)).networkSynchronized(StreamCodec.unit((Object)Unit.INSTANCE)).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> PAINTER_INDEX_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("index", () -> DataComponentType.builder().persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<UUID>> CAR_UUID_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("car", () -> DataComponentType.builder().persistent(UUIDUtil.CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<String>> LICENSE_PLATE_TEXT_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("plate_text", () -> DataComponentType.builder().persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8).build());
    public static ServerConfig SERVER_CONFIG;
    public static FuelConfig FUEL_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    private static final DeferredRegister<MenuType<?>> MENU_TYPE_REGISTER;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerBackmixReactor>> BACKMIX_REACTOR_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerBlastFurnace>> BLAST_FURNACE_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerCar>> CAR_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerCarInventory>> CAR_INVENTORY_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerCarWorkshopCrafting>> CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerCarWorkshopRepair>> CAR_WORKSHOP_REPAIR_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerFluidExtractor>> FLUID_EXTRACTOR_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerGasStation>> GAS_STATION_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerGasStationAdmin>> GAS_STATION_ADMIN_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerGenerator>> GENERATOR_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerLicensePlate>> LICENSE_PLATE_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerOilMill>> OIL_MILL_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerPainter>> PAINTER_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerSign>> SIGN_CONTAINER_TYPE;
    public static final DeferredHolder<MenuType<?>, MenuType<ContainerSplitTank>> SPLIT_TANK_CONTAINER_TYPE;
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityGenerator>> GENERATOR_TILE_ENTITY_TYPE;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityBackmixReactor>> BACKMIX_REACTOR_TILE_ENTITY_TYPE;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityBlastFurnace>> BLAST_FURNACE_TILE_ENTITY_TYPE;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityCable>> CABLE_TILE_ENTITY_TYPE;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityCarWorkshop>> CAR_WORKSHOP_TILE_ENTITY_TYPE;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityDynamo>> DYNAMO_TILE_ENTITY_TYPE;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityFluidExtractor>> FLUID_EXTRACTOR_TILE_ENTITY_TYPE;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityOilMill>> OIL_MILL_TILE_ENTITY_TYPE;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntitySign>> SIGN_TILE_ENTITY_TYPE;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntitySplitTank>> SPLIT_TANK_TILE_ENTITY_TYPE;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityTank>> TANK_TILE_ENTITY_TYPE;
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityGasStation>> GAS_STATION_TILE_ENTITY_TYPE;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER_REGISTER;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializerKey> CRAFTING_SPECIAL_KEY;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<BlastFurnaceRecipe>> CRAFTING_BLAST_FURNACE;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<OilMillRecipe>> CRAFTING_OIL_MILL;

    public CarMod(IEventBus eventBus) {
        SERVER_CONFIG = CommonRegistry.registerConfig(MODID, ModConfig.Type.SERVER, ServerConfig.class, true);
        FUEL_CONFIG = CommonRegistry.registerDynamicConfig(DynamicConfig.DynamicConfigType.SERVER, MODID, "fuel", FuelConfig.class);
        CLIENT_CONFIG = CommonRegistry.registerConfig(MODID, ModConfig.Type.CLIENT, ClientConfig.class);
        ModFluids.init(eventBus);
        ModBlocks.init(eventBus);
        ModItems.init(eventBus);
        ModSounds.init(eventBus);
        ModCreativeTabs.init(eventBus);
        ENTITY_REGISTER.register(eventBus);
        MENU_TYPE_REGISTER.register(eventBus);
        BLOCK_ENTITY_REGISTER.register(eventBus);
        LOOT_FUNCTION_TYPE_REGISTER.register(eventBus);
        RECIPE_TYPE_REGISTER.register(eventBus);
        RECIPE_SERIALIZER_REGISTER.register(eventBus);
        POI_TYPE_REGISTER.register(eventBus);
        VILLAGER_PROFESSION_REGISTER.register(eventBus);
        ENTITY_DATA_SERIALIZER_REGISTER.register(eventBus);
        DATA_COMPONENT_TYPE_REGISTER.register(eventBus);
    }

    @SubscribeEvent
    static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandCarDemo.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new BlockEvents());
        NeoForge.EVENT_BUS.register((Object)new VillagerEvents());
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.CANOLA_SEEDS.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.CANOLA_CAKE.get()), 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.CANOLA.get()), 0.65f);
    }

    @SubscribeEvent
    static void onRegisterPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("0");
        CommonRegistry.registerMessage(registrar, MessageControlCar.class);
        CommonRegistry.registerMessage(registrar, MessageCarGui.class);
        CommonRegistry.registerMessage(registrar, MessageStarting.class);
        CommonRegistry.registerMessage(registrar, MessageCrash.class);
        CommonRegistry.registerMessage(registrar, MessageStartFuel.class);
        CommonRegistry.registerMessage(registrar, MessageSyncTileEntity.class);
        CommonRegistry.registerMessage(registrar, MessageSpawnCar.class);
        CommonRegistry.registerMessage(registrar, MessageOpenCarWorkshopGui.class);
        CommonRegistry.registerMessage(registrar, MessageRepairCar.class);
        CommonRegistry.registerMessage(registrar, MessageCarHorn.class);
        CommonRegistry.registerMessage(registrar, MessageEditSign.class);
        CommonRegistry.registerMessage(registrar, MessageGasStationAdminAmount.class);
        CommonRegistry.registerMessage(registrar, MessageCenterCar.class);
        CommonRegistry.registerMessage(registrar, MessageCenterCarClient.class);
        CommonRegistry.registerMessage(registrar, MessageEditLicensePlate.class);
    }

    @SubscribeEvent
    static void onItemTooltip(ItemTooltipEvent event) {
        SimpleFluidContent fluid = (SimpleFluidContent)event.getItemStack().get(FLUID_STACK_DATA_COMPONENT);
        if (fluid != null) {
            FluidStack fluidStack = fluid.copy();
            event.getToolTip().add(1, Component.translatable((String)"tooltip.fluid", (Object[])new Object[]{Component.literal((String)fluidStack.getHoverName().getString()).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
            event.getToolTip().add(2, Component.translatable((String)"tooltip.amount", (Object[])new Object[]{Component.literal((String)String.valueOf(fluidStack.getAmount())).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
        }
    }

    @SubscribeEvent
    static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(((FluidTypeCar)((Object)ModFluids.BIO_DIESEL_TYPE.get())).getExtensions(), new FluidType[]{(FluidType)ModFluids.BIO_DIESEL_TYPE.get()});
        event.registerFluidType(((FluidTypeCar)((Object)ModFluids.CANOLA_OIL_TYPE.get())).getExtensions(), new FluidType[]{(FluidType)ModFluids.CANOLA_OIL_TYPE.get()});
        event.registerFluidType(((FluidTypeCar)((Object)ModFluids.METHANOL_TYPE.get())).getExtensions(), new FluidType[]{(FluidType)ModFluids.METHANOL_TYPE.get()});
        event.registerFluidType(((FluidTypeCar)((Object)ModFluids.GLYCERIN_TYPE.get())).getExtensions(), new FluidType[]{(FluidType)ModFluids.GLYCERIN_TYPE.get()});
        event.registerFluidType(((FluidTypeCar)((Object)ModFluids.CANOLA_METHANOL_MIX_TYPE.get())).getExtensions(), new FluidType[]{(FluidType)ModFluids.CANOLA_METHANOL_MIX_TYPE.get()});
    }

    @SubscribeEvent
    static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        CarMod.registerBlockCapabilities(event, GENERATOR_TILE_ENTITY_TYPE);
        CarMod.registerBlockCapabilities(event, BACKMIX_REACTOR_TILE_ENTITY_TYPE);
        CarMod.registerBlockCapabilities(event, BLAST_FURNACE_TILE_ENTITY_TYPE);
        CarMod.registerBlockCapabilities(event, CABLE_TILE_ENTITY_TYPE);
        CarMod.registerBlockCapabilities(event, CAR_WORKSHOP_TILE_ENTITY_TYPE);
        CarMod.registerBlockCapabilities(event, DYNAMO_TILE_ENTITY_TYPE);
        CarMod.registerBlockCapabilities(event, FLUID_EXTRACTOR_TILE_ENTITY_TYPE);
        CarMod.registerBlockCapabilities(event, OIL_MILL_TILE_ENTITY_TYPE);
        CarMod.registerBlockCapabilities(event, SIGN_TILE_ENTITY_TYPE);
        CarMod.registerBlockCapabilities(event, SPLIT_TANK_TILE_ENTITY_TYPE);
        CarMod.registerBlockCapabilities(event, TANK_TILE_ENTITY_TYPE);
        CarMod.registerBlockCapabilities(event, GAS_STATION_TILE_ENTITY_TYPE);
        event.registerItem(Capabilities.Fluid.ITEM, (object, context) -> context == null ? null : new BucketResourceHandler(context), new ItemLike[]{(ItemLike)ModItems.BIO_DIESEL_BUCKET.get(), (ItemLike)ModItems.CANOLA_OIL_BUCKET.get(), (ItemLike)ModItems.METHANOL_BUCKET.get(), (ItemLike)ModItems.GLYCERIN_BUCKET.get(), (ItemLike)ModItems.CANOLA_METHANOL_MIX_BUCKET.get()});
        event.registerItem(Capabilities.Fluid.ITEM, (object, context) -> context == null ? null : new ItemAccessFluidHandler(context, (DataComponentType)FUEL_DATA_COMPONENT.get(), ((Integer)CarMod.SERVER_CONFIG.canisterMaxFuel.get()).intValue()), new ItemLike[]{(ItemLike)ModItems.CANISTER.get()});
        event.registerItem(Capabilities.Energy.ITEM, (object, context) -> ((ItemBattery)((Object)((Object)ModItems.BATTERY.get()))).getEnergyHandler((ItemStack)object), new ItemLike[]{(ItemLike)ModItems.BATTERY.get()});
        CarMod.registerEntityCapabilities(event, CAR_ENTITY_TYPE);
    }

    private static <T extends TileEntityBase> void registerBlockCapabilities(RegisterCapabilitiesEvent event, DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> holder) {
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)holder.get(), (object, context) -> object.getFluidHandler());
        event.registerBlockEntity(Capabilities.Energy.BLOCK, (BlockEntityType)holder.get(), (object, context) -> object.getEnergyStorage());
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)holder.get(), (object, context) -> object.getItemHandler());
    }

    private static <T extends EntityVehicleBase> void registerEntityCapabilities(RegisterCapabilitiesEvent event, DeferredHolder<EntityType<?>, EntityType<EntityGenericCar>> holder) {
        event.registerEntity(Capabilities.Fluid.ENTITY, (EntityType)holder.get(), (car, context) -> car);
    }

    static {
        MENU_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)MODID);
        BACKMIX_REACTOR_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("backmix_reactor", () -> IMenuTypeExtension.create(new ContainerFactoryTileEntity<ContainerBackmixReactor, TileEntityBackmixReactor>(ContainerBackmixReactor::new)));
        BLAST_FURNACE_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("blast_furnace", () -> IMenuTypeExtension.create(new ContainerFactoryTileEntity<ContainerBlastFurnace, TileEntityBlastFurnace>(ContainerBlastFurnace::new)));
        CAR_CONTAINER_TYPE = MENU_TYPE_REGISTER.register(MODID, () -> IMenuTypeExtension.create((windowId, inv, data) -> {
            EntityGenericCar car = EntityTools.getCarByUUID(inv.player, data.readUUID());
            if (car == null) {
                return null;
            }
            return new ContainerCar(windowId, car, inv);
        }));
        CAR_INVENTORY_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("car_inventory", () -> IMenuTypeExtension.create((windowId, inv, data) -> {
            EntityGenericCar car = EntityTools.getCarByUUID(inv.player, data.readUUID());
            if (car == null) {
                return null;
            }
            return new ContainerCarInventory(windowId, car, inv);
        }));
        CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("car_workshop_crafting", () -> IMenuTypeExtension.create(new ContainerFactoryTileEntity<ContainerCarWorkshopCrafting, TileEntityCarWorkshop>(ContainerCarWorkshopCrafting::new)));
        CAR_WORKSHOP_REPAIR_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("car_workshop_repair", () -> IMenuTypeExtension.create(new ContainerFactoryTileEntity<ContainerCarWorkshopRepair, TileEntityCarWorkshop>(ContainerCarWorkshopRepair::new)));
        FLUID_EXTRACTOR_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("fluid_extractor", () -> IMenuTypeExtension.create(new ContainerFactoryTileEntity<ContainerFluidExtractor, TileEntityFluidExtractor>(ContainerFluidExtractor::new)));
        GAS_STATION_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("gas_station", () -> IMenuTypeExtension.create(new ContainerFactoryTileEntity<ContainerGasStation, TileEntityGasStation>(ContainerGasStation::new)));
        GAS_STATION_ADMIN_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("gas_station_admin", () -> IMenuTypeExtension.create(new ContainerFactoryTileEntity<ContainerGasStationAdmin, TileEntityGasStation>(ContainerGasStationAdmin::new)));
        GENERATOR_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("generator", () -> IMenuTypeExtension.create(new ContainerFactoryTileEntity<ContainerGenerator, TileEntityGenerator>(ContainerGenerator::new)));
        LICENSE_PLATE_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("license_plate", () -> IMenuTypeExtension.create((windowId, inv, data) -> {
            ItemStack licensePlate = null;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = inv.player.getItemInHand(hand);
                if (!(stack.getItem() instanceof ItemLicensePlate)) continue;
                licensePlate = stack;
                break;
            }
            if (licensePlate != null) {
                return new ContainerLicensePlate(windowId, licensePlate);
            }
            return null;
        }));
        OIL_MILL_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("oil_mill", () -> IMenuTypeExtension.create(new ContainerFactoryTileEntity<ContainerOilMill, TileEntityOilMill>(ContainerOilMill::new)));
        PAINTER_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("painter", () -> IMenuTypeExtension.create((windowId, inv, data) -> new ContainerPainter(windowId, inv, data.readBoolean())));
        SIGN_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("sign", () -> IMenuTypeExtension.create(new ContainerFactoryTileEntity<ContainerSign, TileEntitySign>(ContainerSign::new)));
        SPLIT_TANK_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("split_tank", () -> IMenuTypeExtension.create(new ContainerFactoryTileEntity<ContainerSplitTank, TileEntitySplitTank>(ContainerSplitTank::new)));
        BLOCK_ENTITY_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)MODID);
        GENERATOR_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("generator", () -> new BlockEntityType(TileEntityGenerator::new, new Block[]{(Block)ModBlocks.GENERATOR.get()}));
        BACKMIX_REACTOR_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("backmix_reactor", () -> new BlockEntityType(TileEntityBackmixReactor::new, new Block[]{(Block)ModBlocks.BACKMIX_REACTOR.get()}));
        BLAST_FURNACE_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("blast_furnace", () -> new BlockEntityType(TileEntityBlastFurnace::new, new Block[]{(Block)ModBlocks.BLAST_FURNACE.get()}));
        CABLE_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("cable", () -> new BlockEntityType(TileEntityCable::new, new Block[]{(Block)ModBlocks.CABLE.get()}));
        CAR_WORKSHOP_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("car_workshop", () -> new BlockEntityType(TileEntityCarWorkshop::new, new Block[]{(Block)ModBlocks.CAR_WORKSHOP.get()}));
        DYNAMO_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("dynamo", () -> new BlockEntityType(TileEntityDynamo::new, new Block[]{(Block)ModBlocks.DYNAMO.get()}));
        FLUID_EXTRACTOR_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("fluid_extractor", () -> new BlockEntityType(TileEntityFluidExtractor::new, new Block[]{(Block)ModBlocks.FLUID_EXTRACTOR.get()}));
        OIL_MILL_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("oil_mill", () -> new BlockEntityType(TileEntityOilMill::new, new Block[]{(Block)ModBlocks.OIL_MILL.get()}));
        SIGN_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("sign", () -> new BlockEntityType(TileEntitySign::new, new Block[]{(Block)ModBlocks.SIGN.get()}));
        SPLIT_TANK_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("split_tank", () -> new BlockEntityType(TileEntitySplitTank::new, new Block[]{(Block)ModBlocks.SPLIT_TANK.get()}));
        TANK_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("tank", () -> new BlockEntityType(TileEntityTank::new, new Block[]{(Block)ModBlocks.TANK.get()}));
        GAS_STATION_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("gas_station", () -> new BlockEntityType(TileEntityGasStation::new, new Block[]{(Block)ModBlocks.GAS_STATION.get()}));
        RECIPE_SERIALIZER_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)MODID);
        CRAFTING_SPECIAL_KEY = RECIPE_SERIALIZER_REGISTER.register("crafting_special_key", RecipeSerializerKey::new);
        CRAFTING_BLAST_FURNACE = RECIPE_SERIALIZER_REGISTER.register("blast_furnace", () -> new RecipeSerializerBlastFurnace(BlastFurnaceRecipe::new));
        CRAFTING_OIL_MILL = RECIPE_SERIALIZER_REGISTER.register("oil_mill", () -> new RecipeSerializerOilMill(OilMillRecipe::new));
    }
}

