/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import com.mojang.serialization.MapCodec;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;

public class BlockCarPressurePlate
extends BasePressurePlateBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    protected BlockCarPressurePlate(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.COLOR_BLACK).noCollision().strength(0.5f), BlockSetType.STONE);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BasePressurePlateBlock> codec() {
        return null;
    }

    protected int getSignalStrength(Level worldIn, BlockPos pos) {
        AABB axisalignedbb = TOUCH_AABB.move(pos);
        return worldIn.getEntitiesOfClass(EntityGenericCar.class, axisalignedbb).size() > 0 ? 15 : 0;
    }

    protected int getSignalForState(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected BlockState setSignalForState(BlockState state, int strength) {
        return (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }
}

