/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.car.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.tools.FluidInteractionTools;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;

public class BlockTank
extends BlockBase
implements EntityBlock {
    protected BlockTank(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).strength(0.5f).sound(SoundType.GLASS).noOcclusion());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    @Override
    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        BlockEntity te = worldIn.getBlockEntity(pos);
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank tank = (TileEntityTank)te;
        BlockTank.applyItemData(stack, tank);
        tank.synchronize();
    }

    public static void applyItemData(ItemStack stack, TileEntityTank tank) {
        SimpleFluidContent content = (SimpleFluidContent)stack.get(CarMod.FLUID_STACK_DATA_COMPONENT);
        if (content == null) {
            tank.setFluid(FluidStack.EMPTY);
            return;
        }
        tank.setFluid(content.copy());
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return FluidInteractionTools.tryFluidInteraction(player, interactionHand, level, blockPos) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public float getShadeBrightness(BlockState state, BlockGetter reader, BlockPos pos) {
        return 1.0f;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TileEntityTank(blockPos, blockState);
    }
}

