/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.BlockBackmixReactor;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.fluids.ModFluids;
import de.maxhenkel.tools.IntegerJournal;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class TileEntityBackmixReactor
extends TileEntityBase
implements ITickableBlockEntity,
ResourceHandler<FluidResource>,
EnergyHandler,
Container {
    public final int maxStorage;
    protected int storedEnergy;
    public final int energyUsage;
    public final int methanolUsage;
    public final int maxMethanol;
    protected int currentMethanol;
    public final int canolaUsage;
    public final int maxCanola;
    protected int currentCanola;
    public final int maxMix;
    protected int currentMix;
    public final int mixGeneration;
    public final int generatingTime;
    protected int timeToGenerate;
    private final SnapshotJournal<Integer> canolaJournal = new IntegerJournal(i -> {
        this.currentCanola = i;
        this.setChanged();
    }, () -> this.currentCanola);
    private final SnapshotJournal<Integer> methanolJournal = new IntegerJournal(i -> {
        this.currentMethanol = i;
        this.setChanged();
    }, () -> this.currentMethanol);
    private final SnapshotJournal<Integer> mixJournal = new IntegerJournal(i -> {
        this.currentMix = i;
        this.setChanged();
    }, () -> this.currentMix);
    private final SnapshotJournal<Integer> energyJournal = new IntegerJournal(i -> {
        this.storedEnergy = i;
        this.setChanged();
    }, () -> this.storedEnergy);
    public final ContainerData FIELDS = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return TileEntityBackmixReactor.this.storedEnergy;
                }
                case 1: {
                    return TileEntityBackmixReactor.this.currentCanola;
                }
                case 2: {
                    return TileEntityBackmixReactor.this.currentMethanol;
                }
                case 3: {
                    return TileEntityBackmixReactor.this.currentMix;
                }
                case 4: {
                    return TileEntityBackmixReactor.this.timeToGenerate;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityBackmixReactor.this.storedEnergy = value;
                    break;
                }
                case 1: {
                    TileEntityBackmixReactor.this.currentCanola = value;
                    break;
                }
                case 2: {
                    TileEntityBackmixReactor.this.currentMethanol = value;
                    break;
                }
                case 3: {
                    TileEntityBackmixReactor.this.currentMix = value;
                    break;
                }
                case 4: {
                    TileEntityBackmixReactor.this.timeToGenerate = value;
                }
            }
        }

        public int getCount() {
            return 5;
        }
    };

    public TileEntityBackmixReactor(BlockPos pos, BlockState state) {
        super((BlockEntityType)CarMod.BACKMIX_REACTOR_TILE_ENTITY_TYPE.get(), pos, state);
        this.maxStorage = (Integer)CarMod.SERVER_CONFIG.backmixReactorEnergyStorage.get();
        this.storedEnergy = 0;
        this.energyUsage = (Integer)CarMod.SERVER_CONFIG.backmixReactorEnergyUsage.get();
        this.maxMethanol = (Integer)CarMod.SERVER_CONFIG.backmixReactorFluidStorage.get();
        this.maxCanola = (Integer)CarMod.SERVER_CONFIG.backmixReactorFluidStorage.get();
        this.maxMix = (Integer)CarMod.SERVER_CONFIG.backmixReactorFluidStorage.get();
        this.currentCanola = 0;
        this.currentMethanol = 0;
        this.currentMix = 0;
        this.generatingTime = (Integer)CarMod.SERVER_CONFIG.backmixReactorGeneratingTime.get();
        this.timeToGenerate = 0;
        this.mixGeneration = (Integer)CarMod.SERVER_CONFIG.backmixReactorMixGeneration.get();
        this.methanolUsage = (Integer)CarMod.SERVER_CONFIG.backmixReactorMethanolUsage.get();
        this.canolaUsage = (Integer)CarMod.SERVER_CONFIG.backmixReactorCanolaUsage.get();
    }

    @Override
    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        this.setBlockEnabled(this.isEnabled());
        if (this.timeToGenerate > 0 && this.storedEnergy >= this.energyUsage) {
            this.storedEnergy -= this.energyUsage;
            --this.timeToGenerate;
            if (this.timeToGenerate == 0 && this.currentMix + this.mixGeneration <= this.maxMix) {
                this.currentMix += this.mixGeneration;
                this.currentCanola -= this.canolaUsage;
                this.currentMethanol -= this.methanolUsage;
            }
        } else if (this.storedEnergy >= this.energyUsage && this.currentCanola >= this.canolaUsage && this.currentMethanol >= this.methanolUsage && this.currentMix + this.mixGeneration <= this.maxMix) {
            this.timeToGenerate = this.generatingTime;
        }
        this.setChanged();
    }

    public boolean isEnabled() {
        if (this.storedEnergy > 0 && this.currentMix < this.maxMix && this.currentMethanol >= this.methanolUsage) {
            return this.currentCanola >= this.canolaUsage;
        }
        return false;
    }

    public void setBlockEnabled(boolean enabled) {
        BlockState state = this.level.getBlockState(this.getBlockPos());
        if (state.getBlock().equals(ModBlocks.BACKMIX_REACTOR.get())) {
            ((BlockBackmixReactor)((Object)ModBlocks.BACKMIX_REACTOR.get())).setPowered(this.level, this.worldPosition, state, enabled);
        }
    }

    @Override
    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putInt("stored_endergy", this.storedEnergy);
        valueOutput.putInt("canola", this.currentCanola);
        valueOutput.putInt("methanol", this.currentMethanol);
        valueOutput.putInt("mix", this.currentMix);
        valueOutput.putInt("time", this.timeToGenerate);
    }

    @Override
    public void loadAdditional(ValueInput valueInput) {
        this.storedEnergy = valueInput.getIntOr("stored_endergy", 0);
        this.currentCanola = valueInput.getIntOr("canola", 0);
        this.currentMethanol = valueInput.getIntOr("methanol", 0);
        this.currentMix = valueInput.getIntOr("mix", 0);
        this.timeToGenerate = valueInput.getIntOr("time", 0);
        super.loadAdditional(valueInput);
    }

    public int getContainerSize() {
        return 0;
    }

    public ItemStack getItem(int index) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeItem(int index, int count) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ItemStack.EMPTY;
    }

    public void setItem(int index, ItemStack stack) {
    }

    public int getMaxStackSize() {
        return 0;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(ContainerUser user) {
        super.startOpen(user);
    }

    public void stopOpen(ContainerUser user) {
        super.stopOpen(user);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return false;
    }

    public void clearContent() {
    }

    public boolean isEmpty() {
        return true;
    }

    public int getCurrentCanola() {
        return this.currentCanola;
    }

    public int getCurrentMethanol() {
        return this.currentMethanol;
    }

    public int getCurrentMix() {
        return this.currentMix;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getTimeToGenerate() {
        return this.timeToGenerate;
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.backmix_reactor");
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int size() {
        return 3;
    }

    public FluidResource getResource(int index) {
        if (index == 0) {
            return FluidResource.of((FluidStack)new FluidStack((Fluid)ModFluids.CANOLA_OIL.get(), this.currentCanola));
        }
        if (index == 1) {
            return FluidResource.of((FluidStack)new FluidStack((Fluid)ModFluids.METHANOL.get(), this.currentMethanol));
        }
        return FluidResource.of((FluidStack)new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX.get(), this.currentMix));
    }

    public long getAmountAsLong(int index) {
        if (index == 0) {
            return this.currentCanola;
        }
        if (index == 1) {
            return this.currentMethanol;
        }
        return this.currentMix;
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        if (index == 0 && resource.is((Object)((Fluid)ModFluids.CANOLA_OIL.get()))) {
            return this.maxCanola;
        }
        if (index == 1 && resource.is((Object)((Fluid)ModFluids.METHANOL.get()))) {
            return this.maxMethanol;
        }
        if (index == 2 && resource.is((Object)((Fluid)ModFluids.CANOLA_METHANOL_MIX.get()))) {
            return this.maxMix;
        }
        return 0L;
    }

    public boolean isValid(int index, FluidResource resource) {
        if (index == 0 && resource.is((Object)((Fluid)ModFluids.CANOLA_OIL.get()))) {
            return true;
        }
        if (index == 1 && resource.is((Object)((Fluid)ModFluids.METHANOL.get()))) {
            return true;
        }
        return index == 2 && resource.is((Object)((Fluid)ModFluids.CANOLA_METHANOL_MIX.get()));
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (resource.is((Object)((Fluid)ModFluids.METHANOL.get()))) {
            int actualAmount = Math.min(this.maxMethanol - this.currentMethanol, amount);
            this.methanolJournal.updateSnapshots(transaction);
            this.currentMethanol += actualAmount;
            this.setChanged();
            return actualAmount;
        }
        if (resource.is((Object)((Fluid)ModFluids.CANOLA_OIL.get()))) {
            int actualAmount = Math.min(this.maxCanola - this.currentCanola, amount);
            this.canolaJournal.updateSnapshots(transaction);
            this.currentCanola += actualAmount;
            this.setChanged();
            return actualAmount;
        }
        return 0;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (!resource.is((Object)((Fluid)ModFluids.CANOLA_METHANOL_MIX.get()))) {
            return 0;
        }
        int actualAmount = Math.min(amount, this.currentMix);
        this.mixJournal.updateSnapshots(transaction);
        this.currentMix -= actualAmount;
        this.setChanged();
        return actualAmount;
    }

    public long getAmountAsLong() {
        return this.storedEnergy;
    }

    public long getCapacityAsLong() {
        return this.maxStorage;
    }

    public int insert(int amount, TransactionContext transaction) {
        int energyNeeded = this.maxStorage - this.storedEnergy;
        int toStore = Math.min(energyNeeded, amount);
        this.energyJournal.updateSnapshots(transaction);
        this.storedEnergy += toStore;
        this.setChanged();
        return toStore;
    }

    public int extract(int amount, TransactionContext transaction) {
        return 0;
    }

    @Override
    public EnergyHandler getEnergyStorage() {
        return this;
    }

    @Override
    public ResourceHandler<FluidResource> getFluidHandler() {
        return this;
    }
}

