/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.corelib.codec.CodecUtils;
import de.maxhenkel.car.corelib.codec.ValueInputOutputUtils;
import de.maxhenkel.car.net.MessageSyncTileEntity;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;

public abstract class TileEntityBase
extends BlockEntity
implements Nameable {
    private Component name;
    private CompoundTag compoundLast;

    public TileEntityBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void synchronize() {
        Level level;
        if (!this.level.isClientSide() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CompoundTag last = this.getUpdateTag((HolderLookup.Provider)serverLevel.registryAccess());
            if (this.compoundLast == null || !this.compoundLast.equals((Object)last)) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new MessageSyncTileEntity(this.worldPosition, last), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.compoundLast = last;
            }
        }
    }

    public void synchronize(int ticks) {
        if (this.level.getGameTime() % (long)ticks == 0L) {
            this.synchronize();
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        TagValueOutput valueOutput = ValueInputOutputUtils.createValueOutput(this, provider);
        this.saveAdditional((ValueOutput)valueOutput);
        return ValueInputOutputUtils.toTag(valueOutput);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public abstract Component getTranslatedName();

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component getName() {
        return this.name != null ? this.name : this.getTranslatedName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public abstract ContainerData getFields();

    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        if (this.name != null) {
            CodecUtils.toJsonString(ComponentSerialization.CODEC, this.name).ifPresent(s -> valueOutput.putString("CustomName", s));
        }
    }

    public void loadAdditional(ValueInput valueInput) {
        Optional optionalName = valueInput.getString("CustomName");
        optionalName.ifPresent(s -> {
            this.name = CodecUtils.fromJson(ComponentSerialization.CODEC, s).orElse(null);
        });
        super.loadAdditional(valueInput);
    }

    @Nullable
    public ResourceHandler<FluidResource> getFluidHandler() {
        return null;
    }

    @Nullable
    public EnergyHandler getEnergyStorage() {
        return null;
    }

    @Nullable
    public ResourceHandler<ItemResource> getItemHandler() {
        return null;
    }
}

