/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.tools.BlockPosList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class TileEntityCable
extends TileEntityBase
implements ITickableBlockEntity,
EnergyHandler {
    private final int transferRate;

    public TileEntityCable(int transferRate, BlockPos pos, BlockState state) {
        super((BlockEntityType)CarMod.CABLE_TILE_ENTITY_TYPE.get(), pos, state);
        this.transferRate = transferRate;
    }

    public TileEntityCable(BlockPos pos, BlockState state) {
        this((Integer)CarMod.SERVER_CONFIG.cableTransferRate.get(), pos, state);
    }

    @Override
    public void tick() {
        int energy = 0;
        ArrayList<EnergyHandler> providers = new ArrayList<EnergyHandler>();
        for (Direction facing : Direction.values()) {
            int extract;
            EnergyHandler energyHandler = (EnergyHandler)this.level.getCapability(Capabilities.Energy.BLOCK, this.worldPosition.relative(facing), (Object)facing.getOpposite());
            if (energyHandler == null || energyHandler instanceof TileEntityCable) continue;
            int cex = Math.max(0, this.transferRate - energy);
            if (cex <= 0) break;
            try (Transaction transaction = Transaction.open(null);){
                extract = energyHandler.extract(cex, (TransactionContext)transaction);
            }
            if (extract <= 0) continue;
            energy += extract;
            providers.add(energyHandler);
        }
        if (energy <= 0) {
            return;
        }
        ArrayList<EnergyHandler> receivers = new ArrayList<EnergyHandler>();
        this.getConnectedReceivers(providers, receivers, new BlockPosList(), this.worldPosition);
        if (receivers.size() <= 0) {
            return;
        }
        int split = energy / receivers.size();
        if (split <= 0) {
            return;
        }
        int received = 0;
        try (Transaction transaction = Transaction.open(null);){
            for (EnergyHandler entry : receivers) {
                received += entry.insert(split, (TransactionContext)transaction);
            }
            for (EnergyHandler entry : providers) {
                if (received <= 0) break;
                received -= entry.extract(received, (TransactionContext)transaction);
            }
            transaction.commit();
        }
    }

    public void getConnectedReceivers(List<EnergyHandler> sources, List<EnergyHandler> receivers, BlockPosList positions, BlockPos pos) {
        for (Direction side : Direction.values()) {
            BlockPos p = pos.relative(side);
            if (positions.contains(p)) continue;
            BlockState state = this.level.getBlockState(p);
            if (state.getBlock().equals(ModBlocks.CABLE.get())) {
                positions.add(p);
                this.getConnectedReceivers(sources, receivers, positions, p);
                continue;
            }
            EnergyHandler energyHandler = (EnergyHandler)this.level.getCapability(Capabilities.Energy.BLOCK, pos.relative(side), (Object)side.getOpposite());
            if (energyHandler == null || energyHandler.equals((Object)this) || sources.contains(energyHandler) || receivers.contains(energyHandler)) continue;
            receivers.add(energyHandler);
        }
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.cable");
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }

    public long getAmountAsLong() {
        return 0L;
    }

    public long getCapacityAsLong() {
        return 0L;
    }

    public int insert(int amount, TransactionContext transaction) {
        return 0;
    }

    public int extract(int amount, TransactionContext transaction) {
        return 0;
    }

    @Override
    public EnergyHandler getEnergyStorage() {
        return this;
    }
}

