/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.BlockCarWorkshop;
import de.maxhenkel.car.blocks.BlockCarWorkshopOutter;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.parts.PartRegistry;
import de.maxhenkel.car.items.ICarPart;
import de.maxhenkel.car.items.ItemKey;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class TileEntityCarWorkshop
extends TileEntityBase
implements Container {
    private SimpleContainer craftingMatrix = new SimpleContainer(15);
    private SimpleContainer repairInventory = new SimpleContainer(3);
    private EntityGenericCar currentCraftingCar;
    private List<Component> messages = new ArrayList<Component>();

    public TileEntityCarWorkshop(BlockPos pos, BlockState state) {
        super((BlockEntityType)CarMod.CAR_WORKSHOP_TILE_ENTITY_TYPE.get(), pos, state);
    }

    public SimpleContainer getRepairInventory() {
        return this.repairInventory;
    }

    public EntityGenericCar getCarOnTop() {
        BlockState ownState = this.level.getBlockState(this.worldPosition);
        if (!ownState.getBlock().equals(ModBlocks.CAR_WORKSHOP.get())) {
            return null;
        }
        BlockPos start = this.worldPosition.relative(Direction.UP);
        AABB aabb = new AABB((double)start.getX(), (double)start.getY(), (double)start.getZ(), (double)(start.getX() + 1), (double)(start.getY() + 1), (double)(start.getZ() + 1));
        List cars = this.level.getEntitiesOfClass(EntityGenericCar.class, aabb);
        if (cars.isEmpty()) {
            return null;
        }
        return (EntityGenericCar)((Object)cars.get(0));
    }

    public void spawnCar(ServerPlayer player) {
        if (!this.areBlocksAround()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.incomplete_structure"));
            return;
        }
        if (!this.isTopFree()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.blocks_on_top"));
            return;
        }
        this.updateRecipe();
        EntityGenericCar car = this.currentCraftingCar;
        if (car == null || !this.isCurrentCraftingCarValid()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.no_recipe"));
            return;
        }
        BlockPos spawnPos = this.worldPosition.above();
        car.setPos((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
        this.removeCraftItems();
        car.setFuelAmount(100);
        this.level.addFreshEntity((Entity)car);
        car.setIsSpawned(true);
        car.initTemperature();
    }

    public void checkValidity() {
        if (this.areBlocksAround()) {
            this.placeStructure();
        }
    }

    private void placeStructure() {
        this.level.setBlockAndUpdate(this.worldPosition.offset(0, 0, -1), this.getState(1));
        this.level.setBlockAndUpdate(this.worldPosition.offset(1, 0, -1), this.getState(2));
        this.level.setBlockAndUpdate(this.worldPosition.offset(1, 0, 0), this.getState(3));
        this.level.setBlockAndUpdate(this.worldPosition.offset(1, 0, 1), this.getState(4));
        this.level.setBlockAndUpdate(this.worldPosition.offset(0, 0, 1), this.getState(5));
        this.level.setBlockAndUpdate(this.worldPosition.offset(-1, 0, 1), this.getState(6));
        this.level.setBlockAndUpdate(this.worldPosition.offset(-1, 0, 0), this.getState(7));
        this.level.setBlockAndUpdate(this.worldPosition.offset(-1, 0, -1), this.getState(8));
        this.setOwnBlockValid(true);
    }

    private void setOwnBlockValid(boolean valid) {
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (!state.getBlock().equals(ModBlocks.CAR_WORKSHOP.get())) {
            return;
        }
        ((BlockCarWorkshop)((Object)ModBlocks.CAR_WORKSHOP.get())).setValid(this.level, this.worldPosition, state, valid);
    }

    private BlockState getState(int meta) {
        return (BlockState)((BlockCarWorkshopOutter)((Object)ModBlocks.CAR_WORKSHOP_OUTTER.get())).defaultBlockState().setValue((Property)BlockCarWorkshopOutter.POSITION, (Comparable)Integer.valueOf(meta));
    }

    public boolean areBlocksAround() {
        if (!this.checkSideBlock(this.worldPosition.offset(0, 0, 1))) {
            return false;
        }
        if (!this.checkSideBlock(this.worldPosition.offset(1, 0, 0))) {
            return false;
        }
        if (!this.checkSideBlock(this.worldPosition.offset(1, 0, 1))) {
            return false;
        }
        if (!this.checkSideBlock(this.worldPosition.offset(0, 0, -1))) {
            return false;
        }
        if (!this.checkSideBlock(this.worldPosition.offset(-1, 0, 0))) {
            return false;
        }
        if (!this.checkSideBlock(this.worldPosition.offset(-1, 0, -1))) {
            return false;
        }
        if (!this.checkSideBlock(this.worldPosition.offset(-1, 0, 1))) {
            return false;
        }
        return this.checkSideBlock(this.worldPosition.offset(1, 0, -1));
    }

    public boolean isTopFree() {
        for (int x = -1; x <= 1; ++x) {
            for (int y = 1; y <= 2; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (this.checkBlockAir(this.worldPosition.offset(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkBlockAir(BlockPos p) {
        return this.level.isEmptyBlock(p);
    }

    private boolean checkSideBlock(BlockPos p) {
        return this.level.getBlockState(p).getBlock().equals(ModBlocks.CAR_WORKSHOP_OUTTER.get());
    }

    @Override
    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ItemUtils.saveInventory(valueOutput, "crafting", (Container)this.craftingMatrix);
        ItemUtils.saveInventory(valueOutput, "repair", (Container)this.repairInventory);
    }

    @Override
    public void loadAdditional(ValueInput valueInput) {
        ItemUtils.readInventory(valueInput, "crafting", (Container)this.craftingMatrix);
        ItemUtils.readInventory(valueInput, "repair", (Container)this.repairInventory);
        super.loadAdditional(valueInput);
    }

    public void updateRecipe() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.craftingMatrix.getContainerSize(); ++i) {
            ItemStack stack = this.craftingMatrix.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ICarPart) {
                if (((ICarPart)stack.getItem()).getPart(stack) == null) continue;
                items.add(stack);
                continue;
            }
            this.currentCraftingCar = null;
            this.messages = Arrays.asList(Component.translatable((String)"message.parts.no_car_part", (Object[])new Object[]{stack.getHoverName()}));
            return;
        }
        ArrayList<Component> messages = new ArrayList<Component>();
        this.currentCraftingCar = TileEntityCarWorkshop.createCar(this.level, items, messages);
        this.messages = messages;
    }

    public static EntityGenericCar createCar(Level world, List<ItemStack> partStacks, List<Component> messages) {
        EntityGenericCar car = new EntityGenericCar(world);
        car.setItem(0, ItemKey.getKeyForCar(car.getUUID()));
        car.setItem(1, ItemKey.getKeyForCar(car.getUUID()));
        car.setIsSpawned(false);
        for (int i = 0; i < partStacks.size(); ++i) {
            car.getPartInventory().setItem(i, partStacks.get(i).copy().split(1));
        }
        car.initParts();
        boolean showable = PartRegistry.isValid(car, messages);
        if (!showable) {
            return null;
        }
        car.tryInitPartsAndModel();
        car.setPartSerializer();
        return car;
    }

    public static EntityGenericCar createCar(Level world, List<ItemStack> partStacks) {
        return TileEntityCarWorkshop.createCar(world, partStacks, new ArrayList<Component>());
    }

    public void removeCraftItems() {
        for (int i = 0; i < this.craftingMatrix.getContainerSize(); ++i) {
            ItemStack stack = this.craftingMatrix.getItem(i);
            if (stack.isEmpty()) continue;
            stack.shrink(1);
        }
    }

    public int getContainerSize() {
        return this.craftingMatrix.getContainerSize();
    }

    public ItemStack getItem(int index) {
        return this.craftingMatrix.getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack stack = this.craftingMatrix.removeItem(index, count);
        this.updateRecipe();
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.craftingMatrix.removeItemNoUpdate(index);
        this.updateRecipe();
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.craftingMatrix.setItem(index, stack);
        this.updateRecipe();
    }

    public int getMaxStackSize() {
        return this.craftingMatrix.getMaxStackSize();
    }

    public boolean stillValid(Player player) {
        return this.craftingMatrix.stillValid(player);
    }

    public boolean isEmpty() {
        return this.craftingMatrix.isEmpty();
    }

    public void startOpen(ContainerUser user) {
        this.craftingMatrix.startOpen(user);
    }

    public void stopOpen(ContainerUser user) {
        this.craftingMatrix.stopOpen(user);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.craftingMatrix.canPlaceItem(index, stack);
    }

    public void clearContent() {
        this.craftingMatrix.clearContent();
        this.updateRecipe();
    }

    public EntityGenericCar getCurrentCraftingCar() {
        return this.currentCraftingCar;
    }

    public boolean isCurrentCraftingCarValid() {
        return this.messages.size() <= 0;
    }

    public List<Component> getMessages() {
        return this.messages;
    }

    public void repairCar(ServerPlayer player) {
        if (!this.areBlocksAround()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.incomplete_structure"));
            return;
        }
        if (!this.areRepairItemsInside()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.no_repair_items"));
            return;
        }
        EntityGenericCar carBase = this.getCarOnTop();
        if (!(carBase instanceof EntityCarDamageBase)) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.no_car"));
            return;
        }
        EntityCarDamageBase car = carBase;
        if (car.getDamage() <= 0.0f) {
            return;
        }
        this.damageRepairItemsInside((Player)player);
        car.setDamage(car.getDamage() - 10.0f);
        ModSounds.playSound((SoundEvent)ModSounds.RATCHET.get(), this.level, this.worldPosition, null, SoundSource.BLOCKS);
    }

    public boolean areRepairItemsInside() {
        for (int i = 0; i < this.repairInventory.getContainerSize(); ++i) {
            if (!this.repairInventory.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void damageRepairItemsInside(Player player) {
        for (int i = 0; i < this.repairInventory.getContainerSize(); ++i) {
            Level level;
            ItemStack stack = this.repairInventory.getItem(i);
            if (stack.isEmpty() || !((level = player.level()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            stack.hurtAndBreak(10, serverLevel, (LivingEntity)player, item -> {});
        }
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)((BlockCarWorkshop)((Object)ModBlocks.CAR_WORKSHOP.get())).getDescriptionId());
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }
}

