/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.tools.IntegerJournal;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class TileEntityDynamo
extends TileEntityBase
implements EnergyHandler,
ITickableBlockEntity {
    private int storedEnergy;
    public final int maxStorage;
    public final int generation;
    private final SnapshotJournal<Integer> energyJournal = new IntegerJournal(i -> {
        this.storedEnergy = i;
        this.setChanged();
    }, () -> this.storedEnergy);

    public TileEntityDynamo(BlockPos pos, BlockState state) {
        super((BlockEntityType)CarMod.DYNAMO_TILE_ENTITY_TYPE.get(), pos, state);
        this.maxStorage = (Integer)CarMod.SERVER_CONFIG.dynamoEnergyStorage.get();
        this.generation = (Integer)CarMod.SERVER_CONFIG.dynamoEnergyGeneration.get();
        this.storedEnergy = 0;
    }

    @Override
    public void tick() {
        for (Direction side : Direction.values()) {
            EnergyHandler energyHandler = (EnergyHandler)this.level.getCapability(Capabilities.Energy.BLOCK, this.worldPosition.relative(side), (Object)side.getOpposite());
            if (energyHandler == null) continue;
            TileEntityDynamo.pushEnergy(this, energyHandler, this.storedEnergy, null);
        }
    }

    private static int pushEnergy(EnergyHandler provider, EnergyHandler receiver, int maxAmount, @Nullable TransactionContext transaction) {
        int energy;
        int receivedSim;
        try (Transaction t = Transaction.open((TransactionContext)transaction);){
            int energySim = provider.extract(maxAmount, (TransactionContext)t);
            receivedSim = receiver.insert(energySim, (TransactionContext)t);
        }
        try (Transaction t = Transaction.open((TransactionContext)transaction);){
            energy = provider.extract(receivedSim, (TransactionContext)t);
            receiver.insert(energy, (TransactionContext)t);
            t.commit();
        }
        return energy;
    }

    public void addEnergy(int energy) {
        this.storedEnergy += energy;
        if (this.storedEnergy > this.maxStorage) {
            this.storedEnergy = this.maxStorage;
        }
        this.setChanged();
    }

    @Override
    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putInt("stored_energy", this.storedEnergy);
    }

    @Override
    public void loadAdditional(ValueInput valueInput) {
        this.storedEnergy = valueInput.getIntOr("stored_energy", 0);
        super.loadAdditional(valueInput);
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.dynamo");
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }

    public long getAmountAsLong() {
        return this.storedEnergy;
    }

    public long getCapacityAsLong() {
        return this.maxStorage;
    }

    public int insert(int amount, TransactionContext transaction) {
        return 0;
    }

    public int extract(int amount, TransactionContext transaction) {
        int i = Math.min(amount, this.storedEnergy);
        this.energyJournal.updateSnapshots(transaction);
        this.storedEnergy -= i;
        this.setChanged();
        return i;
    }

    @Override
    public EnergyHandler getEnergyStorage() {
        return this;
    }
}

