/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.blocks.BlockGui;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.recipes.EnergyFluidProducerRecipe;
import de.maxhenkel.tools.IntegerJournal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public abstract class TileEntityEnergyFluidProducer
extends TileEntityBase
implements EnergyHandler,
WorldlyContainer,
ITickableBlockEntity,
ResourceHandler<FluidResource>,
RecipeInput {
    protected RecipeType<? extends EnergyFluidProducerRecipe> recipeType;
    protected SimpleContainer inventory;
    protected int maxEnergy;
    protected int storedEnergy;
    protected int time;
    protected int fluidAmount;
    protected int currentMillibuckets;
    private final SnapshotJournal<Integer> energyJournal = new IntegerJournal(i -> {
        this.storedEnergy = i;
        this.setChanged();
    }, () -> this.storedEnergy);
    private final SnapshotJournal<Integer> fluidJournal = new IntegerJournal(i -> {
        this.currentMillibuckets = i;
        this.setChanged();
    }, () -> this.currentMillibuckets);
    public final ContainerData FIELDS = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return TileEntityEnergyFluidProducer.this.time;
                }
                case 1: {
                    return TileEntityEnergyFluidProducer.this.storedEnergy;
                }
                case 2: {
                    return TileEntityEnergyFluidProducer.this.currentMillibuckets;
                }
                case 3: {
                    Level level = TileEntityEnergyFluidProducer.this.level;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        return TileEntityEnergyFluidProducer.this.getTimeToGenerate(serverLevel);
                    }
                    return 0;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityEnergyFluidProducer.this.time = value;
                    break;
                }
                case 1: {
                    TileEntityEnergyFluidProducer.this.storedEnergy = value;
                    break;
                }
                case 2: {
                    TileEntityEnergyFluidProducer.this.currentMillibuckets = value;
                    break;
                }
                case 3: {
                    TileEntityEnergyFluidProducer.this.clientTimeToGenerate = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    private int clientTimeToGenerate;

    public TileEntityEnergyFluidProducer(BlockEntityType<?> tileEntityTypeIn, RecipeType<? extends EnergyFluidProducerRecipe> recipeType, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.recipeType = recipeType;
        this.inventory = new SimpleContainer(2);
        this.maxEnergy = 10000;
        this.storedEnergy = 0;
        this.time = 0;
        this.fluidAmount = 3000;
        this.currentMillibuckets = 0;
    }

    public EnergyFluidProducerRecipe getRecipe(ServerLevel serverLevel) {
        return serverLevel.recipeAccess().getRecipeFor(this.recipeType, (RecipeInput)this, this.level).map(RecipeHolder::value).orElse(null);
    }

    @Override
    public void tick() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack input = this.inventory.getItem(0);
        ItemStack output = this.inventory.getItem(1);
        EnergyFluidProducerRecipe recipe = this.getRecipe(serverLevel);
        if (recipe == null) {
            this.time = 0;
            this.setChanged();
            this.setBlockEnabled(false);
            return;
        }
        if (this.storedEnergy < recipe.getEnergy()) {
            this.setBlockEnabled(false);
            return;
        }
        if (input.isEmpty()) {
            this.time = 0;
            this.setChanged();
            this.setBlockEnabled(false);
            return;
        }
        if (!(output.isEmpty() || ItemStack.isSameItem((ItemStack)output, (ItemStack)recipe.getResultItem()) && output.getCount() + recipe.getResultItem().getCount() <= output.getMaxStackSize())) {
            this.time = 0;
            this.setChanged();
            this.setBlockEnabled(false);
            return;
        }
        if (this.currentMillibuckets + recipe.getFluidAmount() > this.fluidAmount) {
            this.time = 0;
            this.setChanged();
            this.setBlockEnabled(false);
            return;
        }
        ++this.time;
        this.storedEnergy -= recipe.getEnergy();
        if (this.time > recipe.getDuration()) {
            this.time = 0;
            if (output.isEmpty()) {
                this.inventory.setItem(1, recipe.getResultItem());
            } else if (output.getCount() < output.getMaxStackSize()) {
                output.grow(recipe.getResultItem().getCount());
            }
            this.currentMillibuckets += recipe.getFluidAmount();
            input.shrink(1);
        }
        this.setChanged();
        this.setBlockEnabled(true);
    }

    public abstract BlockGui<? extends TileEntityEnergyFluidProducer> getOwnBlock();

    public void setBlockEnabled(boolean enabled) {
        BlockState state = this.level.getBlockState(this.getBlockPos());
        if (state.getBlock().equals(this.getOwnBlock())) {
            this.getOwnBlock().setPowered(this.level, this.worldPosition, state, enabled);
        }
    }

    @Override
    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putInt("energy_stored", this.storedEnergy);
        valueOutput.putInt("time", this.time);
        valueOutput.putInt("fluid_stored", this.currentMillibuckets);
        ItemUtils.saveInventory(valueOutput, "slots", (Container)this.inventory);
    }

    @Override
    public void loadAdditional(ValueInput valueInput) {
        this.storedEnergy = valueInput.getIntOr("energy_stored", 0);
        this.time = valueInput.getIntOr("time", 0);
        this.currentMillibuckets = valueInput.getIntOr("fluid_stored", 0);
        ItemUtils.readInventory(valueInput, "slots", (Container)this.inventory);
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    public ItemStack getItem(int index) {
        return this.inventory.getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.inventory.removeItem(index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.inventory.removeItemNoUpdate(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.setItem(index, stack);
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public void startOpen(ContainerUser user) {
        this.inventory.startOpen(user);
    }

    public void stopOpen(ContainerUser user) {
        this.inventory.stopOpen(user);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.inventory.canPlaceItem(index, stack);
    }

    public void clearContent() {
        this.inventory.clearContent();
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public int[] getSlotsForFace(Direction side) {
        return new int[]{0, 1};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, Direction direction) {
        return index == 0;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getTimeToGenerate(ServerLevel serverLevel) {
        EnergyFluidProducerRecipe recipe = this.getRecipe(serverLevel);
        if (recipe == null) {
            return 0;
        }
        return recipe.getDuration();
    }

    public int getClientTimeToGenerate() {
        return this.clientTimeToGenerate;
    }

    public int getGeneratingTime() {
        return this.time;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public int getCurrentMillibuckets() {
        return this.currentMillibuckets;
    }

    public abstract Fluid getProducingFluid();

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int size() {
        return 1;
    }

    public FluidResource getResource(int index) {
        if (index == 0) {
            return FluidResource.of((Fluid)this.getProducingFluid());
        }
        return FluidResource.of((Fluid)Fluids.EMPTY);
    }

    public long getAmountAsLong(int index) {
        if (index == 0) {
            return this.currentMillibuckets;
        }
        return 0L;
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        if (index == 0 && resource.is((Object)this.getProducingFluid())) {
            return this.fluidAmount;
        }
        return 0L;
    }

    public boolean isValid(int index, FluidResource resource) {
        return index == 0 && resource.is((Object)this.getProducingFluid());
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        return 0;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (index != 0 || !resource.is((Object)this.getProducingFluid())) {
            return 0;
        }
        int actualAmount = Math.min(amount, this.currentMillibuckets);
        this.fluidJournal.updateSnapshots(transaction);
        this.currentMillibuckets -= actualAmount;
        this.setChanged();
        return actualAmount;
    }

    public long getAmountAsLong() {
        return this.storedEnergy;
    }

    public long getCapacityAsLong() {
        return this.maxEnergy;
    }

    public int insert(int amount, TransactionContext transaction) {
        int energyNeeded = this.maxEnergy - this.storedEnergy;
        int toStore = Math.min(energyNeeded, amount);
        this.energyJournal.updateSnapshots(transaction);
        this.storedEnergy += toStore;
        this.setChanged();
        return toStore;
    }

    public int extract(int amount, TransactionContext transaction) {
        return 0;
    }

    @Override
    public EnergyHandler getEnergyStorage() {
        return this;
    }

    @Override
    public ResourceHandler<FluidResource> getFluidHandler() {
        return this;
    }
}

