/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.BlockFluidExtractor;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.tools.BlockPosList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class TileEntityFluidExtractor
extends TileEntityBase
implements ITickableBlockEntity {
    private ResourceHandler<FluidResource> extractHandler;
    private final int drainSpeed;
    private ItemStack filter;

    public TileEntityFluidExtractor(BlockPos pos, BlockState state) {
        super((BlockEntityType)CarMod.FLUID_EXTRACTOR_TILE_ENTITY_TYPE.get(), pos, state);
        this.drainSpeed = (Integer)CarMod.SERVER_CONFIG.fluidExtractorDrainSpeed.get();
        this.filter = ItemStack.EMPTY;
    }

    @Nullable
    public Fluid getFilterFluid() {
        if (this.filter.isEmpty()) {
            return null;
        }
        FluidStack stack = FluidUtil.getFirstStackContained((ItemStack)this.filter);
        if (stack.isEmpty() || stack.getAmount() <= 0) {
            return null;
        }
        return stack.getFluid();
    }

    @Override
    public void tick() {
        int drainSimulated;
        if (this.level.isClientSide()) {
            return;
        }
        this.updateExtractHandler();
        if (this.extractHandler == null) {
            return;
        }
        FluidResource toExtract = null;
        Fluid filterFluid = this.getFilterFluid();
        if (filterFluid == null) {
            for (int i = 0; i < this.extractHandler.size(); ++i) {
                int simulatedExtract;
                FluidResource resource2 = (FluidResource)this.extractHandler.getResource(i);
                if (resource2.isEmpty()) continue;
                try (Transaction transaction = Transaction.open(null);){
                    simulatedExtract = this.extractHandler.extract((Resource)resource2, this.drainSpeed, (TransactionContext)transaction);
                }
                if (simulatedExtract <= 0) continue;
                toExtract = resource2;
                break;
            }
            if (toExtract == null) {
                return;
            }
        } else {
            toExtract = FluidResource.of((Fluid)filterFluid);
        }
        try (Transaction transaction = Transaction.open(null);){
            drainSimulated = this.extractHandler.extract((Resource)toExtract, this.drainSpeed, (TransactionContext)transaction);
        }
        if (drainSimulated <= 0) {
            return;
        }
        LinkedList<ResourceHandler<FluidResource>> handlers = new LinkedList<ResourceHandler<FluidResource>>();
        this.getConnectedHandlers(handlers, new BlockPosList(), this.worldPosition);
        LinkedList<ResourceHandler> fillHandlers = new LinkedList<ResourceHandler>();
        try (Transaction transaction = Transaction.open(null);){
            for (ResourceHandler resourceHandler : handlers) {
                int amount = resourceHandler.insert((Resource)toExtract, drainSimulated, (TransactionContext)transaction);
                if (amount <= 0) continue;
                fillHandlers.add(resourceHandler);
            }
        }
        if (fillHandlers.isEmpty()) {
            return;
        }
        FluidResource extractFluid = toExtract;
        for (ResourceHandler resourceHandler : fillHandlers) {
            ResourceHandlerUtil.move(this.extractHandler, (ResourceHandler)resourceHandler, resource -> resource.is((Object)extractFluid.getFluid()), (int)this.drainSpeed, null);
        }
    }

    public void updateExtractHandler() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (!state.getBlock().equals(ModBlocks.FLUID_EXTRACTOR.get())) {
            this.extractHandler = null;
            return;
        }
        Direction side = (Direction)state.getValue(BlockFluidExtractor.FACING);
        this.extractHandler = (ResourceHandler)this.level.getCapability(Capabilities.Fluid.BLOCK, this.worldPosition.relative(side), (Object)side.getOpposite());
    }

    public void getConnectedHandlers(List<ResourceHandler<FluidResource>> handlers, BlockPosList positions, BlockPos pos) {
        for (Direction side : Direction.values()) {
            BlockPos p = pos.relative(side);
            if (positions.contains(p)) continue;
            BlockState state = this.level.getBlockState(p);
            if (state.getBlock().equals(ModBlocks.FLUID_PIPE.get()) || state.getBlock().equals(ModBlocks.FLUID_EXTRACTOR.get())) {
                positions.add(p);
                this.getConnectedHandlers(handlers, positions, p);
                continue;
            }
            ResourceHandler handler = (ResourceHandler)this.level.getCapability(Capabilities.Fluid.BLOCK, pos.relative(side), (Object)side.getOpposite());
            if (handler == null || handler.equals(this.extractHandler)) continue;
            handlers.add((ResourceHandler<FluidResource>)handler);
        }
    }

    @Override
    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        if (!this.filter.isEmpty()) {
            valueOutput.store("filter", ItemStack.CODEC, (Object)this.filter);
        }
    }

    @Override
    public void loadAdditional(ValueInput valueInput) {
        this.filter = valueInput.read("filter", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        super.loadAdditional(valueInput);
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.fluid_extractor");
    }

    public ItemStack getFilter() {
        return this.filter.copy();
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter.copy();
        this.setChanged();
        this.synchronize();
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }
}

