/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.BlockGasStation;
import de.maxhenkel.car.blocks.BlockGasStationTop;
import de.maxhenkel.car.blocks.BlockOrientableHorizontal;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.CachedValue;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.net.MessageStartFuel;
import de.maxhenkel.car.sounds.ModClientSounds;
import de.maxhenkel.car.sounds.SoundLoopTileentity;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class TileEntityGasStation
extends TileEntityBase
implements ITickableBlockEntity,
ResourceHandler<FluidResource>,
SoundLoopTileentity.ISoundLoopable {
    private FluidStack storage;
    public int maxStorageAmount = 16000;
    private final int transferRate;
    private int fuelCounter;
    private boolean isFueling;
    private boolean wasFueling;
    private SimpleContainer inventory;
    private SimpleContainer trading;
    private int tradeAmount;
    private int freeAmountLeft;
    private UUID owner;
    @Nullable
    private ResourceHandler<FluidResource> fluidHandlerInFront;
    private final SnapshotJournal<FluidStack> fluidJournal = new SnapshotJournal<FluidStack>(){

        protected FluidStack createSnapshot() {
            return TileEntityGasStation.this.storage.copy();
        }

        protected void revertToSnapshot(FluidStack snapshot) {
            TileEntityGasStation.this.storage = snapshot.copy();
            TileEntityGasStation.this.setChanged();
        }
    };
    public final ContainerData FIELDS = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return TileEntityGasStation.this.fuelCounter;
                }
                case 1: {
                    if (!TileEntityGasStation.this.storage.isEmpty()) {
                        return TileEntityGasStation.this.storage.getAmount();
                    }
                    return 0;
                }
                case 2: {
                    return TileEntityGasStation.this.tradeAmount;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityGasStation.this.fuelCounter = value;
                    break;
                }
                case 1: {
                    if (TileEntityGasStation.this.storage.isEmpty()) break;
                    TileEntityGasStation.this.storage.setAmount(value);
                    break;
                }
                case 2: {
                    TileEntityGasStation.this.tradeAmount = value;
                    TileEntityGasStation.this.setChanged();
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };
    private CachedValue<Vec3> center = new CachedValue<Vec3>(() -> new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 0.5));
    private CachedValue<AABB> detectionBox = new CachedValue<AABB>(this::createDetectionBox);

    public TileEntityGasStation(BlockPos pos, BlockState state) {
        super((BlockEntityType)CarMod.GAS_STATION_TILE_ENTITY_TYPE.get(), pos, state);
        this.transferRate = (Integer)CarMod.SERVER_CONFIG.gasStationTransferRate.get();
        this.fuelCounter = 0;
        this.inventory = new SimpleContainer(27);
        this.trading = new SimpleContainer(2);
        this.owner = new UUID(0L, 0L);
        this.storage = FluidStack.EMPTY;
        this.tradeAmount = 1000;
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.fuel_station");
    }

    private void fixTop() {
        BlockState top = this.level.getBlockState(this.worldPosition.above());
        BlockState bottom = this.getBlockState();
        Direction facing = (Direction)bottom.getValue(BlockOrientableHorizontal.FACING);
        if (top.getBlock().equals(ModBlocks.GAS_STATION_TOP.get())) {
            if (!((Direction)top.getValue(BlockGasStationTop.FACING)).equals((Object)facing)) {
                this.level.setBlockAndUpdate(this.worldPosition.above(), (BlockState)((BlockGasStationTop)((Object)ModBlocks.GAS_STATION_TOP.get())).defaultBlockState().setValue(BlockGasStationTop.FACING, (Comparable)facing));
            }
        } else if (this.level.isEmptyBlock(this.worldPosition.above())) {
            this.level.setBlockAndUpdate(this.worldPosition.above(), (BlockState)((BlockGasStationTop)((Object)ModBlocks.GAS_STATION_TOP.get())).defaultBlockState().setValue(BlockGasStationTop.FACING, (Comparable)facing));
        }
    }

    @Override
    public void tick() {
        int result;
        int moved;
        if (this.level.getGameTime() % 100L == 0L) {
            this.fixTop();
        }
        this.fluidHandlerInFront = this.searchFluidHandlerInFront();
        if (this.fluidHandlerInFront == null) {
            if (this.fuelCounter > 0 || this.isFueling) {
                this.fuelCounter = 0;
                this.isFueling = false;
                this.synchronize();
                this.setChanged();
            }
            return;
        }
        if (!this.isFueling) {
            return;
        }
        if (this.storage.isEmpty()) {
            return;
        }
        try (Transaction transaction = Transaction.open(null);){
            moved = ResourceHandlerUtil.move((ResourceHandler)this, this.fluidHandlerInFront, resource -> true, (int)this.transferRate, (TransactionContext)transaction);
        }
        int amountCarCanTake = 0;
        if (moved > 0) {
            amountCarCanTake = moved;
        }
        if (amountCarCanTake <= 0) {
            return;
        }
        if (this.freeAmountLeft <= 0) {
            if (this.tradeAmount <= 0) {
                this.freeAmountLeft = this.transferRate;
                this.setChanged();
            } else if (this.removeTradeItem()) {
                this.freeAmountLeft = this.tradeAmount;
                this.setChanged();
            } else {
                this.isFueling = false;
                this.synchronize();
                return;
            }
        }
        try (Transaction transaction = Transaction.open(null);){
            result = ResourceHandlerUtil.move((ResourceHandler)this, this.fluidHandlerInFront, resource -> true, (int)Math.min(this.transferRate, this.freeAmountLeft), (TransactionContext)transaction);
            transaction.commit();
        }
        if (result > 0) {
            this.fuelCounter += result;
            this.freeAmountLeft -= result;
            this.synchronize(100);
            this.setChanged();
            if (!this.wasFueling) {
                this.synchronize();
            }
            this.wasFueling = true;
        } else {
            if (this.wasFueling) {
                this.synchronize();
            }
            this.wasFueling = false;
        }
    }

    public boolean removeTradeItem() {
        ItemStack tradeTemplate = this.trading.getItem(0);
        ItemStack tradingStack = this.trading.getItem(1);
        if (tradeTemplate.isEmpty()) {
            return true;
        }
        if (tradingStack.isEmpty()) {
            return false;
        }
        if (!tradeTemplate.getItem().equals(tradingStack.getItem())) {
            return false;
        }
        if (tradeTemplate.getDamageValue() != tradingStack.getDamageValue()) {
            return false;
        }
        if (tradingStack.getCount() < tradeTemplate.getCount()) {
            return false;
        }
        ItemStack addStack = tradingStack.copy();
        addStack.setCount(tradeTemplate.getCount());
        ItemStack add = this.inventory.addItem(addStack);
        if (add.getCount() > 0) {
            return false;
        }
        tradingStack.setCount(tradingStack.getCount() - tradeTemplate.getCount());
        this.trading.setItem(1, tradingStack);
        return true;
    }

    public Container getInventory() {
        return this.inventory;
    }

    public Container getTradingInventory() {
        return this.trading;
    }

    public boolean isValidFluid(Fluid f) {
        return CarMod.SERVER_CONFIG.gasStationValidFuelList.stream().anyMatch(fluidTag -> fluidTag.contains(f));
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.setChanged();
    }

    public void setOwner(Player player) {
        this.owner = new UUID(player.getUUID().getMostSignificantBits(), player.getUUID().getLeastSignificantBits());
        this.setChanged();
    }

    public boolean isOwner(Player player) {
        ServerPlayer p;
        boolean isOp;
        if (player instanceof ServerPlayer && (isOp = (p = (ServerPlayer)player).hasPermissions(p.level().getServer().operatorUserPermissionLevel()))) {
            return true;
        }
        return player.getUUID().equals(this.owner);
    }

    public boolean hasTrade() {
        return !this.trading.getItem(0).isEmpty();
    }

    @Override
    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putInt("counter", this.fuelCounter);
        if (!this.storage.isEmpty()) {
            valueOutput.store("fluid", FluidStack.CODEC, (Object)this.storage);
        }
        ItemUtils.saveInventory(valueOutput, "inventory", (Container)this.inventory);
        ItemUtils.saveInventory(valueOutput, "trading", (Container)this.inventory);
        valueOutput.putInt("trade_amount", this.tradeAmount);
        valueOutput.putInt("free_amount", this.freeAmountLeft);
        valueOutput.store("owner", UUIDUtil.CODEC, (Object)this.owner);
    }

    @Override
    public void loadAdditional(ValueInput valueInput) {
        this.fuelCounter = valueInput.getIntOr("counter", 0);
        this.storage = valueInput.read("fluid", FluidStack.CODEC).orElse(FluidStack.EMPTY);
        ItemUtils.readInventory(valueInput, "inventory", (Container)this.inventory);
        ItemUtils.readInventory(valueInput, "trading", (Container)this.trading);
        this.tradeAmount = valueInput.getIntOr("trade_amount", 1000);
        this.freeAmountLeft = valueInput.getIntOr("free_amount", 0);
        this.owner = valueInput.read("owner", UUIDUtil.CODEC).orElse(Util.NIL_UUID);
        super.loadAdditional(valueInput);
    }

    public boolean isFueling() {
        return this.isFueling;
    }

    public int getFuelCounter() {
        return this.fuelCounter;
    }

    public void setStorage(FluidStack storage) {
        this.storage = storage;
        this.setChanged();
        this.synchronize();
    }

    public FluidStack getStorage() {
        return this.storage;
    }

    public void setFuelCounter(int fuelCounter) {
        this.fuelCounter = fuelCounter;
        this.setChanged();
        this.synchronize();
    }

    public void setFueling(boolean isFueling) {
        if (this.fluidHandlerInFront == null) {
            return;
        }
        if (isFueling && !this.isFueling && this.level.isClientSide()) {
            ModClientSounds.playGasStationSound(this);
        }
        this.isFueling = isFueling;
        this.synchronize();
    }

    public Component getRenderText() {
        if (this.fluidHandlerInFront == null) {
            return Component.translatable((String)"gas_station.no_vehicle");
        }
        if (this.fuelCounter <= 0) {
            return Component.translatable((String)"gas_station.ready");
        }
        return Component.translatable((String)"gas_station.fuel_amount", (Object[])new Object[]{this.fuelCounter});
    }

    @Nullable
    private ResourceHandler<FluidResource> searchFluidHandlerInFront() {
        if (this.level == null) {
            return null;
        }
        return this.level.getEntitiesOfClass(Entity.class, this.getDetectionBox()).stream().sorted(Comparator.comparingDouble(o -> o.distanceToSqr(this.center.get()))).map(entity -> (ResourceHandler)entity.getCapability(Capabilities.Fluid.ENTITY, null)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    public ResourceHandler<FluidResource> getFluidHandlerInFront() {
        return this.fluidHandlerInFront;
    }

    private AABB createDetectionBox() {
        BlockState ownState = this.level.getBlockState(this.worldPosition);
        if (!ownState.getBlock().equals(ModBlocks.GAS_STATION.get())) {
            return null;
        }
        Direction facing = (Direction)ownState.getValue((Property)BlockGasStation.FACING);
        BlockPos start = this.worldPosition.relative(facing);
        return new AABB((double)start.getX(), (double)start.getY(), (double)start.getZ(), (double)start.getX() + 1.0, (double)start.getY() + 2.5, (double)start.getZ() + 1.0).expandTowards((double)facing.getStepX(), 0.0, (double)facing.getStepZ()).inflate(facing.getStepX() == 0 ? 0.5 : 0.0, 0.0, facing.getStepZ() == 0 ? 0.5 : 0.0);
    }

    public AABB getDetectionBox() {
        return this.detectionBox.get();
    }

    public boolean canEntityBeFueled() {
        if (this.fluidHandlerInFront == null) {
            return false;
        }
        try (Transaction transaction = Transaction.open(null);){
            int moved = ResourceHandlerUtil.move((ResourceHandler)this, this.fluidHandlerInFront, resource -> true, (int)this.transferRate, (TransactionContext)transaction);
            boolean bl = moved > 0;
            return bl;
        }
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)BlockGasStation.FACING);
    }

    public void sendStartFuelPacket(boolean start) {
        if (this.level.isClientSide()) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageStartFuel(this.worldPosition, start), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public boolean shouldSoundBePlayed() {
        if (!this.isFueling) {
            return false;
        }
        return this.canEntityBeFueled();
    }

    @Override
    public void play() {
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), (double)(this.worldPosition.getY() + 2), (double)(this.worldPosition.getZ() + 1));
    }

    public int getTradeAmount() {
        return this.tradeAmount;
    }

    public void setTradeAmount(int tradeAmount) {
        this.tradeAmount = tradeAmount;
        this.synchronize();
    }

    public int getFuelAmount() {
        if (!this.storage.isEmpty()) {
            return this.storage.getAmount();
        }
        return 0;
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int size() {
        return 1;
    }

    public FluidResource getResource(int index) {
        return FluidResource.of((FluidStack)this.storage);
    }

    public long getAmountAsLong(int index) {
        return this.storage.getAmount();
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return this.maxStorageAmount;
    }

    public boolean isValid(int index, FluidResource resource) {
        return this.isValidFluid(resource.getFluid());
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (!this.isValidFluid(resource.getFluid())) {
            return 0;
        }
        if (this.storage.isEmpty()) {
            int result = Math.min(amount, this.maxStorageAmount);
            this.fluidJournal.updateSnapshots(transaction);
            this.storage = new FluidStack(resource.getFluid(), result);
            this.synchronize();
            this.setChanged();
            return result;
        }
        if (resource.is((Object)this.storage.getFluid())) {
            int result = Math.min(amount, this.maxStorageAmount - this.storage.getAmount());
            this.fluidJournal.updateSnapshots(transaction);
            this.storage.setAmount(this.storage.getAmount() + result);
            this.synchronize();
            this.setChanged();
            return result;
        }
        return 0;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (this.storage.isEmpty()) {
            return 0;
        }
        if (this.storage.getFluid().equals(resource.getFluid())) {
            int result = Math.min(amount, this.storage.getAmount());
            this.fluidJournal.updateSnapshots(transaction);
            this.storage.setAmount(this.storage.getAmount() - result);
            if (this.storage.getAmount() <= 0) {
                this.storage = FluidStack.EMPTY;
                this.synchronize();
            }
            this.setChanged();
            return result;
        }
        return 0;
    }

    @Override
    public ResourceHandler<FluidResource> getFluidHandler() {
        return this;
    }
}

