/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.BlockGenerator;
import de.maxhenkel.car.blocks.BlockGui;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.tools.IntegerJournal;
import java.util.AbstractMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.energy.EnergyHandlerUtil;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class TileEntityGenerator
extends TileEntityBase
implements ITickableBlockEntity,
ResourceHandler<FluidResource>,
EnergyHandler,
Container {
    public final int maxStorage;
    public int storedEnergy;
    public final int maxMillibuckets;
    protected int currentMillibuckets;
    protected final int energyGeneration;
    protected Fluid currentFluid;
    protected SimpleContainer inventory;
    private final IntegerJournal energyJournal = new IntegerJournal(i -> {
        this.storedEnergy = i;
        this.setChanged();
    }, () -> this.storedEnergy);
    private final SnapshotJournal<Map.Entry<Fluid, Integer>> fluidJournal = new SnapshotJournal<Map.Entry<Fluid, Integer>>(){

        protected Map.Entry<Fluid, Integer> createSnapshot() {
            return new AbstractMap.SimpleEntry<Fluid, Integer>(TileEntityGenerator.this.currentFluid, TileEntityGenerator.this.currentMillibuckets);
        }

        protected void revertToSnapshot(Map.Entry<Fluid, Integer> snapshot) {
            TileEntityGenerator.this.currentFluid = snapshot.getKey();
            TileEntityGenerator.this.currentMillibuckets = snapshot.getValue();
            TileEntityGenerator.this.setChanged();
        }
    };
    public final ContainerData FIELDS = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return TileEntityGenerator.this.storedEnergy;
                }
                case 1: {
                    return TileEntityGenerator.this.currentMillibuckets;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityGenerator.this.storedEnergy = value;
                    break;
                }
                case 1: {
                    TileEntityGenerator.this.currentMillibuckets = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public TileEntityGenerator(BlockPos pos, BlockState state) {
        super((BlockEntityType)CarMod.GENERATOR_TILE_ENTITY_TYPE.get(), pos, state);
        this.inventory = new SimpleContainer(0);
        this.maxStorage = (Integer)CarMod.SERVER_CONFIG.generatorEnergyStorage.get();
        this.storedEnergy = 0;
        this.maxMillibuckets = (Integer)CarMod.SERVER_CONFIG.generatorFluidStorage.get();
        this.currentMillibuckets = 0;
        this.energyGeneration = (Integer)CarMod.SERVER_CONFIG.generatorEnergyGeneration.get();
    }

    @Override
    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        this.setBlockEnabled(this.isEnabled());
        if (this.currentFluid != null && this.currentMillibuckets > 0 && this.storedEnergy + this.energyGeneration <= this.maxStorage) {
            --this.currentMillibuckets;
            this.storedEnergy += this.energyGeneration;
            if (this.currentMillibuckets <= 0) {
                this.currentMillibuckets = 0;
                this.currentFluid = null;
            }
        }
        if (this.currentMillibuckets <= 0 && this.currentFluid != null) {
            this.currentMillibuckets = 0;
            this.currentFluid = null;
        }
        if (this.currentFluid == null && this.currentMillibuckets > 0) {
            this.currentMillibuckets = 0;
        }
        this.handlePushEnergy();
        this.setChanged();
    }

    public boolean isValidFuel(Fluid f) {
        return CarMod.SERVER_CONFIG.generatorValidFuelList.stream().anyMatch(fluidTag -> fluidTag.contains(f));
    }

    private void handlePushEnergy() {
        if (this.storedEnergy <= 0) {
            return;
        }
        for (Direction side : Direction.values()) {
            EnergyHandler energyHandler = (EnergyHandler)this.level.getCapability(Capabilities.Energy.BLOCK, this.worldPosition.relative(side), (Object)side.getOpposite());
            if (energyHandler == null) continue;
            try (Transaction transaction = Transaction.open(null);){
                int moved = EnergyHandlerUtil.move((EnergyHandler)this, (EnergyHandler)energyHandler, (int)this.storedEnergy, (TransactionContext)transaction);
                this.storedEnergy -= moved;
                transaction.commit();
            }
        }
    }

    public boolean isEnabled() {
        return this.currentMillibuckets > 0 && this.storedEnergy + this.energyGeneration < this.maxStorage;
    }

    public void setBlockEnabled(boolean enabled) {
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (state.getBlock().equals(ModBlocks.GENERATOR.get()) && (Boolean)state.getValue((Property)BlockGui.POWERED) != enabled) {
            ((BlockGenerator)((Object)ModBlocks.GENERATOR.get())).setPowered(this.level, this.worldPosition, state, enabled);
        }
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.generator");
    }

    @Override
    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putInt("stored_energy", this.storedEnergy);
        if (this.currentFluid != null) {
            FluidStack stack = new FluidStack(this.currentFluid, this.currentMillibuckets);
            valueOutput.store("fluid", FluidStack.CODEC, (Object)stack);
        }
    }

    @Override
    public void loadAdditional(ValueInput valueInput) {
        this.storedEnergy = Math.max(valueInput.getIntOr("stored_energy", 0), 0);
        valueInput.read("fluid", FluidStack.CODEC).ifPresent(stack -> {
            this.currentFluid = stack.getFluid();
            this.currentMillibuckets = stack.getAmount();
        });
        super.loadAdditional(valueInput);
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    public ItemStack getItem(int index) {
        return this.inventory.getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.inventory.removeItem(index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.inventory.removeItemNoUpdate(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.setItem(index, stack);
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public void startOpen(ContainerUser user) {
        this.inventory.startOpen(user);
    }

    public void stopOpen(ContainerUser user) {
        this.inventory.stopOpen(user);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.inventory.canPlaceItem(index, stack);
    }

    public void clearContent() {
        this.inventory.clearContent();
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getCurrentMillibuckets() {
        return this.currentMillibuckets;
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    @Override
    public ResourceHandler<FluidResource> getFluidHandler() {
        return this;
    }

    @Override
    public EnergyHandler getEnergyStorage() {
        return this;
    }

    public long getAmountAsLong() {
        return this.storedEnergy;
    }

    public long getCapacityAsLong() {
        return this.maxStorage;
    }

    public int insert(int amount, TransactionContext transaction) {
        return 0;
    }

    public int extract(int amount, TransactionContext transaction) {
        int i = Math.min(amount, this.storedEnergy);
        this.energyJournal.updateSnapshots(transaction);
        this.storedEnergy -= i;
        this.setChanged();
        return i;
    }

    public int size() {
        return 1;
    }

    public FluidResource getResource(int index) {
        if (this.currentFluid == null) {
            return FluidResource.EMPTY;
        }
        return FluidResource.of((Fluid)this.currentFluid);
    }

    public long getAmountAsLong(int index) {
        return this.currentMillibuckets;
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return this.maxMillibuckets;
    }

    public boolean isValid(int index, FluidResource resource) {
        return this.isValidFuel(resource.getFluid());
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (this.currentFluid == null && this.isValidFuel(resource.getFluid()) || resource.is((Object)this.currentFluid)) {
            int result = Math.min(this.maxMillibuckets - this.currentMillibuckets, amount);
            this.fluidJournal.updateSnapshots(transaction);
            this.currentMillibuckets += result;
            if (this.currentFluid == null) {
                this.currentFluid = resource.getFluid();
            }
            this.setChanged();
            return result;
        }
        return 0;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        return 0;
    }
}

