/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.fluids.ModFluids;
import de.maxhenkel.tools.IntegerJournal;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class TileEntitySplitTank
extends TileEntityBase
implements ITickableBlockEntity,
ResourceHandler<FluidResource>,
Container {
    private int currentMix = 0;
    public int maxMix;
    public int mixUsage;
    private int currentBioDiesel;
    public int maxBioDiesel;
    public int bioDieselGeneration;
    private int currentGlycerin;
    public int maxGlycerin;
    public int glycerinGeneration;
    public int generatingTime;
    private int timeToGenerate;
    protected SimpleContainer inventory;
    private final SnapshotJournal<Integer> mixJournal = new IntegerJournal(i -> {
        this.currentMix = i;
        this.setChanged();
    }, () -> this.currentMix);
    private final SnapshotJournal<Integer> bioDieselJournal = new IntegerJournal(i -> {
        this.currentBioDiesel = i;
        this.setChanged();
    }, () -> this.currentBioDiesel);
    private final SnapshotJournal<Integer> glycerinJournal = new IntegerJournal(i -> {
        this.currentGlycerin = i;
        this.setChanged();
    }, () -> this.currentGlycerin);
    public final ContainerData FIELDS = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return TileEntitySplitTank.this.currentMix;
                }
                case 1: {
                    return TileEntitySplitTank.this.currentBioDiesel;
                }
                case 2: {
                    return TileEntitySplitTank.this.currentGlycerin;
                }
                case 3: {
                    return TileEntitySplitTank.this.timeToGenerate;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntitySplitTank.this.currentMix = value;
                    break;
                }
                case 1: {
                    TileEntitySplitTank.this.currentBioDiesel = value;
                    break;
                }
                case 2: {
                    TileEntitySplitTank.this.currentGlycerin = value;
                    break;
                }
                case 3: {
                    TileEntitySplitTank.this.timeToGenerate = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public TileEntitySplitTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)CarMod.SPLIT_TANK_TILE_ENTITY_TYPE.get(), pos, state);
        this.inventory = new SimpleContainer(0);
        this.maxMix = (Integer)CarMod.SERVER_CONFIG.splitTankFluidStorage.get();
        this.currentBioDiesel = 0;
        this.maxBioDiesel = (Integer)CarMod.SERVER_CONFIG.splitTankFluidStorage.get();
        this.currentGlycerin = 0;
        this.maxGlycerin = (Integer)CarMod.SERVER_CONFIG.splitTankFluidStorage.get();
        this.generatingTime = (Integer)CarMod.SERVER_CONFIG.splitTankGeneratingTime.get();
        this.timeToGenerate = 0;
        this.mixUsage = (Integer)CarMod.SERVER_CONFIG.splitTankMixUsage.get();
        this.glycerinGeneration = (Integer)CarMod.SERVER_CONFIG.splitTankGlycerinGeneration.get();
        this.bioDieselGeneration = (Integer)CarMod.SERVER_CONFIG.splitTankBioDieselGeneration.get();
    }

    @Override
    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        if (this.timeToGenerate > 0) {
            --this.timeToGenerate;
            if (this.timeToGenerate == 0 && this.currentMix - this.mixUsage >= 0) {
                this.currentMix -= this.mixUsage;
                if (this.currentBioDiesel + this.bioDieselGeneration <= this.maxBioDiesel) {
                    this.currentBioDiesel += this.bioDieselGeneration;
                }
                if (this.currentGlycerin + this.glycerinGeneration <= this.maxGlycerin) {
                    this.currentGlycerin += this.glycerinGeneration;
                }
            }
        } else if (this.currentMix >= this.mixUsage && this.currentBioDiesel + this.bioDieselGeneration <= this.maxBioDiesel && this.currentGlycerin + this.glycerinGeneration <= this.maxGlycerin) {
            this.timeToGenerate = this.generatingTime;
        }
        if (this.level.getGameTime() % 200L == 0L) {
            this.synchronize();
        }
        this.setChanged();
    }

    public float getBioDieselPerc() {
        return (float)this.currentBioDiesel / (float)this.maxBioDiesel;
    }

    public float getGlycerinPerc() {
        return (float)this.currentGlycerin / (float)this.maxGlycerin;
    }

    @Override
    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putInt("mix", this.currentMix);
        valueOutput.putInt("bio_diesel", this.currentBioDiesel);
        valueOutput.putInt("glycerin", this.currentGlycerin);
        valueOutput.putInt("time", this.timeToGenerate);
    }

    @Override
    public void loadAdditional(ValueInput valueInput) {
        this.currentMix = valueInput.getIntOr("mix", 0);
        this.currentBioDiesel = valueInput.getIntOr("bio_diesel", 0);
        this.currentGlycerin = valueInput.getIntOr("glycerin", 0);
        this.timeToGenerate = valueInput.getIntOr("timeToGenerate", 0);
        super.loadAdditional(valueInput);
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    public ItemStack getItem(int index) {
        return this.inventory.getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.inventory.removeItem(index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.inventory.removeItemNoUpdate(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.setItem(index, stack);
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public void startOpen(ContainerUser user) {
        this.inventory.startOpen(user);
    }

    public void stopOpen(ContainerUser user) {
        this.inventory.stopOpen(user);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.inventory.canPlaceItem(index, stack);
    }

    public void clearContent() {
        this.inventory.clearContent();
    }

    public int getCurrentMix() {
        return this.currentMix;
    }

    public int getCurrentBioDiesel() {
        return this.currentBioDiesel;
    }

    public int getCurrentGlycerin() {
        return this.currentGlycerin;
    }

    public int getTimeToGenerate() {
        return this.timeToGenerate;
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.split_tank");
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int size() {
        return 3;
    }

    public FluidResource getResource(int index) {
        if (index == 0) {
            return FluidResource.of((Fluid)((Fluid)ModFluids.CANOLA_METHANOL_MIX.get()));
        }
        if (index == 1) {
            return FluidResource.of((Fluid)((Fluid)ModFluids.BIO_DIESEL.get()));
        }
        return FluidResource.of((Fluid)((Fluid)ModFluids.GLYCERIN.get()));
    }

    public long getAmountAsLong(int index) {
        if (index == 0) {
            return this.currentMix;
        }
        if (index == 1) {
            return this.currentBioDiesel;
        }
        return this.currentGlycerin;
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        if (index == 0) {
            return this.maxMix;
        }
        if (index == 1) {
            return this.maxBioDiesel;
        }
        return this.maxGlycerin;
    }

    public boolean isValid(int index, FluidResource resource) {
        if (index == 0) {
            return resource.is((Object)((Fluid)ModFluids.CANOLA_METHANOL_MIX.get()));
        }
        if (index == 1) {
            return resource.is((Object)((Fluid)ModFluids.BIO_DIESEL.get()));
        }
        return resource.is((Object)((Fluid)ModFluids.GLYCERIN.get()));
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (resource.getFluid().equals(ModFluids.CANOLA_METHANOL_MIX.get())) {
            int result = Math.min(this.maxMix - this.currentMix, amount);
            this.mixJournal.updateSnapshots(transaction);
            this.currentMix += result;
            this.setChanged();
            return result;
        }
        return 0;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (resource.getFluid().equals(ModFluids.GLYCERIN.get())) {
            int result = Math.min(amount, this.currentGlycerin);
            this.glycerinJournal.updateSnapshots(transaction);
            this.currentGlycerin -= result;
            this.setChanged();
            return result;
        }
        if (resource.getFluid().equals(ModFluids.BIO_DIESEL.get())) {
            int result = Math.min(amount, this.currentBioDiesel);
            this.bioDieselJournal.updateSnapshots(transaction);
            this.currentBioDiesel -= result;
            this.setChanged();
            return result;
        }
        return 0;
    }

    @Override
    public ResourceHandler<FluidResource> getFluidHandler() {
        return this;
    }
}

