/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class TileEntityTank
extends TileEntityBase
implements ResourceHandler<FluidResource>,
ITickableBlockEntity {
    private FluidStack fluid;
    public static final int CAPACITY = 16000;
    private final SnapshotJournal<FluidStack> fluidJournal = new SnapshotJournal<FluidStack>(){

        protected FluidStack createSnapshot() {
            return TileEntityTank.this.fluid.copy();
        }

        protected void revertToSnapshot(FluidStack snapshot) {
            TileEntityTank.this.fluid = snapshot.copy();
            TileEntityTank.this.setChanged();
        }
    };
    private boolean[] sides = new boolean[Direction.values().length];
    private boolean[] sidesFluid = new boolean[Direction.values().length];

    public TileEntityTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)CarMod.TANK_TILE_ENTITY_TYPE.get(), pos, state);
        this.fluid = FluidStack.EMPTY;
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide()) {
            if (this.level.getGameTime() % 20L == 0L) {
                this.synchronize();
            }
        } else {
            this.updateClientSide();
        }
        if (this.fluid.isEmpty()) {
            return;
        }
        this.checkDown();
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (this.fluid.isEmpty()) {
                return;
            }
            this.checkSide(facing);
        }
    }

    public void checkSide(Direction side) {
        BlockEntity te = this.level.getBlockEntity(this.worldPosition.relative(side));
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank otherTank = (TileEntityTank)te;
        FluidStack other = otherTank.getFluid();
        if (!other.getFluid().equals(this.fluid.getFluid()) && !other.isEmpty()) {
            return;
        }
        int dif = other.getAmount() - this.fluid.getAmount();
        if (dif >= -2) {
            return;
        }
        ResourceHandlerUtil.move((ResourceHandler)this, (ResourceHandler)otherTank, resource -> true, (int)(-dif / 2), null);
    }

    public void checkDown() {
        BlockEntity te = this.level.getBlockEntity(this.worldPosition.below());
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank otherTank = (TileEntityTank)te;
        int moved = ResourceHandlerUtil.move((ResourceHandler)this, (ResourceHandler)otherTank, resource -> true, (int)Integer.MAX_VALUE, null);
        if (moved <= 0) {
            return;
        }
        if (!this.fluid.isEmpty() && this.fluid.getAmount() <= 0) {
            this.fluid = FluidStack.EMPTY;
        }
    }

    public float getFillPercent() {
        if (this.fluid.isEmpty()) {
            return 0.0f;
        }
        return (float)this.fluid.getAmount() / 16000.0f;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        if (!this.fluid.isEmpty() && this.fluid.getAmount() > 0) {
            valueOutput.store("fluid", FluidStack.CODEC, (Object)this.fluid);
        }
    }

    @Override
    public void loadAdditional(ValueInput valueInput) {
        this.fluid = valueInput.read("fluid", FluidStack.CODEC).orElse(FluidStack.EMPTY);
        super.loadAdditional(valueInput);
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.tank");
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }

    private void recalculateSides() {
        for (Direction facing : Direction.values()) {
            this.sides[facing.get3DDataValue()] = this.isTankConnectedCalc(facing);
            this.sidesFluid[facing.get3DDataValue()] = this.isFluidConnectedCalc(facing);
        }
    }

    private boolean isFluidConnectedCalc(Direction facing) {
        BlockState s;
        BlockEntity te = this.level.getBlockEntity(this.worldPosition.relative(facing));
        if (te instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)te;
            if (tank.fluid.isEmpty() || this.fluid.isEmpty()) {
                return false;
            }
            if (tank.fluid.getFluid().equals(this.fluid.getFluid())) {
                if (facing.equals((Object)Direction.UP)) {
                    return this.fluid.getAmount() >= 16000;
                }
                return true;
            }
        }
        if ((s = this.level.getBlockState(this.worldPosition.relative(facing))).isRedstoneConductor((BlockGetter)this.level, this.worldPosition.relative(facing))) {
            if (facing.equals((Object)Direction.UP)) {
                return this.fluid.getAmount() >= 16000;
            }
            return true;
        }
        return false;
    }

    private boolean isTankConnectedCalc(Direction facing) {
        BlockEntity te = this.level.getBlockEntity(this.worldPosition.relative(facing));
        if (te instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)te;
            if (tank.fluid.isEmpty() && this.fluid.isEmpty()) {
                return true;
            }
            if (tank.fluid.isEmpty() || this.fluid.isEmpty()) {
                return true;
            }
            return tank.fluid.getFluid().equals(this.fluid.getFluid());
        }
        return false;
    }

    private void updateClientSide() {
        this.recalculateSides();
    }

    public boolean isTankConnectedTo(Direction facing) {
        return this.sides[facing.get3DDataValue()];
    }

    public boolean isFluidConnected(Direction facing) {
        return this.sidesFluid[facing.get3DDataValue()];
    }

    @Override
    public ResourceHandler<FluidResource> getFluidHandler() {
        return this;
    }

    public int size() {
        return 1;
    }

    public FluidResource getResource(int index) {
        return FluidResource.of((FluidStack)this.fluid);
    }

    public long getAmountAsLong(int index) {
        return this.fluid.getAmount();
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return 16000L;
    }

    public boolean isValid(int index, FluidResource resource) {
        return true;
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (this.fluid.isEmpty()) {
            int result = Math.min(amount, 16000);
            this.fluidJournal.updateSnapshots(transaction);
            this.fluid = new FluidStack(resource.getFluid(), result);
            this.setChanged();
            return result;
        }
        if (resource.is((Object)this.fluid.getFluid())) {
            int result = Math.min(amount, 16000 - this.fluid.getAmount());
            this.fluidJournal.updateSnapshots(transaction);
            this.fluid.setAmount(this.fluid.getAmount() + result);
            this.setChanged();
            return result;
        }
        return 0;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (this.fluid.isEmpty()) {
            return 0;
        }
        if (resource.is((Object)this.fluid.getFluid())) {
            int result = Math.min(amount, this.fluid.getAmount());
            this.fluidJournal.updateSnapshots(transaction);
            this.fluid.setAmount(this.fluid.getAmount() - result);
            if (this.fluid.getAmount() <= 0) {
                this.fluid = FluidStack.EMPTY;
            }
            this.setChanged();
            return result;
        }
        return 0;
    }
}

