/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.car.blocks.BlockSign;
import de.maxhenkel.car.blocks.tileentity.TileEntitySign;
import de.maxhenkel.car.blocks.tileentity.render.SignRenderState;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class TileEntitySpecialRendererSign
implements BlockEntityRenderer<TileEntitySign, SignRenderState> {
    protected BlockEntityRendererProvider.Context renderer;

    public TileEntitySpecialRendererSign(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
    }

    public SignRenderState createRenderState() {
        return new SignRenderState();
    }

    public void extractRenderState(TileEntitySign sign, SignRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)sign, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        state.direction = (Direction)sign.getBlockState().getValue(BlockSign.FACING);
        for (int i = 0; i < state.text.length; ++i) {
            state.text[i] = Component.literal((String)sign.getText(i)).getVisualOrderText();
        }
    }

    public void submit(SignRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        stack.pushPose();
        stack.translate(0.5, 1.0, 0.5);
        stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
        stack.pushPose();
        stack.translate(0.0, 0.27, -0.031875);
        this.drawText(state.text[0], state, stack, collector);
        stack.translate(0.0, 0.116, 0.0);
        this.drawText(state.text[1], state, stack, collector);
        stack.translate(0.0, 0.116, 0.0);
        this.drawText(state.text[2], state, stack, collector);
        stack.translate(0.0, 0.116, 0.0);
        this.drawText(state.text[3], state, stack, collector);
        stack.popPose();
        stack.pushPose();
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        stack.translate(0.0, 0.27, -0.031875);
        this.drawText(state.text[4], state, stack, collector);
        stack.translate(0.0, 0.116, 0.0);
        this.drawText(state.text[5], state, stack, collector);
        stack.translate(0.0, 0.116, 0.0);
        this.drawText(state.text[6], state, stack, collector);
        stack.translate(0.0, 0.116, 0.0);
        this.drawText(state.text[7], state, stack, collector);
        stack.popPose();
        stack.popPose();
    }

    private void drawText(FormattedCharSequence text, SignRenderState state, PoseStack stack, SubmitNodeCollector collector) {
        Font font = this.renderer.font();
        stack.pushPose();
        int textWidth = font.width(text);
        float textScale = 0.008f;
        stack.translate((double)(-(textScale * (float)textWidth)) / 2.0, 0.0, 0.0);
        stack.scale(textScale, textScale, textScale);
        collector.submitText(stack, 0.0f, 0.0f, text, false, Font.DisplayMode.NORMAL, state.lightCoords, -16777216, 0, 0);
        stack.popPose();
    }
}

