/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.blocks.tileentity.render.SplitTankRenderState;
import de.maxhenkel.car.corelib.client.RenderUtils;
import de.maxhenkel.car.fluids.ModFluids;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class TileEntitySpecialRendererSplitTank
implements BlockEntityRenderer<TileEntitySplitTank, SplitTankRenderState> {
    private static final FluidStack BIO_DIESEL_STACK = new FluidStack((Fluid)ModFluids.BIO_DIESEL.get(), 1);
    private static final FluidStack GLYCERIN_STACK = new FluidStack((Fluid)ModFluids.GLYCERIN.get(), 1);
    protected BlockEntityRendererProvider.Context renderer;

    public TileEntitySpecialRendererSplitTank(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
    }

    public SplitTankRenderState createRenderState() {
        return new SplitTankRenderState();
    }

    public void extractRenderState(TileEntitySplitTank tank, SplitTankRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)tank, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        state.bioDiesel = tank.getBioDieselPerc() / 2.0f;
        state.glycerin = tank.getGlycerinPerc() / 2.0f;
    }

    public void submit(SplitTankRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        stack.pushPose();
        if (state.bioDiesel > 0.0f) {
            this.renderFluid(BIO_DIESEL_STACK, state.bioDiesel, 0.0625f, stack, state.lightCoords, OverlayTexture.NO_OVERLAY, collector);
        }
        if (state.glycerin > 0.0f) {
            this.renderFluid(GLYCERIN_STACK, state.glycerin, state.bioDiesel + 0.0625f, stack, state.lightCoords, OverlayTexture.NO_OVERLAY, collector);
        }
        stack.popPose();
    }

    public void renderFluid(FluidStack fluid, float amount, float yStart, PoseStack stack, int light, int overlay, SubmitNodeCollector collector) {
        stack.pushPose();
        stack.scale(0.98f, 0.98f, 0.98f);
        stack.translate(0.01f, 0.01f, 0.01f);
        IClientFluidTypeExtensions type = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite texture = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS).getSprite(type.getStillTexture(fluid));
        collector.submitCustomGeometry(stack, RenderType.itemEntityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), (pose, vertexConsumer) -> {
            float uMin = texture.getU0();
            float uMax = texture.getU1();
            float vMin = texture.getV0();
            float vMax = texture.getV1();
            float vHeight = vMax - vMin;
            float s = 0.0f;
            RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart, 0.0f + s, uMax, vMin, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart, 0.0f + s, uMin, vMin, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart, 1.0f - s, uMin, vMin, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart, 1.0f - s, uMax, vMin, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart, 0.0f + s, uMin, vMin, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart, 1.0f - s, uMax, vMin, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart, 1.0f - s, uMin, vMin, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart, 0.0f + s, uMax, vMin, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMax, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMax, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin, light, overlay);
            RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin, light, overlay);
        });
        stack.popPose();
    }
}

