/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.car.blocks.tileentity.render.TankRenderState;
import de.maxhenkel.car.corelib.client.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class TileEntitySpecialRendererTank
implements BlockEntityRenderer<TileEntityTank, TankRenderState> {
    public static final ResourceLocation LOCATION_TANK = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/block/tank_line.png");
    protected EntityModelSet entityModelSet;

    public TileEntitySpecialRendererTank(EntityModelSet entityModelSet) {
        this.entityModelSet = entityModelSet;
    }

    public TankRenderState createRenderState() {
        return new TankRenderState();
    }

    public void extractRenderState(TileEntityTank tank, TankRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)tank, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        state.amount = tank.getFillPercent();
        state.fluid = tank.getFluid();
        for (Direction direction : Direction.values()) {
            state.fluidConnections[direction.get3DDataValue()] = tank.isFluidConnected(direction);
            state.tankConnections[direction.get3DDataValue()] = tank.isTankConnectedTo(direction);
        }
        if (!state.fluid.isEmpty()) {
            ResourceLocation stillTexture;
            IClientFluidTypeExtensions type = IClientFluidTypeExtensions.of((Fluid)state.fluid.getFluid());
            if (tank.hasLevel()) {
                state.tint = type.getTintColor(state.fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)tank.getLevel(), tank.getBlockPos());
                stillTexture = type.getStillTexture(state.fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)tank.getLevel(), tank.getBlockPos());
            } else {
                state.tint = type.getTintColor(state.fluid);
                stillTexture = type.getStillTexture(state.fluid);
            }
            state.texture = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS).getSprite(stillTexture);
        } else {
            state.tint = 0;
            state.texture = null;
        }
    }

    public void submit(TankRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        stack.pushPose();
        if (state.amount > 0.0f && state.texture != null) {
            this.renderFluid(stack, state, collector);
        }
        TileEntitySpecialRendererTank.renderLines(stack, state, collector);
        stack.popPose();
    }

    public void renderFluid(PoseStack stack, TankRenderState state, SubmitNodeCollector collector) {
        boolean[] connections = state.fluidConnections;
        TextureAtlasSprite texture = state.texture;
        int tint = state.tint;
        float amount = state.amount;
        int light = state.lightCoords;
        float yStart = 0.0f;
        int overlay = OverlayTexture.NO_OVERLAY;
        collector.submitCustomGeometry(stack, RenderType.itemEntityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), (pose, vertexConsumer) -> {
            float uMin = texture.getU0();
            float uMax = texture.getU1();
            float vMin = texture.getV0();
            float vMax = texture.getV1();
            float vHeight = vMax - vMin;
            int red = tint >> 16 & 0xFF;
            int green = tint >> 8 & 0xFF;
            int blue = tint & 0xFF;
            float s = 0.0f;
            if (!connections[Direction.NORTH.get3DDataValue()]) {
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 0.0f - s, yStart, 0.0f + s, uMin, vMin, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
            }
            if (!connections[Direction.SOUTH.get3DDataValue()]) {
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart, 1.0f - s, uMax, vMin, red, green, blue, light, overlay);
            }
            if (!connections[Direction.EAST.get3DDataValue()]) {
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart, 0.0f + s, uMin, vMin, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart, 1.0f - s, uMax, vMin, red, green, blue, light, overlay);
            }
            if (!connections[Direction.WEST.get3DDataValue()]) {
                RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
            }
            if (!connections[Direction.DOWN.get3DDataValue()]) {
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart, 1.0f - s, uMin, vMax, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart, 0.0f + s, uMax, vMax, red, green, blue, light, overlay);
            }
            if (!connections[Direction.UP.get3DDataValue()]) {
                RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMax, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMax, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
                RenderUtils.vertex(vertexConsumer, pose, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
            }
        });
    }

    public static void renderLines(PoseStack stack, TankRenderState state, SubmitNodeCollector collector) {
        boolean[] connections = state.tankConnections;
        for (Direction facing : Direction.values()) {
            if (connections[facing.ordinal()]) continue;
            for (EnumDirection direction : EnumDirection.values()) {
                if (connections[direction.to(facing).ordinal()]) continue;
                TileEntitySpecialRendererTank.drawLine(facing, direction, stack, collector, state.lightCoords, OverlayTexture.NO_OVERLAY);
            }
        }
    }

    public static void drawLine(Direction side, EnumDirection line, PoseStack stack, SubmitNodeCollector collector, int light, int overlay) {
        stack.pushPose();
        TileEntitySpecialRendererTank.rotate(side, stack);
        stack.translate(-2.5E-4, -2.5E-4, -2.5E-4);
        TileEntitySpecialRendererTank.drawSide(line, stack, collector, light, overlay);
        stack.popPose();
    }

    public static void rotate(Direction facing, PoseStack matrixStack) {
        matrixStack.translate(0.5, 0.5, 0.5);
        switch (facing) {
            case SOUTH: {
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
                break;
            }
            case WEST: {
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case UP: {
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                matrixStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                matrixStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(270.0f));
                break;
            }
        }
        matrixStack.translate(-0.5, -0.5, -0.5);
    }

    public static void drawSide(EnumDirection line, PoseStack stack, SubmitNodeCollector collector, int light, int overlay) {
        collector.submitCustomGeometry(stack, RenderType.entityCutout((ResourceLocation)LOCATION_TANK), (pose, c) -> {
            switch (line.ordinal()) {
                case 0: {
                    RenderUtils.vertex(c, pose, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                    break;
                }
                case 1: {
                    RenderUtils.vertex(c, pose, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                    break;
                }
                case 3: {
                    RenderUtils.vertex(c, pose, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                    break;
                }
                case 2: {
                    RenderUtils.vertex(c, pose, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                    RenderUtils.vertex(c, pose, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                    break;
                }
            }
        });
    }

    public static enum EnumDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;


        public Direction to(Direction facing) {
            return switch (facing) {
                default -> throw new MatchException(null, null);
                case Direction.NORTH -> {
                    switch (this.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield Direction.UP;
                        }
                        case 1: {
                            yield Direction.DOWN;
                        }
                        case 2: {
                            yield Direction.EAST;
                        }
                        case 3: 
                    }
                    yield Direction.WEST;
                }
                case Direction.SOUTH -> {
                    switch (this.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield Direction.UP;
                        }
                        case 1: {
                            yield Direction.DOWN;
                        }
                        case 2: {
                            yield Direction.WEST;
                        }
                        case 3: 
                    }
                    yield Direction.EAST;
                }
                case Direction.EAST -> {
                    switch (this.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield Direction.UP;
                        }
                        case 1: {
                            yield Direction.DOWN;
                        }
                        case 2: {
                            yield Direction.SOUTH;
                        }
                        case 3: 
                    }
                    yield Direction.NORTH;
                }
                case Direction.WEST -> {
                    switch (this.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield Direction.UP;
                        }
                        case 1: {
                            yield Direction.DOWN;
                        }
                        case 2: {
                            yield Direction.NORTH;
                        }
                        case 3: 
                    }
                    yield Direction.SOUTH;
                }
                case Direction.UP -> {
                    switch (this.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield Direction.NORTH;
                        }
                        case 1: {
                            yield Direction.SOUTH;
                        }
                        case 2: {
                            yield Direction.WEST;
                        }
                        case 3: 
                    }
                    yield Direction.EAST;
                }
                case Direction.DOWN -> {
                    switch (this.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield Direction.SOUTH;
                        }
                        case 1: {
                            yield Direction.NORTH;
                        }
                        case 2: {
                            yield Direction.WEST;
                        }
                        case 3: 
                    }
                    yield Direction.EAST;
                }
            };
        }
    }
}

