/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.blocks.tileentity.render.GasStationRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.debug.DebugScreenEntries;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class TileentitySpecialRendererGasStation
implements BlockEntityRenderer<TileEntityGasStation, GasStationRenderState> {
    private Minecraft minecraft;
    protected BlockEntityRendererProvider.Context renderer;

    public TileentitySpecialRendererGasStation(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
        this.minecraft = Minecraft.getInstance();
    }

    public GasStationRenderState createRenderState() {
        return new GasStationRenderState();
    }

    public void extractRenderState(TileEntityGasStation gasStation, GasStationRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)gasStation, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        state.text = gasStation.hasLevel() ? gasStation.getRenderText().getVisualOrderText() : null;
        state.direction = gasStation.getDirection();
        state.hitbox = this.minecraft.debugEntries.isCurrentlyEnabled(DebugScreenEntries.ENTITY_HITBOXES) ? gasStation.getDetectionBox().move((double)(-gasStation.getBlockPos().getX()), (double)(-gasStation.getBlockPos().getY()), (double)(-gasStation.getBlockPos().getZ())) : null;
    }

    public void submit(GasStationRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        if (state.text == null) {
            return;
        }
        stack.pushPose();
        stack.translate(0.5, 1.0, 0.5);
        stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.direction.toYRot()));
        Font font = this.renderer.font();
        int textWidth = font.width(state.text);
        float textScale = 0.36f / (float)textWidth;
        textScale = Math.min(textScale, 0.01f);
        float posX = -(textScale * (float)textWidth) / 2.0f;
        stack.translate((double)posX, -0.815, -0.188);
        stack.scale(textScale, textScale, textScale);
        collector.submitText(stack, 0.0f, 0.0f, state.text, false, Font.DisplayMode.NORMAL, state.lightCoords, -16777216, 0, 0);
        stack.popPose();
        if (state.hitbox != null) {
            AABB hitbox = state.hitbox;
            collector.submitCustomGeometry(stack, RenderType.lines(), (pose, vertexConsumer) -> ShapeRenderer.renderLineBox((PoseStack.Pose)pose, (VertexConsumer)vertexConsumer, (AABB)hitbox, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f));
        }
    }

    public AABB getRenderBoundingBox(TileEntityGasStation blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }
}

