/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.integration.jei.CarRecipeBuilder;
import de.maxhenkel.car.items.ModItems;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CommandCarDemo {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cardemo").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).executes(context -> CommandCarDemo.spawnCars((Level)((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getVec3((CommandContext)context, (String)"pos")))));
    }

    public static int spawnCars(Level world, Vec3 pos) {
        double posX;
        double xStart;
        int j;
        double posX2;
        double xStart2;
        int i;
        ItemStack wheel = new ItemStack((ItemLike)ModItems.WHEEL.get());
        ItemStack engine = new ItemStack((ItemLike)ModItems.ENGINE_6_CYLINDER.get());
        ItemStack tank = new ItemStack((ItemLike)ModItems.LARGE_TANK.get());
        ItemStack largeWheel = new ItemStack((ItemLike)ModItems.BIG_WHEEL.get());
        double posZ = pos.z;
        List<ItemStack> transporters = CarRecipeBuilder.getTransporters();
        List<ItemStack> containers = CarRecipeBuilder.getAllContainers();
        List<ItemStack> tankContainers = CarRecipeBuilder.getAllTankContainers();
        List<ItemStack> sportBodies = CarRecipeBuilder.getSportBodies();
        List<ItemStack> suvBodies = CarRecipeBuilder.getSUVBodies();
        List<ItemStack> bigWoodBodies = CarRecipeBuilder.getAllBigWoodBodies();
        List<ItemStack> woodBodies = CarRecipeBuilder.getAllWoodBodies();
        for (i = 0; i < woodBodies.size(); ++i) {
            xStart2 = pos.x() - (double)woodBodies.size();
            posX2 = xStart2 + (double)i * 3.0;
            CommandCarDemo.createCar(world, posX2, pos.y, posZ, woodBodies.get(i), wheel, wheel, wheel, wheel, engine, tank);
        }
        posZ += 3.0;
        for (i = 0; i < bigWoodBodies.size(); ++i) {
            xStart2 = pos.x() - (double)bigWoodBodies.size();
            posX2 = xStart2 + (double)i * 3.0;
            CommandCarDemo.createCar(world, posX2, pos.y, posZ, bigWoodBodies.get(i), wheel, wheel, wheel, wheel, engine, tank);
        }
        posZ += 3.0;
        for (i = 0; i < sportBodies.size(); ++i) {
            xStart2 = pos.x() - (double)sportBodies.size();
            posX2 = xStart2 + (double)i * 3.0;
            CommandCarDemo.createCar(world, posX2, pos.y, posZ, sportBodies.get(i), largeWheel, largeWheel, largeWheel, largeWheel, engine, tank);
        }
        posZ += 3.0;
        for (i = 0; i < suvBodies.size(); ++i) {
            xStart2 = pos.x() - (double)suvBodies.size();
            posX2 = xStart2 + (double)i * 3.0;
            CommandCarDemo.createCar(world, posX2, pos.y, posZ, suvBodies.get(i), largeWheel, largeWheel, largeWheel, largeWheel, engine, tank);
        }
        posZ += 3.0;
        for (i = 0; i < transporters.size(); ++i) {
            xStart2 = pos.x() - (double)transporters.size();
            posX2 = xStart2 + (double)i * 3.0;
            CommandCarDemo.createCar(world, posX2, pos.y, posZ, transporters.get(i), wheel, wheel, wheel, wheel, wheel, wheel, engine, tank);
        }
        posZ += 3.0;
        for (ItemStack tankContainer : tankContainers) {
            for (j = 0; j < transporters.size(); ++j) {
                xStart = pos.x() - (double)transporters.size();
                posX = xStart + (double)j * 3.0;
                CommandCarDemo.createCar(world, posX, pos.y, posZ, transporters.get(j), wheel, wheel, wheel, wheel, wheel, wheel, engine, tank, tankContainer);
            }
            posZ += 3.0;
        }
        for (ItemStack container : containers) {
            for (j = 0; j < transporters.size(); ++j) {
                xStart = pos.x() - (double)transporters.size();
                posX = xStart + (double)j * 3.0;
                CommandCarDemo.createCar(world, posX, pos.y, posZ, transporters.get(j), wheel, wheel, wheel, wheel, wheel, wheel, engine, tank, container);
            }
            posZ += 3.0;
        }
        return 1;
    }

    private static void createCar(Level world, double posX, double posY, double posZ, ItemStack ... items) {
        EntityGenericCar car = new EntityGenericCar(world);
        car.absSnapTo(posX, posY, posZ, 180.0f, 0.0f);
        for (int i = 0; i < items.length; ++i) {
            car.getPartInventory().setItem(i, items[i]);
        }
        car.setPartSerializer();
        car.tryInitPartsAndModel();
        world.addFreshEntity((Entity)car);
    }
}

