/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.corelib.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import de.maxhenkel.car.corelib.Logger;
import de.maxhenkel.car.corelib.codec.CodecUtils;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ValueInputOutputUtils {
    public static Optional<CompoundTag> getTag(ValueInput valueInput, String key) {
        return valueInput.read(key, CompoundTag.CODEC);
    }

    public static Optional<ListTag> getListTag(ValueInput valueInput, String key) {
        return valueInput.read(key, CodecUtils.LIST_TAG_CODEC);
    }

    public static void setTag(ValueOutput valueOutput, String key, CompoundTag tag) {
        valueOutput.store(key, CompoundTag.CODEC, (Object)tag);
    }

    public static CompoundTag getTag(ValueInput valueInput) {
        return (CompoundTag)valueInput.read(MapCodec.assumeMapUnsafe((Codec)CompoundTag.CODEC)).orElseThrow();
    }

    public static TagValueOutput createValueOutput(BlockEntity blockEntity, HolderLookup.Provider provider) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), Logger.INSTANCE);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)provider);
            return tagValueOutput;
        }
    }

    public static TagValueOutput createValueOutput(Entity entity, HolderLookup.Provider provider) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(entity.problemPath(), Logger.INSTANCE);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)provider);
            return tagValueOutput;
        }
    }

    public static TagValueOutput createValueOutput(String problemPath, HolderLookup.Provider provider) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(ValueInputOutputUtils.createPath(problemPath), Logger.INSTANCE);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)provider);
            return tagValueOutput;
        }
    }

    public static TagValueInput createValueInput(BlockEntity blockEntity, HolderLookup.Provider provider, CompoundTag tag) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), Logger.INSTANCE);){
            TagValueInput tagValueInput = (TagValueInput)TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)provider, (CompoundTag)tag);
            return tagValueInput;
        }
    }

    public static TagValueInput createValueInput(Entity entity, HolderLookup.Provider provider, CompoundTag tag) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(entity.problemPath(), Logger.INSTANCE);){
            TagValueInput tagValueInput = (TagValueInput)TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)provider, (CompoundTag)tag);
            return tagValueInput;
        }
    }

    public static TagValueInput createValueInput(String problemPath, HolderLookup.Provider provider, CompoundTag tag) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(ValueInputOutputUtils.createPath(problemPath), Logger.INSTANCE);){
            TagValueInput tagValueInput = (TagValueInput)TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)provider, (CompoundTag)tag);
            return tagValueInput;
        }
    }

    public static ProblemReporter.PathElement createPath(String name) {
        return new ProblemReporter.RootFieldPathElement(name);
    }

    public static CompoundTag toTag(TagValueOutput valueOutput) {
        return valueOutput.buildResult();
    }
}

