/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.corelib.helpers;

import de.maxhenkel.car.corelib.helpers.AbstractStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.AtlasIds;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class WrappedFluidStack
extends AbstractStack<FluidStack> {
    public WrappedFluidStack(FluidStack stack) {
        super(stack);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y) {
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)((FluidStack)this.stack).getFluid());
        TextureAtlasSprite texture = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS).getSprite(extensions.getStillTexture((FluidStack)this.stack));
        int color = extensions.getTintColor((FluidStack)this.stack);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, texture, x, y, 16, 16, color);
    }

    @Override
    public List<Component> getTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getDisplayName());
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            if (BuiltInRegistries.FLUID.containsValue((Object)((FluidStack)this.stack).getFluid())) {
                ResourceLocation registryName = BuiltInRegistries.FLUID.getKey((Object)((FluidStack)this.stack).getFluid());
                tooltip.add((Component)Component.literal((String)registryName.toString()).withStyle(ChatFormatting.DARK_GRAY));
            }
            if (!((FluidStack)this.stack).getComponentsPatch().isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"item.nbt_tags", (Object[])new Object[]{((FluidStack)this.stack).getComponentsPatch().size()}).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        return tooltip;
    }

    @Override
    public Component getDisplayName() {
        return Component.literal((String)"").append(((FluidStack)this.stack).getHoverName()).withStyle(((FluidStack)this.stack).getFluid().getFluidType().getRarity().getStyleModifier());
    }

    @Override
    public boolean isEmpty() {
        return ((FluidStack)this.stack).isEmpty();
    }
}

