/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.corelib.item;

import de.maxhenkel.car.corelib.codec.CodecUtils;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ItemUtils {
    public static ItemStack itemStackAmount(int amount, ItemStack stack, Player player) {
        if (stack == null || stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (player != null && player.getAbilities().instabuild) {
            return stack;
        }
        stack.setCount(stack.getCount() + amount);
        if (stack.getCount() <= 0) {
            stack.setCount(0);
            return ItemStack.EMPTY;
        }
        if (stack.getCount() > stack.getMaxStackSize()) {
            stack.setCount(stack.getMaxStackSize());
        }
        return stack;
    }

    public static ItemStack decrItemStack(ItemStack stack, Player player) {
        return ItemUtils.itemStackAmount(-1, stack, player);
    }

    public static ItemStack incrItemStack(ItemStack stack, Player player) {
        return ItemUtils.itemStackAmount(1, stack, player);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.getItem() == stack2.getItem()) {
            return stack1.getDamageValue() == stack2.getDamageValue();
        }
        return false;
    }

    public static void saveInventory(ValueOutput valueOutput, String name, Container inv) {
        ValueOutput.TypedOutputList list = valueOutput.list(name, ItemStackWithSlot.CODEC);
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.isEmpty()) continue;
            list.add((Object)new ItemStackWithSlot(i, itemstack));
        }
    }

    public static void saveInventory(ValueOutput valueOutput, String name, NonNullList<ItemStack> inv) {
        ValueOutput.TypedOutputList list = valueOutput.list(name, ItemStackWithSlot.CODEC);
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack itemstack = (ItemStack)inv.get(i);
            if (itemstack.isEmpty()) continue;
            list.add((Object)new ItemStackWithSlot(i, itemstack));
        }
    }

    public static void saveItemList(ValueOutput valueOutput, String name, NonNullList<ItemStack> list) {
        ValueOutput.TypedOutputList out = valueOutput.list(name, ItemStack.CODEC);
        for (ItemStack stack : list) {
            if (stack.isEmpty()) continue;
            out.add((Object)stack);
        }
    }

    public static void readInventory(ValueInput valueInput, String name, Container inv) {
        for (ItemStackWithSlot stack : valueInput.listOrEmpty(name, ItemStackWithSlot.CODEC)) {
            if (!stack.isValidInContainer(inv.getContainerSize())) continue;
            inv.setItem(stack.slot(), stack.stack());
        }
    }

    public static void readInventory(ValueInput valueInput, String name, NonNullList<ItemStack> inv) {
        for (ItemStackWithSlot stack : valueInput.listOrEmpty(name, ItemStackWithSlot.CODEC)) {
            if (!stack.isValidInContainer(inv.size())) continue;
            inv.set(stack.slot(), (Object)stack.stack());
        }
    }

    public static NonNullList<ItemStack> readItemList(ValueInput valueInput, String name, boolean includeEmpty) {
        NonNullList items = NonNullList.create();
        for (ItemStack stack : valueInput.listOrEmpty(name, ItemStack.CODEC)) {
            items.add((Object)stack);
        }
        return items;
    }

    public static NonNullList<ItemStack> readItemList(ValueInput valueInput, String name) {
        return ItemUtils.readItemList(valueInput, name, true);
    }

    public static void readItemList(ValueInput valueInput, String name, NonNullList<ItemStack> list) {
        List itemList = valueInput.listOrEmpty(name, ItemStack.CODEC).stream().toList();
        for (int i = 0; i < itemList.size() && i < list.size(); ++i) {
            list.set(i, (Object)((ItemStack)itemList.get(i)));
        }
    }

    public static void removeStackFromSlot(Container inventory, int index) {
        inventory.setItem(index, ItemStack.EMPTY);
    }

    public static boolean isStackable(ItemStack stack1, ItemStack stack2) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public static CompoundTag writeOverstackedItem(CompoundTag compound, ItemStack stack) {
        CompoundTag itemStackTag = CodecUtils.toNBT(ItemStack.CODEC, stack).filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).orElseGet(CompoundTag::new);
        compound.merge(itemStackTag);
        compound.remove("Count");
        compound.putInt("Count", stack.getCount());
        return compound;
    }

    public static ItemStack readOverstackedItem(CompoundTag compound) {
        CompoundTag data = compound.copy();
        int count = data.getIntOr("Count", 0);
        data.remove("Count");
        data.putByte("Count", (byte)1);
        ItemStack stack = CodecUtils.fromNBT(ItemStack.CODEC, (Tag)data).orElse(ItemStack.EMPTY);
        stack.setCount(count);
        return stack;
    }
}

