/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.sounds.ModClientSounds;
import de.maxhenkel.car.sounds.SoundLoopHigh;
import de.maxhenkel.car.sounds.SoundLoopIdle;
import de.maxhenkel.car.sounds.SoundLoopStart;
import de.maxhenkel.car.sounds.SoundLoopStarting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;

public class CarClientSoundController {
    private final EntityGenericCar car;
    private SoundLoopStart startLoop;
    private SoundLoopIdle idleLoop;
    private SoundLoopHigh highLoop;
    private SoundLoopStarting startingLoop;
    private boolean startedLast;

    public CarClientSoundController(EntityCarBase car) {
        this.car = (EntityGenericCar)car;
    }

    public void checkIdleLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.idleLoop)) {
            this.idleLoop = new SoundLoopIdle(this.car, this.car.getIdleSound(), SoundSource.MASTER);
            ModClientSounds.playSoundLoop(this.idleLoop, this.car.level());
        }
    }

    public void checkHighLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.highLoop)) {
            this.highLoop = new SoundLoopHigh(this.car, this.car.getHighSound(), SoundSource.MASTER);
            ModClientSounds.playSoundLoop(this.highLoop, this.car.level());
        }
    }

    public void checkStartLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.startLoop)) {
            this.startLoop = new SoundLoopStart(this.car, this.car.getStartSound(), SoundSource.MASTER);
            ModClientSounds.playSoundLoop(this.startLoop, this.car.level());
        }
    }

    public void checkStartingLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.startingLoop)) {
            this.startingLoop = new SoundLoopStarting(this.car, this.car.getStartingSound(), SoundSource.MASTER);
            ModClientSounds.playSoundLoop(this.startingLoop, this.car.level());
        }
    }

    public boolean isSoundPlaying(SoundInstance sound) {
        if (sound == null) {
            return false;
        }
        return Minecraft.getInstance().getSoundManager().isActive(sound);
    }

    public void updateSounds() {
        if (!this.car.isStarted() && this.car.isStarting()) {
            this.checkStartingLoop();
        }
        if (this.car.getSpeed() == 0.0f && this.car.isStarted()) {
            if (!this.startedLast) {
                this.checkStartLoop();
            } else if (!this.isSoundPlaying((SoundInstance)this.startLoop)) {
                if (this.startLoop != null) {
                    this.startLoop.setDonePlaying();
                    this.startLoop = null;
                }
                this.checkIdleLoop();
            }
        }
        if (this.car.getSpeed() != 0.0f && this.car.isStarted()) {
            this.checkHighLoop();
        }
        this.startedLast = this.car.isStarted();
    }
}

