/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.entity.car.base.EntityCarTemperatureBase;
import de.maxhenkel.car.sounds.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public abstract class EntityCarBatteryBase
extends EntityCarTemperatureBase {
    private static final EntityDataAccessor<Integer> BATTERY_LEVEL = SynchedEntityData.defineId(EntityCarBatteryBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STARTING_TIME = SynchedEntityData.defineId(EntityCarBatteryBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> STARTING = SynchedEntityData.defineId(EntityCarBatteryBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean carStopped;
    private boolean carStarted;
    private int timeSinceStarted;
    private int timeToStart;

    public EntityCarBatteryBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void tick() {
        int time;
        super.tick();
        if (this.level().isClientSide()) {
            if (this.isStarted()) {
                ++this.timeSinceStarted;
                if (this.tickCount % 2 == 0) {
                    this.spawnParticles(this.getSpeed() > 0.1f);
                }
            } else {
                this.timeSinceStarted = 0;
            }
            return;
        }
        if (this.isStarting()) {
            if (this.tickCount % 2 == 0) {
                this.setBatteryLevel(this.getBatteryLevel() - this.getBatteryUsage());
            }
            this.setStartingTime(this.getStartingTime() + 1);
            if (this.getBatteryLevel() <= 0) {
                this.setStarting(false, true);
            }
        } else {
            this.setStartingTime(0);
        }
        if ((time = this.getStartingTime()) > 0) {
            if (this.timeToStart <= 0) {
                this.timeToStart = this.getTimeToStart();
            }
            if (time > this.getTimeToStart()) {
                this.startCarEngine();
                this.timeToStart = 0;
            }
        }
        if (this.isStarted()) {
            this.setStartingTime(0);
            this.carStarted = true;
            float speedPerc = this.getSpeed() / this.getMaxSpeed();
            int chargingRate = (int)(speedPerc * 7.0f);
            if (chargingRate < 5) {
                chargingRate = 1;
            }
            if (this.tickCount % 20 == 0) {
                this.setBatteryLevel(this.getBatteryLevel() + chargingRate);
            }
        }
    }

    public void spawnParticles(boolean driving) {
        if (!this.level().isClientSide()) {
            return;
        }
        Vec3 lookVec = this.getLookAngle().normalize();
        double offX = lookVec.x * -1.0;
        double offY = lookVec.y;
        double offZ = lookVec.z * -1.0;
        if (this.timeSinceStarted > 0 && this.timeSinceStarted < 20 && this.getTemperature() < 50.0f) {
            double speedX = lookVec.x * -0.1;
            double speedZ = lookVec.z * -0.1;
            if (this instanceof EntityCarDamageBase) {
                float damage = ((EntityCarDamageBase)this).getDamage();
                int count = 1;
                double r = 0.1;
                if (damage > 0.9f) {
                    count = 6;
                    r = 0.7;
                } else if (damage > 0.75f) {
                    count = 3;
                    r = 0.7;
                } else if (damage > 0.5f) {
                    count = 2;
                    r = 0.3;
                }
                for (int i = 0; i <= count; ++i) {
                    this.spawnParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, offX, offY, offZ, speedX, speedZ, r);
                }
            } else {
                this.spawnParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, offX, offY, offZ, speedX, speedZ);
            }
        } else if (driving) {
            double speedX = lookVec.x * -0.2;
            double speedZ = lookVec.z * -0.2;
            this.spawnParticle((ParticleOptions)ParticleTypes.SMOKE, offX, offY, offZ, speedX, speedZ);
        } else {
            double speedX = lookVec.x * -0.05;
            double speedZ = lookVec.z * -0.05;
            this.spawnParticle((ParticleOptions)ParticleTypes.SMOKE, offX, offY, offZ, speedX, speedZ);
        }
    }

    private void spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ, double speedX, double speedZ, double r) {
        this.level().addParticle(particleTypes, this.getX() + offX + (this.random.nextDouble() * r - r / 2.0), this.getY() + offY + (this.random.nextDouble() * r - r / 2.0) + this.getCarHeight() / 8.0, this.getZ() + offZ + (this.random.nextDouble() * r - r / 2.0), speedX, 0.0, speedZ);
    }

    private void spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ, double speedX, double speedZ) {
        this.spawnParticle(particleTypes, offX, offY, offZ, speedX, speedZ, 0.1);
    }

    public int getTimeToStart() {
        int time = this.random.nextInt(10) + 5;
        float temp = this.getTemperature();
        if (temp < 0.0f) {
            time += 40;
        } else if (temp < 10.0f) {
            time += 35;
        } else if (temp < 30.0f) {
            time += 10;
        } else if (temp < 60.0f) {
            time += 5;
        }
        float batteryPerc = this.getBatteryPercentage();
        if (batteryPerc < 0.5f) {
            time += 20 + this.random.nextInt(10);
        } else if (batteryPerc < 0.75f) {
            time += 10 + this.random.nextInt(10);
        }
        return time;
    }

    public int getBatteryUsage() {
        if (!((Boolean)CarMod.SERVER_CONFIG.useBattery.get()).booleanValue()) {
            return 0;
        }
        float temp = this.getBiomeTemperatureCelsius();
        int baseUsage = 2;
        if (temp < 0.0f) {
            baseUsage += 2;
        } else if (temp < 15.0f) {
            ++baseUsage;
        }
        return baseUsage;
    }

    @Override
    public void setStarted(boolean started) {
        this.setStarting(false, false);
        super.setStarted(started);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BATTERY_LEVEL, (Object)this.getMaxBatteryLevel());
        builder.define(STARTING_TIME, (Object)0);
        builder.define(STARTING, (Object)Boolean.FALSE);
    }

    public int getStartingTime() {
        return (Integer)this.entityData.get(STARTING_TIME);
    }

    public void setStartingTime(int time) {
        this.entityData.set(STARTING_TIME, (Object)time);
    }

    public boolean isStarting() {
        return (Boolean)this.entityData.get(STARTING);
    }

    public void setStarting(boolean starting, boolean playFailSound) {
        if (starting) {
            if (this.getBatteryLevel() <= 0) {
                return;
            }
            if (this.isStarted()) {
                this.setStarted(false, true, false);
                this.carStopped = true;
                return;
            }
        } else {
            if (this.carStarted || this.carStopped) {
                this.carStopped = false;
                this.carStarted = false;
                return;
            }
            if (playFailSound && this.getBatteryLevel() > 0) {
                this.playFailSound();
            }
        }
        this.entityData.set(STARTING, (Object)starting);
    }

    public float getBatterySoundPitchLevel() {
        int batteryLevel = this.getBatteryLevel();
        int startLevel = this.getMaxBatteryLevel() / 3;
        float basePitch = 1.0f - 0.002f * (float)this.getStartingTime();
        if (batteryLevel > startLevel) {
            return basePitch;
        }
        int levelUnder = startLevel - batteryLevel;
        float perc = (float)levelUnder / (float)startLevel;
        return basePitch - perc / 2.3f;
    }

    public float getBatteryPercentage() {
        return (float)this.getBatteryLevel() / (float)this.getMaxBatteryLevel();
    }

    public void setBatteryLevel(int level) {
        if (level < 0) {
            level = 0;
        } else if (level > this.getMaxBatteryLevel()) {
            level = this.getMaxBatteryLevel();
        }
        this.entityData.set(BATTERY_LEVEL, (Object)level);
    }

    public int getBatteryLevel() {
        return (Integer)this.entityData.get(BATTERY_LEVEL);
    }

    public int getMaxBatteryLevel() {
        return 1000;
    }

    @Override
    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setBatteryLevel(valueInput.getIntOr("battery", 0));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putInt("battery", this.getBatteryLevel());
    }

    @Override
    public void playFailSound() {
        ModSounds.playSound(this.getFailSound(), this.level(), this.blockPosition(), null, SoundSource.MASTER, 1.0f, this.getBatterySoundPitchLevel());
    }
}

