/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.items.ItemRepairTool;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class EntityCarDamageBase
extends EntityCarBatteryBase {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(EntityCarDamageBase.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private long lastDamage;

    public EntityCarDamageBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isInLava()) {
            this.addDamage(1.0f);
        }
        if (this.isStarted() || this.getDamage() > 99.0f) {
            this.particles();
        }
    }

    public void particles() {
        int amount;
        if (!this.level().isClientSide()) {
            return;
        }
        if (this.getDamage() < 50.0f) {
            return;
        }
        int damage = (int)this.getDamage();
        if (damage < 70) {
            if (this.random.nextInt(10) != 0) {
                return;
            }
            amount = 1;
        } else if (damage < 80) {
            if (this.random.nextInt(5) != 0) {
                return;
            }
            amount = 1;
        } else {
            amount = damage < 90 ? 2 : 3;
        }
        for (int i = 0; i < amount; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX() + (this.random.nextDouble() - 0.5) * this.getCarWidth(), this.getY() + this.random.nextDouble() * this.getCarHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * this.getCarWidth(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onCollision(float speed) {
        super.onCollision(speed);
        float percSpeed = speed / this.getMaxSpeed();
        if (percSpeed > 0.8f) {
            this.addDamage(percSpeed * 5.0f);
            this.playCrashSound();
            if (percSpeed > 0.9f) {
                this.setStarted(false);
                this.playStopSound();
            }
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource source, float damage) {
        if (this.isInvulnerable()) {
            return false;
        }
        if (this.level().isClientSide() || !this.isAlive()) {
            return false;
        }
        if (!(source.getDirectEntity() instanceof Player)) {
            return false;
        }
        Player player = (Player)source.getDirectEntity();
        if (player == null) {
            return false;
        }
        if (player.equals((Object)this.getDriver())) {
            return false;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof ItemRepairTool) {
            long time = player.level().getGameTime();
            if (time - this.lastDamage < 10L) {
                this.destroyCar(player, true);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    stack.hurtAndBreak(50, serverPlayer.level(), serverPlayer, item -> {});
                }
            } else {
                this.lastDamage = time;
            }
            return true;
        }
        return false;
    }

    public void addDamage(float val) {
        this.setDamage(this.getDamage() + val);
    }

    @Override
    public boolean canStartCarEngine(Player player) {
        boolean b = true;
        if (this.getDamage() >= 100.0f) {
            return false;
        }
        return super.canStartCarEngine(player) && b;
    }

    @Override
    public int getTimeToStart() {
        int value = super.getTimeToStart();
        if (this.getDamage() >= 95.0f) {
            value += this.random.nextInt(25) + 50;
        } else if (this.getDamage() >= 90.0f) {
            value += this.random.nextInt(15) + 30;
        } else if (this.getDamage() >= 80.0f) {
            value += this.random.nextInt(15) + 10;
        } else if (this.getDamage() >= 50.0f) {
            value += this.random.nextInt(10) + 5;
        }
        return value;
    }

    @Override
    public boolean canEngineStayOn() {
        if (this.isInWater()) {
            this.addDamage(25.0f);
            return false;
        }
        if (this.isInLava()) {
            return false;
        }
        if (this.getDamage() >= 100.0f) {
            return false;
        }
        return super.canEngineStayOn();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void setDamage(float damage) {
        if (damage > 100.0f) {
            damage = 100.0f;
        } else if (damage < 0.0f) {
            damage = 0.0f;
        }
        this.entityData.set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putFloat("damage", this.getDamage());
    }

    @Override
    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setDamage(valueInput.getFloatOr("damage", 0.0f));
    }
}

