/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.fluids.ModFluids;
import java.util.AbstractMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public abstract class EntityCarFuelBase
extends EntityCarDamageBase
implements ResourceHandler<FluidResource> {
    private static final EntityDataAccessor<Integer> FUEL_AMOUNT = SynchedEntityData.defineId(EntityCarFuelBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> FUEL_TYPE = SynchedEntityData.defineId(EntityCarFuelBase.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final SnapshotJournal<Map.Entry<Fluid, Integer>> fluidJournal = new SnapshotJournal<Map.Entry<Fluid, Integer>>(){

        protected Map.Entry<Fluid, Integer> createSnapshot() {
            return new AbstractMap.SimpleEntry<Fluid, Integer>(EntityCarFuelBase.this.getFluid(), EntityCarFuelBase.this.getFuelAmount());
        }

        protected void revertToSnapshot(Map.Entry<Fluid, Integer> snapshot) {
            Fluid fluid = snapshot.getKey();
            if (fluid != null) {
                EntityCarFuelBase.this.setFuelType(fluid);
            } else {
                EntityCarFuelBase.this.setFuelType((String)null);
            }
            EntityCarFuelBase.this.setFuelAmount(snapshot.getValue());
        }
    };

    public EntityCarFuelBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public abstract int getMaxFuel();

    @Override
    public void tick() {
        super.tick();
        this.fuelTick();
    }

    protected void fuelTick() {
        int fuel = this.getFuelAmount();
        int tickFuel = this.getEfficiency(this.getFluid());
        if (tickFuel <= 0) {
            return;
        }
        if (fuel > 0 && this.isAccelerating()) {
            if (this.tickCount % tickFuel == 0) {
                this.acceleratingFuelTick();
            }
        } else if (fuel > 0 && this.isStarted() && this.tickCount % (tickFuel * 100) == 0) {
            this.idleFuelTick();
        }
    }

    protected void idleFuelTick() {
        this.removeFuel(1);
    }

    protected void acceleratingFuelTick() {
        this.removeFuel(1);
    }

    private void removeFuel(int amount) {
        int fuel = this.getFuelAmount();
        int newFuel = fuel - amount;
        this.setFuelAmount(Math.max(newFuel, 0));
    }

    @Override
    public boolean canPlayerDriveCar(Player player) {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canPlayerDriveCar(player);
    }

    @Override
    public boolean canStartCarEngine(Player player) {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canStartCarEngine(player);
    }

    @Override
    public boolean canEngineStayOn() {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canEngineStayOn();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FUEL_AMOUNT, (Object)0);
        builder.define(FUEL_TYPE, (Object)"");
    }

    public void setFuelAmount(int fuel) {
        this.entityData.set(FUEL_AMOUNT, (Object)fuel);
    }

    public void setFuelType(String fluid) {
        if (fluid == null) {
            fluid = "";
        }
        this.entityData.set(FUEL_TYPE, (Object)fluid);
    }

    public void setFuelType(Fluid fluid) {
        this.setFuelType(BuiltInRegistries.FLUID.getKey((Object)fluid).toString());
    }

    public String getFuelType() {
        return (String)this.entityData.get(FUEL_TYPE);
    }

    @Nullable
    public Fluid getFluid() {
        String fuelType = this.getFuelType();
        if (fuelType == null || fuelType.isEmpty()) {
            return null;
        }
        return (Fluid)BuiltInRegistries.FLUID.getValue(ResourceLocation.parse((String)fuelType));
    }

    public int getFuelAmount() {
        return (Integer)this.entityData.get(FUEL_AMOUNT);
    }

    public boolean isValidFuel(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return this.getEfficiency(fluid) > 0;
    }

    public abstract int getEfficiency(@Nullable Fluid var1);

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putInt("fuel", this.getFuelAmount());
        valueOutput.putString("fuel_type", this.getFuelType());
    }

    @Override
    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setFuelAmount(valueInput.getIntOr("fuel", 0));
        valueInput.getString("fuel_type").ifPresent(this::setFuelType);
    }

    public int size() {
        return 1;
    }

    public FluidResource getResource(int index) {
        if (index == 0) {
            int fuelAmount = this.getFuelAmount();
            if (fuelAmount <= 0) {
                return FluidResource.of((Fluid)Fluids.EMPTY);
            }
            Fluid f = this.getFluid();
            if (f == null) {
                return FluidResource.of((FluidStack)new FluidStack((Fluid)ModFluids.BIO_DIESEL.get(), fuelAmount));
            }
            return FluidResource.of((FluidStack)new FluidStack(f, fuelAmount));
        }
        return FluidResource.of((Fluid)Fluids.EMPTY);
    }

    public long getAmountAsLong(int index) {
        if (index == 0) {
            return this.getFuelAmount();
        }
        return 0L;
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        Fluid fluid;
        if (index == 0 && ((fluid = this.getFluid()) == null || resource.is((Object)fluid))) {
            return this.getMaxFuel();
        }
        return 0L;
    }

    public boolean isValid(int index, FluidResource resource) {
        return this.isValidFuel(resource.getFluid());
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (index != 0) {
            return 0;
        }
        if (!this.isValidFuel(resource.getFluid())) {
            return 0;
        }
        Fluid fluid = this.getFluid();
        if (fluid != null && this.getFuelAmount() > 0 && !resource.getFluid().equals(fluid)) {
            return 0;
        }
        int actualAmount = Math.min(amount, this.getMaxFuel() - this.getFuelAmount());
        this.fluidJournal.updateSnapshots(transaction);
        int i = this.getFuelAmount() + actualAmount;
        if (i > this.getMaxFuel()) {
            i = this.getMaxFuel();
        }
        this.setFuelAmount(i);
        this.setFuelType(resource.getFluid());
        return actualAmount;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        Fluid fluid = this.getFluid();
        if (fluid != null && !resource.is((Object)fluid)) {
            return 0;
        }
        int currentAmount = this.getFuelAmount();
        int extractedAmount = Math.min(amount, currentAmount);
        this.fluidJournal.updateSnapshots(transaction);
        int newAmount = currentAmount - extractedAmount;
        if (newAmount <= 0) {
            this.setFuelType((String)null);
            this.setFuelAmount(0);
        } else {
            this.setFuelAmount(newAmount);
        }
        return extractedAmount;
    }
}

