/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.entity.car.base.EntityCarFuelBase;
import de.maxhenkel.car.gui.ContainerCar;
import de.maxhenkel.car.gui.ContainerCarInventory;
import de.maxhenkel.car.items.ItemCanister;
import de.maxhenkel.car.sounds.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public abstract class EntityCarInventoryBase
extends EntityCarFuelBase
implements Container {
    protected Container internalInventory;
    protected Container externalInventory;
    protected Container partInventory;
    protected FluidStack fluidInventory;
    private final SnapshotJournal<FluidStack> fluidJournal = new SnapshotJournal<FluidStack>(){

        protected FluidStack createSnapshot() {
            return EntityCarInventoryBase.this.fluidInventory.copy();
        }

        protected void revertToSnapshot(FluidStack snapshot) {
            EntityCarInventoryBase.this.fluidInventory = snapshot.copy();
        }
    };
    private final ResourceHandler<FluidResource> inventoryFluidHandler = new ResourceHandler<FluidResource>(){

        public int size() {
            return 1;
        }

        public FluidResource getResource(int index) {
            return FluidResource.of((FluidStack)EntityCarInventoryBase.this.fluidInventory);
        }

        public long getAmountAsLong(int index) {
            return EntityCarInventoryBase.this.fluidInventory.getAmount();
        }

        public long getCapacityAsLong(int index, FluidResource resource) {
            return EntityCarInventoryBase.this.getFluidInventorySize();
        }

        public boolean isValid(int index, FluidResource resource) {
            if (EntityCarInventoryBase.this.fluidInventory.isEmpty()) {
                return true;
            }
            return resource.is((Object)EntityCarInventoryBase.this.fluidInventory.getFluid());
        }

        public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
            if (EntityCarInventoryBase.this.fluidInventory.isEmpty()) {
                int result = Math.min(amount, EntityCarInventoryBase.this.getFluidInventorySize());
                EntityCarInventoryBase.this.fluidJournal.updateSnapshots(transaction);
                EntityCarInventoryBase.this.fluidInventory = new FluidStack(resource.getFluid(), result);
                return result;
            }
            if (resource.getFluid().equals(EntityCarInventoryBase.this.fluidInventory.getFluid())) {
                int result = Math.min(amount, EntityCarInventoryBase.this.getFluidInventorySize() - EntityCarInventoryBase.this.fluidInventory.getAmount());
                EntityCarInventoryBase.this.fluidJournal.updateSnapshots(transaction);
                EntityCarInventoryBase.this.fluidInventory.setAmount(EntityCarInventoryBase.this.fluidInventory.getAmount() + result);
                return result;
            }
            return 0;
        }

        public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
            if (EntityCarInventoryBase.this.fluidInventory.isEmpty()) {
                return 0;
            }
            if (EntityCarInventoryBase.this.fluidInventory.is(resource.getFluid())) {
                int result = Math.min(amount, EntityCarInventoryBase.this.fluidInventory.getAmount());
                EntityCarInventoryBase.this.fluidJournal.updateSnapshots(transaction);
                EntityCarInventoryBase.this.fluidInventory.setAmount(EntityCarInventoryBase.this.fluidInventory.getAmount() - result);
                if (EntityCarInventoryBase.this.fluidInventory.getAmount() <= 0) {
                    EntityCarInventoryBase.this.fluidInventory = FluidStack.EMPTY;
                }
                return result;
            }
            return 0;
        }
    };

    public EntityCarInventoryBase(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.internalInventory = new SimpleContainer(27);
        this.externalInventory = new SimpleContainer(0);
        this.partInventory = new SimpleContainer(15);
        this.fluidInventory = FluidStack.EMPTY;
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.canPlayerAccessInventoryExternal(player) && player.isShiftKeyDown()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.isEmpty()) {
                ItemAccess itemAccess;
                ResourceHandler capability;
                if (stack.getItem() instanceof ItemCanister) {
                    boolean success = ItemCanister.fillCanister(ItemAccess.forPlayerInteraction((Player)player, (InteractionHand)hand), this);
                    if (success) {
                        ModSounds.playSound(SoundEvents.BREWING_STAND_BREW, this.level(), this.blockPosition(), null, SoundSource.BLOCKS);
                    }
                    return InteractionResult.CONSUME;
                }
                if (this.getFluidInventorySize() > 0 && (capability = (ResourceHandler)(itemAccess = ItemAccess.forPlayerInteraction((Player)player, (InteractionHand)hand)).getCapability(Capabilities.Fluid.ITEM)) != null) {
                    try (Transaction transaction = Transaction.open(null);){
                        ResourceHandler<FluidResource> handler = this.getInventoryFluidHandler();
                        if (ResourceHandlerUtil.isEmpty((ResourceHandler)capability)) {
                            ResourceHandlerUtil.move(handler, (ResourceHandler)capability, f -> true, (int)Integer.MAX_VALUE, (TransactionContext)transaction);
                        } else {
                            ResourceHandlerUtil.move((ResourceHandler)capability, handler, f -> true, (int)Integer.MAX_VALUE, (TransactionContext)transaction);
                        }
                        transaction.commit();
                    }
                }
            }
            if (!this.level().isClientSide()) {
                if (this.externalInventory.getContainerSize() <= 0) {
                    this.openCarGUI(player);
                } else if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.openMenu(new MenuProvider(){

                        public Component getDisplayName() {
                            return EntityCarInventoryBase.this.getDisplayName();
                        }

                        @Nullable
                        public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                            return new ContainerCarInventory(i, EntityCarInventoryBase.this, playerInventory);
                        }
                    }, packetBuffer -> packetBuffer.writeUUID(this.getUUID()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public abstract int getFluidInventorySize();

    public boolean canPlayerAccessInventoryExternal(Player player) {
        return true;
    }

    public Container getPartInventory() {
        return this.partInventory;
    }

    @Override
    public void destroyCar(Player player, boolean dropParts) {
        super.destroyCar(player, dropParts);
        Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        Containers.dropContents((Level)this.level(), (Entity)this, (Container)this.externalInventory);
        if (dropParts) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this.partInventory);
        }
    }

    @Override
    public void openCarGUI(Player player) {
        super.openCarGUI(player);
        if (!this.level().isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return EntityCarInventoryBase.this.getDisplayName();
                }

                @Nullable
                public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                    return new ContainerCar(i, EntityCarInventoryBase.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.writeUUID(this.getUUID()));
        }
    }

    @Override
    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        ItemUtils.readInventory(valueInput, "int_inventory", this.internalInventory);
        this.externalInventory = new SimpleContainer(valueInput.getIntOr("external_inventory_size", 0));
        ItemUtils.readInventory(valueInput, "external_inventory", this.externalInventory);
        ItemUtils.readInventory(valueInput, "parts", this.partInventory);
        valueInput.read("fluid_inventory", FluidStack.CODEC).ifPresent(stack -> {
            this.fluidInventory = stack;
        });
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        ItemUtils.saveInventory(valueOutput, "int_inventory", this.internalInventory);
        valueOutput.putInt("external_inventory_size", this.externalInventory.getContainerSize());
        ItemUtils.saveInventory(valueOutput, "external_inventory", this.externalInventory);
        ItemUtils.saveInventory(valueOutput, "parts", this.partInventory);
        valueOutput.store("fluid_inventory", FluidStack.CODEC, (Object)this.fluidInventory);
    }

    public ResourceHandler<FluidResource> getInventoryFluidHandler() {
        return this.inventoryFluidHandler;
    }

    public int getContainerSize() {
        return this.internalInventory.getContainerSize();
    }

    public ItemStack getItem(int index) {
        return this.internalInventory.getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.internalInventory.removeItem(index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.internalInventory.removeItemNoUpdate(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.internalInventory.setItem(index, stack);
    }

    public int getMaxStackSize() {
        return this.internalInventory.getMaxStackSize();
    }

    public void setChanged() {
        this.internalInventory.setChanged();
    }

    public boolean stillValid(Player player) {
        return this.internalInventory.stillValid(player);
    }

    public boolean isEmpty() {
        return this.internalInventory.isEmpty();
    }

    public void startOpen(ContainerUser user) {
        this.internalInventory.startOpen(user);
    }

    public void stopOpen(ContainerUser user) {
        this.internalInventory.stopOpen(user);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.internalInventory.canPlaceItem(index, stack);
    }

    public void clearContent() {
        this.internalInventory.clearContent();
    }

    public Container getExternalInventory() {
        return this.externalInventory;
    }
}

