/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.config.Fuel;
import de.maxhenkel.car.corelib.client.obj.OBJModelInstance;
import de.maxhenkel.car.entity.car.base.EntityCarLicensePlateBase;
import de.maxhenkel.car.entity.car.parts.Part;
import de.maxhenkel.car.entity.car.parts.PartBody;
import de.maxhenkel.car.entity.car.parts.PartBodyTransporter;
import de.maxhenkel.car.entity.car.parts.PartContainer;
import de.maxhenkel.car.entity.car.parts.PartEngine;
import de.maxhenkel.car.entity.car.parts.PartEngineTruck;
import de.maxhenkel.car.entity.car.parts.PartLicensePlateHolder;
import de.maxhenkel.car.entity.car.parts.PartModel;
import de.maxhenkel.car.entity.car.parts.PartTank;
import de.maxhenkel.car.entity.car.parts.PartTankContainer;
import de.maxhenkel.car.entity.car.parts.PartWheelBase;
import de.maxhenkel.car.entity.model.CarRenderState;
import de.maxhenkel.car.integration.jei.CarRecipe;
import de.maxhenkel.car.integration.jei.CarRecipeBuilder;
import de.maxhenkel.car.items.ICarPart;
import de.maxhenkel.car.items.ItemKey;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import org.joml.Vector3d;

public class EntityGenericCar
extends EntityCarLicensePlateBase {
    private static final EntityDataAccessor<NonNullList<ItemStack>> PARTS = SynchedEntityData.defineId(EntityGenericCar.class, (EntityDataSerializer)((EntityDataSerializer)CarMod.ITEM_LIST.get()));
    private List<Part> parts;
    private float maxUpStep;
    private boolean isInitialized;
    private boolean isSpawned = true;
    private List<OBJModelInstance<CarRenderState>> modelInstances = new ArrayList<OBJModelInstance<CarRenderState>>();

    public EntityGenericCar(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.maxUpStep = super.maxUpStep();
    }

    public EntityGenericCar(Level worldIn) {
        this((EntityType)CarMod.CAR_ENTITY_TYPE.get(), worldIn);
    }

    private List<Part> getCarParts() {
        if (this.parts == null) {
            this.parts = new ArrayList<Part>();
        }
        return this.parts;
    }

    @Override
    public float getWheelRotationAmount() {
        PartWheelBase wheel = this.getPartByClass(PartWheelBase.class);
        if (wheel == null) {
            return super.getWheelRotationAmount();
        }
        return wheel.getRotationModifier() * this.getSpeed();
    }

    @Override
    public int getFluidInventorySize() {
        PartTankContainer tank = this.getPartByClass(PartTankContainer.class);
        if (tank == null) {
            return 0;
        }
        return tank.getFluidAmount();
    }

    @Override
    public float getMaxSpeed() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return 0.0f;
        }
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 0.0f;
        }
        return engine.getMaxSpeed() * chassis.getMaxSpeed();
    }

    @Override
    public float getMaxReverseSpeed() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return 0.0f;
        }
        return engine.getMaxReverseSpeed();
    }

    @Override
    public float getAcceleration() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return 0.0f;
        }
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 0.0f;
        }
        return engine.getAcceleration() * chassis.getAcceleration();
    }

    @Override
    public float getMaxRotationSpeed() {
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 5.0f;
        }
        return chassis.getMaxRotationSpeed();
    }

    @Override
    public float getMinRotationSpeed() {
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 2.0f;
        }
        return chassis.getMinRotationSpeed();
    }

    @Override
    public float getRollResistance() {
        return 0.02f;
    }

    @Override
    public float getOptimalTemperature() {
        return 90.0f;
    }

    @Override
    public int getMaxFuel() {
        PartTank tank = this.getPartByClass(PartTank.class);
        if (tank == null) {
            return 0;
        }
        return tank.getSize();
    }

    @Override
    public int getEfficiency(@Nullable Fluid fluid) {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return 0;
        }
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 0;
        }
        int fluidEfficiency = 0;
        if (fluid == null) {
            fluidEfficiency = 100;
        } else {
            Fuel fuel = CarMod.FUEL_CONFIG.getFuels().getOrDefault(fluid, null);
            if (fuel != null) {
                fluidEfficiency = fuel.getEfficiency();
            }
        }
        return (int)Math.ceil(chassis.getFuelEfficiency() * engine.getFuelEfficiency() * (float)fluidEfficiency);
    }

    @Override
    public float getRotationModifier() {
        return 0.5f;
    }

    @Override
    public float getPitch() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine instanceof PartEngineTruck) {
            return 1.0f + 0.35f * Math.abs(this.getSpeed()) / this.getMaxSpeed();
        }
        return Math.abs(this.getSpeed()) / this.getMaxSpeed();
    }

    @Override
    public double getPlayerYOffset() {
        return 0.2;
    }

    @Override
    public Vector3d[] getPlayerOffsets() {
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return new Vector3d[]{new Vector3d(0.55, 0.0, -0.38), new Vector3d(0.55, 0.0, 0.38)};
        }
        return chassis.getPlayerOffsets();
    }

    @Override
    public int getPassengerSize() {
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return 0;
        }
        return chassis.getPlayerOffsets().length;
    }

    @Override
    public Vector3d getLicensePlateOffset() {
        PartBody chassis = this.getPartByClass(PartBody.class);
        if (chassis == null) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        PartLicensePlateHolder numberPlate = this.getPartByClass(PartLicensePlateHolder.class);
        if (numberPlate == null) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        Vector3d offset = chassis.getNumberPlateOffset();
        Vector3d textOffset = numberPlate.getTextOffset();
        return new Vector3d(offset.x + textOffset.x, -offset.y + textOffset.y, offset.z - textOffset.z);
    }

    @Override
    public boolean doesEnterThirdPerson() {
        return true;
    }

    @Override
    public SoundEvent getStopSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return (SoundEvent)ModSounds.ENGINE_STOP.get();
        }
        return engine.getStopSound();
    }

    @Override
    public SoundEvent getFailSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return (SoundEvent)ModSounds.ENGINE_FAIL.get();
        }
        return engine.getFailSound();
    }

    @Override
    public SoundEvent getCrashSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return (SoundEvent)ModSounds.CAR_CRASH.get();
        }
        return engine.getCrashSound();
    }

    @Override
    public SoundEvent getStartSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return (SoundEvent)ModSounds.ENGINE_START.get();
        }
        return engine.getStartSound();
    }

    @Override
    public SoundEvent getStartingSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return (SoundEvent)ModSounds.ENGINE_STARTING.get();
        }
        return engine.getStartingSound();
    }

    @Override
    public SoundEvent getIdleSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return (SoundEvent)ModSounds.ENGINE_IDLE.get();
        }
        return engine.getIdleSound();
    }

    @Override
    public SoundEvent getHighSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return (SoundEvent)ModSounds.ENGINE_HIGH.get();
        }
        return engine.getHighSound();
    }

    @Override
    public SoundEvent getHornSound() {
        PartEngine engine = this.getPartByClass(PartEngine.class);
        if (engine == null) {
            return (SoundEvent)ModSounds.CAR_HORN.get();
        }
        return engine.getHornSound();
    }

    protected Component getTypeName() {
        PartBody body = this.getPartByClass(PartBody.class);
        if (body == null) {
            return super.getTypeName();
        }
        return Component.translatable((String)("car_name." + body.getTranslationKey()), (Object[])new Object[]{Component.translatable((String)("car_variant." + body.getMaterialTranslationKey()))});
    }

    public Component getShortName() {
        PartBody body = this.getPartByClass(PartBody.class);
        if (body == null) {
            return this.getTypeName();
        }
        return Component.translatable((String)("car_short_name." + body.getTranslationKey()));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PARTS, (Object)NonNullList.create());
    }

    public <T extends Part> T getPartByClass(Class<T> clazz) {
        for (Part part : this.getCarParts()) {
            if (!clazz.isInstance(part)) continue;
            return (T)part;
        }
        return null;
    }

    public void setPartSerializer() {
        NonNullList stacks = NonNullList.withSize((int)this.partInventory.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.partInventory.getContainerSize(); ++i) {
            stacks.set(i, (Object)this.partInventory.getItem(i));
        }
        this.entityData.set(PARTS, (Object)stacks);
    }

    private boolean updateClientSideItems() {
        NonNullList stacks = (NonNullList)this.entityData.get(PARTS);
        if (stacks.isEmpty()) {
            return false;
        }
        for (int i = 0; i < stacks.size(); ++i) {
            this.partInventory.setItem(i, (ItemStack)stacks.get(i));
        }
        return true;
    }

    @Override
    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        if (valueInput.keySet().stream().allMatch(s -> s.equals("id"))) {
            this.randomizeParts();
            this.setItem(0, ItemKey.getKeyForCar(this.getUUID()));
            this.setItem(1, ItemKey.getKeyForCar(this.getUUID()));
            this.setFuelAmount(100);
            this.setBatteryLevel(500);
            this.initTemperature();
        }
        this.setPartSerializer();
        this.tryInitPartsAndModel();
    }

    protected void randomizeParts() {
        List<CarRecipe> allRecipes = CarRecipeBuilder.getAllRecipes();
        CarRecipe recipe = allRecipes.get(new Random().nextInt(allRecipes.size()));
        this.getCarParts().clear();
        this.partInventory.clearContent();
        List<ItemStack> inputs = recipe.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            this.partInventory.setItem(i, inputs.get(i));
        }
    }

    public void setIsSpawned(boolean isSpawned) {
        this.isSpawned = isSpawned;
    }

    public boolean isSpawned() {
        return this.isSpawned;
    }

    @Override
    public void tick() {
        super.tick();
        this.tryInitPartsAndModel();
    }

    public void tryInitPartsAndModel() {
        if (!this.isInitialized) {
            if (this.level().isClientSide()) {
                if (!this.isSpawned || this.updateClientSideItems()) {
                    this.initParts();
                    this.initModel();
                    this.isInitialized = true;
                }
            } else {
                this.initParts();
                this.isInitialized = true;
            }
        }
    }

    public List<Part> getModelParts() {
        return Collections.unmodifiableList(this.getCarParts());
    }

    public void initParts() {
        this.getCarParts().clear();
        for (int i = 0; i < this.partInventory.getContainerSize(); ++i) {
            ICarPart itemCarPart;
            Part part;
            ItemStack stack = this.partInventory.getItem(i);
            if (!(stack.getItem() instanceof ICarPart) || (part = (itemCarPart = (ICarPart)stack.getItem()).getPart(stack)) == null) continue;
            this.getCarParts().add(part);
        }
        this.checkInitializing();
    }

    private void checkInitializing() {
        PartWheelBase partWheels;
        PartBody body = this.getPartByClass(PartBody.class);
        if (body instanceof PartBodyTransporter) {
            PartContainer container = this.getPartByClass(PartContainer.class);
            if (this.externalInventory.getContainerSize() <= 0) {
                this.externalInventory = container != null ? new SimpleContainer(54) : new SimpleContainer(27);
            }
        }
        if ((partWheels = this.getPartByClass(PartWheelBase.class)) != null) {
            this.setMaxUpStep(partWheels.getStepHeight());
        }
    }

    @Override
    public float maxUpStep() {
        return this.maxUpStep;
    }

    public void setMaxUpStep(float maxUpStep) {
        this.maxUpStep = maxUpStep;
    }

    @Override
    public double getCarWidth() {
        PartBody body = this.getPartByClass(PartBody.class);
        if (body != null) {
            return body.getWidth();
        }
        return super.getCarWidth();
    }

    @Override
    public double getCarHeight() {
        PartBody body = this.getPartByClass(PartBody.class);
        if (body != null) {
            return body.getHeight();
        }
        return super.getCarHeight();
    }

    protected void initModel() {
        this.modelInstances.clear();
        boolean addedWheels = false;
        for (Part part : this.getCarParts()) {
            if (!(part instanceof PartModel)) continue;
            if (part instanceof PartWheelBase) {
                if (addedWheels) continue;
                addedWheels = true;
            }
            this.modelInstances.addAll(((PartModel)part).getInstances(this));
        }
    }

    public List<OBJModelInstance<CarRenderState>> getModels() {
        return this.modelInstances;
    }
}

