/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.CarMod;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public abstract class EntityVehicleBase
extends Entity {
    public static float SCALE_FACTOR = 0.7f;
    private int steps;
    private double clientX;
    private double clientY;
    private double clientZ;
    private double clientYaw;
    private double clientPitch;
    protected float deltaRotation;

    public EntityVehicleBase(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.blocksBuilding = true;
        this.recalculateBoundingBox();
    }

    public float maxUpStep() {
        return 0.6f;
    }

    public void tick() {
        if (!this.level().isClientSide()) {
            this.xo = this.getX();
            this.yo = this.getY();
            this.zo = this.getZ();
        }
        super.tick();
        this.tickLerp();
        this.recalculateBoundingBox();
    }

    public void recalculateBoundingBox() {
        double width = this.getCarWidth();
        double height = this.getCarHeight();
        this.setBoundingBox(new AABB(this.getX() - width / 2.0, this.getY(), this.getZ() - width / 2.0, this.getX() + width / 2.0, this.getY() + height, this.getZ() + width / 2.0));
    }

    public double getCarWidth() {
        return 1.3;
    }

    public double getCarHeight() {
        return 1.6;
    }

    public Player getDriver() {
        List passengers = this.getPassengers();
        if (passengers.size() <= 0) {
            return null;
        }
        if (passengers.get(0) instanceof Player) {
            return (Player)passengers.get(0);
        }
        return null;
    }

    public abstract int getPassengerSize();

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().size() < this.getPassengerSize();
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(entityToUpdate.getYRot() - this.getYRot()));
        float f1 = Mth.clamp((float)f, (float)-130.0f, (float)130.0f);
        entityToUpdate.yRotO += f1 - f;
        entityToUpdate.setYRot(entityToUpdate.getYRot() + f1 - f);
        entityToUpdate.setYHeadRot(entityToUpdate.getYRot());
    }

    public void onPassengerTurned(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public abstract Vector3d[] getPlayerOffsets();

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        double front = 0.0;
        double side = 0.0;
        double height = 0.0;
        List passengers = this.getPassengers();
        if (passengers.size() > 0) {
            int i = passengers.indexOf(passenger);
            Vector3d offset = this.getPlayerOffsets()[i];
            front = offset.x;
            side = offset.z;
            height = offset.y;
        }
        Vec3 vec3d = new Vec3(front, height, side).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
        passenger.setPos(this.getX() + vec3d.x, this.getY() + vec3d.y, this.getZ() + vec3d.z);
        passenger.setYRot(passenger.getYRot() + this.deltaRotation);
        passenger.setYHeadRot(passenger.getYHeadRot() + this.deltaRotation);
        this.applyYawToEntity(passenger);
    }

    public LivingEntity getControllingPassenger() {
        return this.getDriver();
    }

    public boolean canCollideWith(Entity entity) {
        if (!((Boolean)CarMod.SERVER_CONFIG.collideWithEntities.get()).booleanValue() && !(entity instanceof EntityVehicleBase)) {
            return false;
        }
        return (entity.canBeCollidedWith(entity) || entity.isPushable()) && !this.isPassengerOfSameVehicle(entity);
    }

    public boolean canBeCollidedWith(@Nullable Entity entity) {
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean isPushable() {
        return true;
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    private void tickLerp() {
        if (this.isLocalClientAuthoritative()) {
            this.steps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.steps > 0) {
            double d0 = this.getX() + (this.clientX - this.getX()) / (double)this.steps;
            double d1 = this.getY() + (this.clientY - this.getY()) / (double)this.steps;
            double d2 = this.getZ() + (this.clientZ - this.getZ()) / (double)this.steps;
            double d3 = Mth.wrapDegrees((double)(this.clientYaw - (double)this.getYRot()));
            this.setYRot((float)((double)this.getYRot() + d3 / (double)this.steps));
            this.setXRot((float)((double)this.getXRot() + (this.clientPitch - (double)this.getXRot()) / (double)this.steps));
            --this.steps;
            this.setPos(d0, d1, d2);
            this.setRot(this.getYRot(), this.getXRot());
        }
    }

    public void moveOrInterpolateTo(Vec3 pos, float yaw, float pitch) {
        this.clientX = pos.x;
        this.clientY = pos.y;
        this.clientZ = pos.z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.steps = 10;
    }

    public static double calculateMotionX(float speed, float rotationYaw) {
        return Mth.sin((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public static double calculateMotionZ(float speed, float rotationYaw) {
        return Mth.cos((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!player.isShiftKeyDown()) {
            if (player.getVehicle() != this && !this.level().isClientSide()) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public abstract boolean doesEnterThirdPerson();

    public Vec3 getDismountLocationForPassenger(LivingEntity entity) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(entity);
        }
        int[][] offsets = DismountHelper.offsetsForDirection((Direction)direction);
        AABB bb = entity.getLocalBoundsForPose(Pose.STANDING);
        AABB carBB = this.getBoundingBox();
        for (int[] offset : offsets) {
            Vec3 dismountPos = new Vec3(this.getX() + (double)offset[0] * (carBB.getXsize() / 2.0 + bb.getXsize() / 2.0 + 0.0625), this.getY(), this.getZ() + (double)offset[1] * (carBB.getXsize() / 2.0 + bb.getXsize() / 2.0 + 0.0625));
            double y = this.level().getBlockFloorHeight(new BlockPos((int)dismountPos.x, (int)dismountPos.y, (int)dismountPos.z));
            if (!DismountHelper.isBlockFloorValid((double)y) || !DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)entity, (AABB)bb.move(dismountPos))) continue;
            return dismountPos;
        }
        return super.getDismountLocationForPassenger(entity);
    }

    public Vec3 collide(Vec3 movement) {
        boolean falling;
        AABB boundingBox = this.getBoundingBox();
        List collisions = this.level().getEntityCollisions((Entity)this, boundingBox.expandTowards(movement));
        Vec3 resultingMovement = movement.lengthSqr() == 0.0 ? movement : EntityVehicleBase.collideBoundingBox((Entity)this, (Vec3)movement, (AABB)boundingBox, (Level)this.level(), (List)collisions);
        boolean diffX = movement.x != resultingMovement.x;
        boolean diffY = movement.y != resultingMovement.y;
        boolean diffZ = movement.z != resultingMovement.z;
        boolean bl = falling = diffY && movement.y < 0.0;
        if (this.maxUpStep() > 0.0f && (falling || this.onGround()) && (diffX || diffZ)) {
            Vec3 xzVec;
            Vec3 stepMovementVec = EntityVehicleBase.collideBoundingBox((Entity)this, (Vec3)new Vec3(movement.x, (double)this.maxUpStep(), movement.z), (AABB)boundingBox, (Level)this.level(), (List)collisions);
            Vec3 stepVec = EntityVehicleBase.collideBoundingBox((Entity)this, (Vec3)new Vec3(0.0, (double)this.maxUpStep(), 0.0), (AABB)boundingBox.expandTowards(movement.x, 0.0, movement.z), (Level)this.level(), (List)collisions);
            if (stepVec.y < (double)this.maxUpStep() && (xzVec = EntityVehicleBase.collideBoundingBox((Entity)this, (Vec3)new Vec3(movement.x, 0.0, movement.z), (AABB)boundingBox.move(stepVec), (Level)this.level(), (List)collisions).add(stepVec)).horizontalDistanceSqr() > stepMovementVec.horizontalDistanceSqr()) {
                stepMovementVec = xzVec;
            }
            if (stepMovementVec.horizontalDistanceSqr() > resultingMovement.horizontalDistanceSqr()) {
                resultingMovement = stepMovementVec.add(EntityVehicleBase.collideBoundingBox((Entity)this, (Vec3)new Vec3(0.0, -stepMovementVec.y + movement.y, 0.0), (AABB)boundingBox.move(stepMovementVec), (Level)this.level(), (List)collisions));
            }
        }
        return resultingMovement;
    }
}

