/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.car.corelib.client.obj.OBJEntityRenderer;
import de.maxhenkel.car.corelib.client.obj.OBJModelInstance;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.model.CarRenderState;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;
import org.joml.Vector3d;

public class GenericCarModel
extends OBJEntityRenderer<EntityGenericCar, CarRenderState> {
    public GenericCarModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public CarRenderState createRenderState() {
        return new CarRenderState();
    }

    public void extractRenderState(EntityGenericCar car, CarRenderState state, float partialTicks) {
        super.extractRenderState((Entity)car, (EntityRenderState)state, partialTicks);
        state.models = car.getModels();
        String licensePlate = car.getLicensePlate();
        state.licensePlate = licensePlate == null ? null : Component.literal((String)licensePlate).getVisualOrderText();
        state.licensePlateOffset = car.getLicensePlateOffset();
        state.yRot = car.getViewYRot(partialTicks);
    }

    @Override
    public List<OBJModelInstance<CarRenderState>> getModels(CarRenderState state) {
        return state.models;
    }

    @Override
    public void submit(CarRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        super.submit(state, pose, collector, cameraRenderState);
        if (state.licensePlate != null) {
            this.drawLicensePlate(state, pose, collector);
        }
    }

    @Override
    protected void setupYaw(CarRenderState state, PoseStack pose) {
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - state.yRot));
    }

    private void drawLicensePlate(CarRenderState state, PoseStack stack, SubmitNodeCollector collector) {
        stack.pushPose();
        stack.scale(1.0f, -1.0f, 1.0f);
        this.translateLicensePlate(state, stack);
        int textWidth = Minecraft.getInstance().font.width(state.licensePlate);
        float textScale = 0.01f;
        stack.translate(-(textScale * (float)textWidth) / 2.0f, 0.0f, 0.0f);
        stack.scale(textScale, textScale, textScale);
        collector.submitText(stack, 0.0f, 0.0f, state.licensePlate, false, Font.DisplayMode.NORMAL, state.lightCoords, -1, 0, 0);
        stack.popPose();
    }

    protected void translateLicensePlate(CarRenderState state, PoseStack matrixStack) {
        Vector3d offset = state.licensePlateOffset;
        matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - state.yRot));
        matrixStack.translate(offset.x, offset.y, offset.z);
    }
}

