/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class BlockEvents {
    private static ResourceKey<LootTable> GRASS_LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"car", (String)"blocks/grass"));

    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        if (!event.getState().getBlock().equals(Blocks.SHORT_GRASS)) {
            return;
        }
        Level level = event.getPlayer().level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            LootParams.Builder builder = new LootParams.Builder(level2).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)event.getPos().getX(), (double)event.getPos().getY(), (double)event.getPos().getZ())).withParameter(LootContextParams.TOOL, (Object)event.getPlayer().getMainHandItem()).withParameter(LootContextParams.THIS_ENTITY, (Object)event.getPlayer()).withParameter(LootContextParams.BLOCK_STATE, (Object)event.getState());
            LootParams lootContext = builder.create(LootContextParamSets.BLOCK);
            LootTable lootTable = level2.getServer().reloadableRegistries().getLootTable(GRASS_LOOT_TABLE);
            lootTable.getRandomItems(lootContext).forEach(stack -> Block.popResource((Level)level2, (BlockPos)event.getPos(), (ItemStack)stack));
        }
    }
}

