/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import de.maxhenkel.car.CarModClient;
import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.net.MessageCenterCar;
import de.maxhenkel.car.net.MessageStarting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class KeyEvents {
    private boolean wasStartPressed;
    private boolean wasGuiPressed;
    private boolean wasHornPressed;
    private boolean wasCenterPressed;

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        Entity riding = player.getVehicle();
        if (!(riding instanceof EntityCarBatteryBase)) {
            return;
        }
        EntityCarBatteryBase car = (EntityCarBatteryBase)riding;
        if (player.equals((Object)car.getDriver())) {
            car.updateControls(CarModClient.FORWARD_KEY.isDown(), CarModClient.BACK_KEY.isDown(), CarModClient.LEFT_KEY.isDown(), CarModClient.RIGHT_KEY.isDown(), (Player)player);
            if (CarModClient.START_KEY.isDown()) {
                if (!this.wasStartPressed) {
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageStarting(true, false, (Player)player), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.wasStartPressed = true;
                }
            } else {
                if (this.wasStartPressed) {
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageStarting(false, true, (Player)player), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.wasStartPressed = false;
            }
            if (CarModClient.HORN_KEY.isDown()) {
                if (!this.wasHornPressed) {
                    car.onHornPressed((Player)player);
                    this.wasHornPressed = true;
                }
            } else {
                this.wasHornPressed = false;
            }
            if (CarModClient.CENTER_KEY.isDown()) {
                if (!this.wasCenterPressed) {
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageCenterCar((Player)player), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    player.displayClientMessage((Component)Component.translatable((String)"message.center_car"), true);
                    this.wasCenterPressed = true;
                }
            } else {
                this.wasCenterPressed = false;
            }
        }
        if (CarModClient.CAR_GUI_KEY.isDown()) {
            if (!this.wasGuiPressed) {
                car.openCarGUI((Player)player);
                this.wasGuiPressed = true;
            }
        } else {
            this.wasGuiPressed = false;
        }
    }
}

