/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.fluids;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;

public class FluidTypeCar
extends FluidType {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;

    public FluidTypeCar(String descriptionId, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        super(FluidType.Properties.create().canConvertToSource(false).canDrown(true).canExtinguish(false).canHydrate(false).canPushEntity(true).canSwim(true).lightLevel(0).supportsBoating(false).fallDistanceModifier(0.0f).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).descriptionId(descriptionId));
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
    }

    public IClientFluidTypeExtensions getExtensions() {
        return new IClientFluidTypeExtensions(){
            private static final ResourceLocation UNDERWATER_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/underwater.png");
            private static final ResourceLocation WATER_OVERLAY = ResourceLocation.withDefaultNamespace((String)"block/water_overlay");

            public ResourceLocation getStillTexture() {
                return FluidTypeCar.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return FluidTypeCar.this.flowingTexture;
            }

            public ResourceLocation getOverlayTexture() {
                return WATER_OVERLAY;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return UNDERWATER_LOCATION;
            }
        };
    }
}

