/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityBackmixReactor;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerBackmixReactor;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;

public class GuiBackmixReactor
extends ScreenBase<ContainerBackmixReactor> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/gui_backmix_reactor.png");
    private Container playerInv;
    private TileEntityBackmixReactor tile;

    public GuiBackmixReactor(ContainerBackmixReactor container, Inventory playerInv, Component name) {
        super(GUI_TEXTURE, container, playerInv, name);
        this.playerInv = playerInv;
        this.tile = container.getBackmixReactor();
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.playerInventoryTitle.getVisualOrderText(), 8, this.imageHeight - 96 + 2, -12566464, false);
        if (mouseX >= this.leftPos + 11 && mouseX <= this.leftPos + 16 + 11 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 57 + 8) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.translatable((String)"tooltip.energy", (Object[])new Object[]{this.tile.getStoredEnergy()}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
        if (mouseX >= this.leftPos + 33 && mouseX <= this.leftPos + 16 + 33 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 57 + 8) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.oil", (Object[])new Object[]{this.tile.getCurrentCanola()}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
        if (mouseX >= this.leftPos + 55 && mouseX <= this.leftPos + 16 + 55 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 57 + 8) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.methanol", (Object[])new Object[]{this.tile.getCurrentMethanol()}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
        if (mouseX >= this.leftPos + 122 && mouseX <= this.leftPos + 16 + 122 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 57 + 8) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.mix", (Object[])new Object[]{this.tile.getCurrentMix()}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
        if (mouseX >= this.leftPos + 79 && mouseX <= this.leftPos + 24 + 79 && mouseY >= this.topPos + 34 && mouseY <= this.topPos + 17 + 34) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.progress", (Object[])new Object[]{(int)(this.getProgress() * 100.0f)}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawProgress(guiGraphics);
        this.drawEnergy(guiGraphics);
        this.drawCanola(guiGraphics);
        this.drawMethanol(guiGraphics);
        this.drawMix(guiGraphics);
    }

    public void drawEnergy(GuiGraphics guiGraphics) {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 11;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, i + targetX, j + targetY + scHeight, (float)texX, (float)(texY + scHeight), texW, texH - scHeight, 256, 256);
    }

    public void drawCanola(GuiGraphics guiGraphics) {
        float perc = this.getCanola();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 33;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, i + targetX, j + targetY + scHeight, (float)texX, (float)(texY + scHeight), texW, texH - scHeight, 256, 256);
    }

    public void drawMethanol(GuiGraphics guiGraphics) {
        float perc = this.getMethanol();
        int texX = 208;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 55;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, i + targetX, j + targetY + scHeight, (float)texX, (float)(texY + scHeight), texW, texH - scHeight, 256, 256);
    }

    public void drawMix(GuiGraphics guiGraphics) {
        float perc = this.getMix();
        int texX = 224;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 122;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, i + targetX, j + targetY + scHeight, (float)texX, (float)(texY + scHeight), texW, texH - scHeight, 256, 256);
    }

    public void drawProgress(GuiGraphics guiGraphics) {
        float perc = this.getProgress();
        int texX = 176;
        boolean texY = false;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, i + targetX, j + targetY, (float)texX, (float)texY, scWidth, texH, 256, 256);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.maxStorage;
    }

    public float getCanola() {
        return (float)this.tile.getCurrentCanola() / (float)this.tile.maxCanola;
    }

    public float getMethanol() {
        return (float)this.tile.getCurrentMethanol() / (float)this.tile.maxMethanol;
    }

    public float getMix() {
        return (float)this.tile.getCurrentMix() / (float)this.tile.maxMix;
    }

    public float getProgress() {
        if (this.tile.getTimeToGenerate() == 0) {
            return 0.0f;
        }
        int time = this.tile.generatingTime - this.tile.getTimeToGenerate();
        return (float)time / (float)this.tile.generatingTime;
    }
}

