/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerGasStationAdmin;
import de.maxhenkel.car.net.MessageGasStationAdminAmount;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class GuiGasStationAdmin
extends ScreenBase<ContainerGasStationAdmin> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/gui_gas_station_admin.png");
    private TileEntityGasStation gasStation;
    private Inventory inventoryPlayer;
    private static final int TITLE_COLOR = Color.WHITE.getRGB();
    private static final int FONT_COLOR = Color.DARK_GRAY.getRGB();
    protected EditBox textField;

    public GuiGasStationAdmin(ContainerGasStationAdmin gasStation, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE, gasStation, playerInventory, title);
        this.gasStation = gasStation.getGasStation();
        this.inventoryPlayer = playerInventory;
        this.imageWidth = 176;
        this.imageHeight = 197;
    }

    protected void init() {
        super.init();
        this.textField = new EditBox(this.font, this.leftPos + 54, this.topPos + 22, 100, 16, (Component)Component.translatable((String)"gas_station.admin.amount_text_field"));
        this.textField.setTextColor(-1);
        this.textField.setTextColorUneditable(-1);
        this.textField.setMaxLength(20);
        this.textField.setValue(String.valueOf(this.gasStation.getTradeAmount()));
        this.textField.setResponder(this::onTextChanged);
        this.addRenderableWidget((GuiEventListener)this.textField);
    }

    public void onTextChanged(String text) {
        if (!text.isEmpty()) {
            try {
                int i = Integer.parseInt(text);
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageGasStationAdminAmount(this.gasStation.getBlockPos(), i), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resize(Minecraft mc, int x, int y) {
        String text = this.textField.getValue();
        this.init(mc, x, y);
        this.textField.setValue(text);
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.isEscape()) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return this.textField.keyPressed(event) || this.textField.canConsumeInput() || super.keyPressed(event);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawCenteredString(this.font, Component.translatable((String)"gui.gas_station").getString(), this.imageWidth / 2, 5, TITLE_COLOR);
        guiGraphics.drawString(this.font, this.inventoryPlayer.getDisplayName().getVisualOrderText(), 8, this.imageHeight - 93, FONT_COLOR, false);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

