/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityGenerator;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerGenerator;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class GuiGenerator
extends ScreenBase<ContainerGenerator> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/gui_generator.png");
    private Inventory playerInv;
    private TileEntityGenerator tile;

    public GuiGenerator(ContainerGenerator containerGenerator, Inventory playerInv, Component title) {
        super(GUI_TEXTURE, containerGenerator, playerInv, title);
        this.playerInv = playerInv;
        this.tile = containerGenerator.getGenerator();
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.playerInv.getDisplayName().getVisualOrderText(), 8, this.imageHeight - 96 + 2, -12566464, false);
        guiGraphics.drawString(this.font, this.tile.getDisplayName().getVisualOrderText(), 62, 6, -12566464, false);
        if (mouseX >= this.leftPos + 122 && mouseX <= this.leftPos + 16 + 122 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 57 + 8) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.translatable((String)"tooltip.energy", (Object[])new Object[]{this.tile.getStoredEnergy()}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
        if (mouseX >= this.leftPos + 39 && mouseX <= this.leftPos + 16 + 39 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 57 + 8) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.fuel", (Object[])new Object[]{this.tile.getCurrentMillibuckets()}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawEnergy(guiGraphics);
        this.drawFluid(guiGraphics);
    }

    public void drawEnergy(GuiGraphics guiGraphics) {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 122;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, i + targetX, j + targetY + scHeight, (float)texX, (float)(texY + scHeight), texW, texH - scHeight, 256, 256);
    }

    public void drawFluid(GuiGraphics guiGraphics) {
        float perc = this.getFluid();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 39;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, i + targetX, j + targetY + scHeight, (float)texX, (float)(texY + scHeight), texW, texH - scHeight, 256, 256);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.maxStorage;
    }

    public float getFluid() {
        return (float)this.tile.getCurrentMillibuckets() / (float)this.tile.maxMillibuckets;
    }
}

