/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerSplitTank;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class GuiSplitTank
extends ScreenBase<ContainerSplitTank> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/gui_split_tank.png");
    private Inventory playerInv;
    private TileEntitySplitTank tile;

    public GuiSplitTank(ContainerSplitTank containerSplitTank, Inventory playerInv, Component title) {
        super(GUI_TEXTURE, containerSplitTank, playerInv, title);
        this.playerInv = playerInv;
        this.tile = containerSplitTank.getSplitTank();
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.playerInv.getDisplayName().getVisualOrderText(), 8, this.imageHeight - 96 + 2, -12566464, false);
        if (mouseX >= this.leftPos + 50 && mouseX <= this.leftPos + 16 + 50 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 57 + 8) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.translatable((String)"tooltip.mix", (Object[])new Object[]{this.tile.getCurrentMix()}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
        if (mouseX >= this.leftPos + 120 && mouseX <= this.leftPos + 16 + 120 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 57 + 8) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.glycerin", (Object[])new Object[]{this.tile.getCurrentGlycerin()}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
        if (mouseX >= this.leftPos + 141 && mouseX <= this.leftPos + 16 + 141 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 57 + 8) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.bio_diesel", (Object[])new Object[]{this.tile.getCurrentBioDiesel()}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
        if (mouseX >= this.leftPos + 79 && mouseX <= this.leftPos + 24 + 79 && mouseY >= this.topPos + 34 && mouseY <= this.topPos + 17 + 34) {
            list = new ArrayList();
            list.add(Component.translatable((String)"tooltip.progress", (Object[])new Object[]{(int)(this.getProgress() * 100.0f)}).getVisualOrderText());
            guiGraphics.setTooltipForNextFrame(this.font, list, mouseX, mouseY);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawProgress(guiGraphics);
        this.drawMix(guiGraphics);
        this.drawBioDiesel(guiGraphics);
        this.drawGlycerin(guiGraphics);
    }

    public void drawGlycerin(GuiGraphics guiGraphics) {
        float perc = this.getGlycerin();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 120;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, i + targetX, j + targetY + scHeight, (float)texX, (float)(texY + scHeight), texW, texH - scHeight, 256, 256);
    }

    public void drawBioDiesel(GuiGraphics guiGraphics) {
        float perc = this.getBioDiesel();
        int texX = 208;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 141;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, i + targetX, j + targetY + scHeight, (float)texX, (float)(texY + scHeight), texW, texH - scHeight, 256, 256);
    }

    public void drawMix(GuiGraphics guiGraphics) {
        float perc = this.getMix();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 50;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, i + targetX, j + targetY + scHeight, (float)texX, (float)(texY + scHeight), texW, texH - scHeight, 256, 256);
    }

    public void drawProgress(GuiGraphics guiGraphics) {
        float perc = this.getProgress();
        int texX = 176;
        boolean texY = false;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, i + targetX, j + targetY, (float)texX, (float)texY, scWidth, texH, 256, 256);
    }

    public float getMix() {
        return (float)this.tile.getCurrentMix() / (float)this.tile.maxMix;
    }

    public float getBioDiesel() {
        return (float)this.tile.getCurrentBioDiesel() / (float)this.tile.maxBioDiesel;
    }

    public float getGlycerin() {
        return (float)this.tile.getCurrentGlycerin() / (float)this.tile.maxGlycerin;
    }

    public float getProgress() {
        if (this.tile.getTimeToGenerate() == 0) {
            return 0.0f;
        }
        int time = this.tile.generatingTime - this.tile.getTimeToGenerate();
        return (float)time / (float)this.tile.generatingTime;
    }
}

