/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityFluidExtractor;
import de.maxhenkel.car.corelib.item.ItemUtils;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;

public class SlotFluidFilter
extends Slot {
    private TileEntityFluidExtractor tile;
    private int index;

    public SlotFluidFilter(Container inv, int index, int xPosition, int yPosition, TileEntityFluidExtractor tile) {
        super(inv, index, xPosition, yPosition);
        this.tile = tile;
        this.index = index;
        this.setFluidContained(tile.getFilter());
    }

    public boolean mayPickup(Player playerIn) {
        this.tile.setFilter(ItemStack.EMPTY);
        ItemUtils.removeStackFromSlot(this.container, this.index);
        this.setChanged();
        return false;
    }

    public boolean mayPlace(ItemStack stack) {
        this.setFluidContained(stack);
        return false;
    }

    private void setFluidContained(ItemStack stack) {
        if (stack.isEmpty()) {
            ItemUtils.removeStackFromSlot(this.container, this.index);
            this.setChanged();
            return;
        }
        FluidStack fluidStack = FluidUtil.getFirstStackContained((ItemStack)stack);
        if (fluidStack.isEmpty() || fluidStack.getAmount() <= 0) {
            ItemUtils.removeStackFromSlot(this.container, this.index);
            this.setChanged();
            return;
        }
        this.tile.setFilter(stack);
        Item i = fluidStack.getFluid().getBucket();
        if (i == null) {
            this.container.setItem(this.index, stack.copy());
            this.setChanged();
        } else {
            this.container.setItem(this.index, new ItemStack((ItemLike)i));
            this.setChanged();
        }
    }
}

