/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TileEntityContainerProvider
implements MenuProvider {
    private ContainerCreator container;
    private TileEntityBase tileEntity;

    public TileEntityContainerProvider(ContainerCreator container, TileEntityBase tileEntity) {
        this.container = container;
        this.tileEntity = tileEntity;
    }

    public Component getDisplayName() {
        return this.tileEntity.getDisplayName();
    }

    public static void openGui(ServerPlayer player, TileEntityBase tileEntity, ContainerCreator containerCreator) {
        player.openMenu((MenuProvider)new TileEntityContainerProvider(containerCreator, tileEntity), packetBuffer -> packetBuffer.writeBlockPos(tileEntity.getBlockPos()));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return this.container.create(i, playerInventory, playerEntity);
    }

    public static interface ContainerCreator {
        public AbstractContainerMenu create(int var1, Inventory var2, Player var3);
    }
}

